/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.notification;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionService;
import io.atlassian.fugue.Option;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionNotificationConditionHelper {
    private final NotificationSubscriptionService subscriptionService;
    private final UserFactory userFactory;

    @Autowired
    public SubscriptionNotificationConditionHelper(NotificationSubscriptionService subscriptionService, UserFactory userFactory) {
        this.subscriptionService = subscriptionService;
        this.userFactory = userFactory;
    }

    public boolean canDisplaySubscribeLink(@Nonnull Map<String, Object> contextMap) {
        Option<Boolean> result = this.isSubscribed(contextMap);
        if (result.isEmpty()) {
            return false;
        }
        boolean isSubscribed = (Boolean)result.get();
        return !isSubscribed;
    }

    public boolean canDisplayUnsubscribeLink(@Nonnull Map<String, Object> contextMap) {
        Option<Boolean> result = this.isSubscribed(contextMap);
        if (result.isEmpty()) {
            return false;
        }
        boolean isSubscribed = (Boolean)result.get();
        return isSubscribed;
    }

    private Option<Boolean> isSubscribed(Map<String, Object> contextMap) {
        Option<Issue> issueOption = this.getCurrentIssue(contextMap);
        if (issueOption.isEmpty()) {
            return Option.none();
        }
        Option<CheckedUser> userOption = this.getCurrentUser(contextMap);
        if (userOption.isEmpty()) {
            return Option.none();
        }
        return this.subscriptionService.isSubscribed((CheckedUser)userOption.get(), (Issue)issueOption.get()).toOption();
    }

    private Option<Issue> getCurrentIssue(Map<String, Object> contextMap) {
        Issue issue = (Issue)contextMap.get("issue");
        return Option.option((Object)issue);
    }

    private Option<CheckedUser> getCurrentUser(Map<String, Object> contextMap) {
        ApplicationUser user = (ApplicationUser)contextMap.get("user");
        if (user == null) {
            return Option.none();
        }
        return StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.wrap(user).toOption());
    }
}

