/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.invite;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.PublicAccessCustomerInviteService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteResult;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.invite.RequestParticipantsInvitationService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class RequestParticipantsInvitationServiceImpl
implements RequestParticipantsInvitationService {
    private static final Logger log = LoggerFactory.getLogger(RequestParticipantsInvitationServiceImpl.class);
    private final PublicAccessCustomerInviteService publicAccessCustomerInviteService;
    private final RequestParticipantsInternalService requestParticipantsInternalService;
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final RequestParticipantValidator requestParticipantValidator;
    private final ErrorResultHelper errorResultHelper;
    private final RequestParticipantError requestParticipantError;

    @Autowired
    public RequestParticipantsInvitationServiceImpl(PublicAccessCustomerInviteService publicAccessCustomerInviteService, RequestParticipantsInternalService requestParticipantsInternalService, RequestParticipantPermissionService requestParticipantPermissionService, RequestParticipantValidator requestParticipantValidator, ErrorResultHelper errorResultHelper, RequestParticipantError requestParticipantError) {
        this.publicAccessCustomerInviteService = publicAccessCustomerInviteService;
        this.requestParticipantsInternalService = requestParticipantsInternalService;
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.requestParticipantValidator = requestParticipantValidator;
        this.errorResultHelper = errorResultHelper;
        this.requestParticipantError = requestParticipantError;
    }

    @Override
    public RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result filterParticipantEmailsPhase1(Set<String> allEmails, Option<CheckedUser> reporter, Set<CheckedUser> currentRequestParticipants) {
        Option reporterEmail = reporter.map(CheckedUser::getEmailAddress);
        List<String> participantEmails = this.transformCheckedUserToEmailAddresses(currentRequestParticipants);
        Collection filtered = Collections2.filter(allEmails, (Predicate)Predicates.not(EmailUtil.createEmailIsReporterOrExistingParticipantPredicate((Option<String>)reporterEmail, participantEmails)));
        return new RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result(filtered);
    }

    @Override
    public RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result filterParticipantEmailsPhase2(CheckedUser user, ServiceDesk serviceDesk, Project project, RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result participantsInviteFilterPhase1Result) {
        Assertions.is((String)"filter results valid", (boolean)participantsInviteFilterPhase1Result.isValid());
        Set<String> emailsToInvite = participantsInviteFilterPhase1Result.getEmailAddresses().stream().filter(email -> this.publicAccessCustomerInviteService.isNewCustomerAndSignupPossibleForParticipantsInPortalContext(user, (String)email, serviceDesk, project)).collect(Collectors.toSet());
        log.trace("Found the following potential participants that can possibly invite : {}", emailsToInvite);
        return new RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result(emailsToInvite, serviceDesk, project);
    }

    @Override
    public Either<AnError, JSDSuccess> rateLimitParticipantsInviteCheck(RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result participantsInviteFilterPhase2Result) {
        if (participantsInviteFilterPhase2Result.getEmailAddresses().size() <= MAX_NUMBER_OF_NEW_USERS_IN_ONE_REQUEST) {
            return Either.right((Object)((Object)JSDSuccess.success()));
        }
        return Either.left((Object)this.requestParticipantError.RATE_LIMIT_REQUEST_PARTICIPANT_FAIL(MAX_NUMBER_OF_NEW_USERS_IN_ONE_REQUEST));
    }

    @Override
    public Either<AnError, RequestParticipantsInvitationService.ParticipantsInviteInvitationResult> inviteNewParticipants(CheckedUser checkedUser, Issue issue, RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result participantsInviteFilterPhase2Result) {
        Assertions.is((String)"filter results valid", (boolean)participantsInviteFilterPhase2Result.isValid());
        ServiceDesk serviceDesk = participantsInviteFilterPhase2Result.getServiceDesk();
        Project project = participantsInviteFilterPhase2Result.getProject();
        if (this.requestParticipantPermissionService.canAddAnyParticipant(checkedUser, issue)) {
            Set<String> emailAddresses = participantsInviteFilterPhase2Result.getEmailAddresses();
            log.debug("Attempting to invite {} users as potential request participants, whose email addresses were included inside details for {}", (Object)emailAddresses.size(), (Object)issue.getKey());
            Either<AnError, InviteCustomerResult> result = this.publicAccessCustomerInviteService.signupCustomersAndSendInvitesForParticipantsInPortalContext(checkedUser, serviceDesk, project, emailAddresses);
            result.left().forEach(error -> log.warn("There was a problem while inviting {} users as potential request participants, whose email addresses were included inside details for : {}", new Object[]{emailAddresses.size(), issue.getKey(), error.getMessage().getMessage()}));
            return result.map(inviteResult -> {
                if (inviteResult.hasFailedInvite()) {
                    log.debug("Failed to invite {} users as potential request participants, whose email addresses were included inside details for {} : '{}'", new Object[]{inviteResult.getFailedInvites().size(), issue.getKey(), this.transformInviteResultToEmailAddresses(inviteResult.getFailedInvites())});
                }
                log.debug("Successfully invited {} users as potential request participants, whose were included inside details for {} : '{}'", new Object[]{inviteResult.getSuccessInvites().size(), issue.getKey(), this.transformInviteResultToEmailAddresses(inviteResult.getSuccessInvites())});
                return new RequestParticipantsInvitationService.ParticipantsInviteInvitationResult(issue, (InviteCustomerResult)inviteResult);
            });
        }
        return Either.left((Object)this.errorResultHelper.forbidden403("sd.request.participants.no.permission.manage.settings", new Object[0]).build());
    }

    @Override
    public Either<AnError, List<CheckedUser>> addInvitedParticipantsToIssue(CheckedUser checkedUser, RequestParticipantsInvitationService.ParticipantsInviteInvitationResult participantsInviteInvitationResult, boolean useSuccessInvitesOnly) {
        Assertions.is((String)"invite results valid", (boolean)participantsInviteInvitationResult.isValid());
        Issue issue = participantsInviteInvitationResult.getIssue();
        ArrayList participantsByEmails = Lists.newArrayList(this.requestParticipantValidator.getParticipantsByEmails(useSuccessInvitesOnly ? participantsInviteInvitationResult.getSuccessInviteEmails() : participantsInviteInvitationResult.getAllResultEmails(), issue));
        if (!participantsByEmails.isEmpty()) {
            log.debug("Start attempt to add {} new request participants, whose email addresses were included inside details for {} : {}", new Object[]{participantsByEmails.size(), issue.getKey(), this.transformCheckedUserToEmailAddresses(participantsByEmails)});
            Either<AnError, List<CheckedUser>> anErrorListEither = this.requestParticipantsInternalService.addParticipants(checkedUser, issue, participantsByEmails);
            anErrorListEither.left().forEach(error -> log.warn("Failed to add {} new request participants for issue {} : {}", new Object[]{participantsByEmails.size(), issue.getKey(), error.getMessage().getMessage()}));
            anErrorListEither.forEach(newUsers -> log.debug("Success in adding of {} new request participants for {}. Request Participants is now : {}", new Object[]{newUsers.size(), issue.getKey(), this.transformCheckedUserToEmailAddresses((Collection<CheckedUser>)newUsers)}));
            return anErrorListEither;
        }
        log.debug("Found no new invited users to add as new participants, or have no permission, for {}", (Object)issue.getKey());
        return this.requestParticipantsInternalService.getValidParticipants(checkedUser, issue);
    }

    private List<String> transformInviteResultToEmailAddresses(List<? extends InviteResult> inviteResults) {
        return inviteResults.stream().map(InviteResult::getEmailAddressOrUsername).collect(Collectors.toList());
    }

    private List<String> transformCheckedUserToEmailAddresses(Collection<CheckedUser> users) {
        return users.stream().map(CheckedUser::getEmailAddress).collect(Collectors.toList());
    }
}

