/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.invite;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.FailedInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface RequestParticipantsInvitationService {
    public static final Integer MAX_NUMBER_OF_NEW_USERS_IN_ONE_REQUEST = 25;

    public ParticipantsInviteFilterPhase1Result filterParticipantEmailsPhase1(Set<String> var1, Option<CheckedUser> var2, Set<CheckedUser> var3);

    public ParticipantsInviteFilterPhase2Result filterParticipantEmailsPhase2(CheckedUser var1, ServiceDesk var2, Project var3, ParticipantsInviteFilterPhase1Result var4);

    public Either<AnError, JSDSuccess> rateLimitParticipantsInviteCheck(ParticipantsInviteFilterPhase2Result var1);

    public Either<AnError, ParticipantsInviteInvitationResult> inviteNewParticipants(CheckedUser var1, Issue var2, ParticipantsInviteFilterPhase2Result var3);

    default public Either<AnError, List<CheckedUser>> addInvitedParticipantsToIssue(CheckedUser checkedUser, ParticipantsInviteInvitationResult participantsInviteInvitationResult) {
        return this.addInvitedParticipantsToIssue(checkedUser, participantsInviteInvitationResult, true);
    }

    public Either<AnError, List<CheckedUser>> addInvitedParticipantsToIssue(CheckedUser var1, ParticipantsInviteInvitationResult var2, boolean var3);

    @ParametersAreNonnullByDefault
    public static final class ParticipantsInviteInvitationResult {
        private final Option<InviteCustomerResult> inviteCustomerResult;
        private final Option<Issue> issue;

        public ParticipantsInviteInvitationResult(Issue issue, InviteCustomerResult inviteCustomerResult) {
            this.issue = Option.option((Object)issue);
            this.inviteCustomerResult = Option.option((Object)inviteCustomerResult);
        }

        public Issue getIssue() {
            return (Issue)this.issue.getOrNull();
        }

        public Set<String> getSuccessInviteEmails() {
            return ImmutableSet.copyOf((Collection)((Collection)this.inviteCustomerResult.map(result -> result.getSuccessInvites().stream().map(SuccessInviteResult::getEmailAddressOrUsername).collect(Collectors.toSet())).getOrElse(Collections.emptySet())));
        }

        public Set<String> getFailedInviteEmails() {
            return ImmutableSet.copyOf((Collection)((Collection)this.inviteCustomerResult.map(result -> result.getFailedInvites().stream().map(FailedInviteResult::getEmailAddressOrUsername).collect(Collectors.toSet())).getOrElse(Collections.emptySet())));
        }

        public Set<String> getAllResultEmails() {
            return ImmutableSet.copyOf((Iterable)Iterables.concat(this.getSuccessInviteEmails(), this.getFailedInviteEmails()));
        }

        public boolean isValid() {
            return this.inviteCustomerResult.isDefined() && this.issue.isDefined();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParticipantsInviteInvitationResult)) {
                return false;
            }
            ParticipantsInviteInvitationResult that = (ParticipantsInviteInvitationResult)o;
            return Objects.equal(this.inviteCustomerResult, that.inviteCustomerResult) && Objects.equal(this.issue, that.issue);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.inviteCustomerResult, this.issue});
        }
    }

    @ParametersAreNonnullByDefault
    public static final class ParticipantsInviteFilterPhase2Result {
        private final Set<String> emailAddresses;
        private final Option<ServiceDesk> serviceDesk;
        private final Option<Project> project;

        public ParticipantsInviteFilterPhase2Result(Collection<String> emailAddresses, ServiceDesk serviceDesk, Project project) {
            this.emailAddresses = ImmutableSet.copyOf(emailAddresses);
            this.serviceDesk = Option.option((Object)serviceDesk);
            this.project = Option.option((Object)project);
        }

        public Project getProject() {
            return (Project)this.project.getOrNull();
        }

        public ServiceDesk getServiceDesk() {
            return (ServiceDesk)this.serviceDesk.getOrNull();
        }

        public Set<String> getEmailAddresses() {
            return this.emailAddresses;
        }

        public boolean isValid() {
            return !this.emailAddresses.isEmpty() && this.serviceDesk.isDefined() && this.project.isDefined();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParticipantsInviteFilterPhase2Result)) {
                return false;
            }
            ParticipantsInviteFilterPhase2Result that = (ParticipantsInviteFilterPhase2Result)o;
            return Objects.equal(this.emailAddresses, that.emailAddresses) && Objects.equal(this.serviceDesk, that.serviceDesk) && Objects.equal(this.project, that.project);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.emailAddresses, this.serviceDesk, this.project});
        }
    }

    @ParametersAreNonnullByDefault
    public static final class ParticipantsInviteFilterPhase1Result {
        private final Set<String> emailAddresses;

        public ParticipantsInviteFilterPhase1Result(Collection<String> emailAddresses) {
            this.emailAddresses = ImmutableSet.copyOf(emailAddresses);
        }

        public Set<String> getEmailAddresses() {
            return this.emailAddresses;
        }

        public boolean isValid() {
            return !this.emailAddresses.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParticipantsInviteFilterPhase1Result)) {
                return false;
            }
            ParticipantsInviteFilterPhase1Result that = (ParticipantsInviteFilterPhase1Result)o;
            return Objects.equal(this.emailAddresses, that.emailAddresses);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.emailAddresses});
        }
    }
}

