/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.field;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantsInternalServiceImpl
implements RequestParticipantsInternalService {
    private final RequestParticipantsInternalManager requestParticipantManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final RequestParticipantError requestParticipantError;
    private final FeatureManager featureManager;
    private final CustomerOrganizationMemberManager organizationMemberManager;
    private final ErrorResultHelper errorResultHelper;
    private final CommonErrors commonErrors;
    private final CustomerServiceValidator customerServiceValidator;
    private final IssueHelper issueHelper;
    private final ServiceDeskManager serviceDeskManager;
    private final PermissionManager permissionManager;
    private final OutsiderPermissionChecker outsiderPermissionChecker;

    @Autowired
    public RequestParticipantsInternalServiceImpl(RequestParticipantsInternalManager requestParticipantManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, RequestParticipantPermissionService requestParticipantPermissionService, RequestParticipantError requestParticipantError, FeatureManager featureManager, CustomerOrganizationMemberManager organizationMemberManager, ErrorResultHelper errorResultHelper, CommonErrors commonErrors, CustomerServiceValidator customerServiceValidator, IssueHelper issueHelper, ServiceDeskManager serviceDeskManager, PermissionManager permissionManager, OutsiderPermissionChecker outsiderPermissionChecker) {
        this.requestParticipantManager = requestParticipantManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.requestParticipantError = requestParticipantError;
        this.featureManager = featureManager;
        this.organizationMemberManager = organizationMemberManager;
        this.errorResultHelper = errorResultHelper;
        this.commonErrors = commonErrors;
        this.customerServiceValidator = customerServiceValidator;
        this.issueHelper = issueHelper;
        this.serviceDeskManager = serviceDeskManager;
        this.permissionManager = permissionManager;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
    }

    @Override
    public Either<AnError, List<CheckedUser>> getValidParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue) {
        return Steps.begin(this.canViewRequestInPortal(currentUser, issue)).then(hasPermission -> this.requestParticipantManager.getValidParticipants(issue)).yield((hasPermission, participants) -> participants);
    }

    @Override
    public Either<AnError, List<CheckedUser>> getAllExistingParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue) {
        return Steps.begin(this.canViewRequestInPortal(currentUser, issue)).then(hasPermission -> this.requestParticipantManager.getAllExistingParticipants(issue)).yield((hasPermission, participants) -> participants);
    }

    @Override
    public Either<AnError, List<CheckedUser>> addParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue, @Nonnull List<CheckedUser> userParticipantsToAdd) {
        return Steps.begin(this.validateAddParticipantAgainstCustomerPermission(currentUser, issue, userParticipantsToAdd)).then(hasPermission -> this.requestParticipantManager.addParticipants(currentUser, issue, userParticipantsToAdd)).yield((hasPermission, addedParticipants) -> addedParticipants);
    }

    @Override
    public Either<AnError, List<CheckedUser>> removeParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue, @Nonnull List<CheckedUser> userParticipantsToRemove) {
        return Steps.begin(this.canRemoveAnyParticipant(currentUser, issue)).then(hasPermission -> this.requestParticipantManager.removeParticipants(currentUser, issue, userParticipantsToRemove)).yield((hasPermission, removedParticipants) -> removedParticipants);
    }

    @Override
    public Either<AnError, JSDSuccess> validateRequestParticipantFieldIssueCreationParam(CheckedUser user, ServiceDesk serviceDesk, Project project, Map<String, String[]> formValues) {
        Either<AnError, List<CheckedUser>> validatedParticipantsResult = this.requestParticipantManager.validateRequestParticipantFieldIssueCreationParam(serviceDesk, project, formValues);
        if (validatedParticipantsResult.isLeft()) {
            return Either.left((Object)validatedParticipantsResult.left().get());
        }
        List validatedParticipants = (List)validatedParticipantsResult.right().get();
        if (validatedParticipants.isEmpty()) {
            return Either.right((Object)((Object)JSDSuccess.success()));
        }
        return this.validateAddParticipantOnRequestCreatedAgainstCustomerPermission(user, serviceDesk, project, validatedParticipants).map(unit -> JSDSuccess.success());
    }

    private Either<AnError, Unit> canViewRequestInPortal(CheckedUser user, Issue issue) {
        if (!this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)user, issue)) {
            return Either.left((Object)this.requestParticipantError.NO_VIEW_PARTICIPANT_OF_ISSUE_PERMISSION());
        }
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, Unit> canRemoveAnyParticipant(CheckedUser user, Issue issue) {
        if (this.requestParticipantPermissionService.canAddAnyParticipant(user, issue)) {
            return Either.right((Object)Unit.Unit());
        }
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.canViewRequestInPortal(user, issue).flatMap(unit -> {
                if (!this.outsiderPermissionChecker.isUserAnOutsider(user, issue) && this.hasEditIssuePermission(user, (Option<Issue>)Option.some((Object)issue))) {
                    return Either.right((Object)Unit.Unit());
                }
                return Either.left((Object)this.requestParticipantError.NO_EDIT_PARTICIPANT_PERMISSION());
            });
        }
        return Either.left((Object)this.requestParticipantError.NO_EDIT_PARTICIPANT_PERMISSION());
    }

    @Override
    public Either<AnError, JSDSuccess> validateAddParticipantAgainstCustomerPermission(CheckedUser user, Issue issue, List<CheckedUser> userParticipantsToAdd) {
        if (!this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)user, issue) || this.outsiderPermissionChecker.isUserAnOutsider(user, issue)) {
            return Either.left((Object)this.requestParticipantError.NO_VIEW_PARTICIPANT_OF_ISSUE_PERMISSION());
        }
        if (this.requestParticipantPermissionService.canAddAnyParticipant(user, issue)) {
            return Either.right((Object)((Object)JSDSuccess.success()));
        }
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.validateAddParticipantsAgainstOrganisationMembership(user, (Option<Issue>)Option.some((Object)issue), issue.getProjectObject(), userParticipantsToAdd).map(unit -> JSDSuccess.success());
        }
        return Either.left((Object)this.requestParticipantError.NO_EDIT_PARTICIPANT_PERMISSION());
    }

    @Override
    public Either<AnError, Unit> validateAddOutsiderAsParticipant(CheckedUser user, Issue issue, CheckedUser outsiderParticipantToAdd) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return Steps.begin(this.validateAddParticipantAgainstCustomerPermission(user, issue, (List<CheckedUser>)ImmutableList.of((Object)outsiderParticipantToAdd))).then(() -> this.issueHelper.getProjectFromIssue(issue)).then((success, project) -> this.serviceDeskManager.getServiceDeskForProject(project)).then((jsdSuccess, project, serviceDesk) -> this.isCustomerOrCanInviteOutsider(user, (Project)project, issue, (ServiceDesk)serviceDesk, outsiderParticipantToAdd)).yield((jsdSuccess, project, serviceDesk, unit) -> Unit.Unit());
    }

    private Either<AnError, Unit> isCustomerOrCanInviteOutsider(CheckedUser user, Project project, Issue issue, ServiceDesk serviceDesk, CheckedUser potentialCustomer) {
        if (this.customerServiceValidator.isCustomerForProject(potentialCustomer, project) && this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)user, issue) || this.customerServiceValidator.isUserAllowedInviteOutsiderCustomer(user, project, serviceDesk)) {
            if (potentialCustomer.forJIRA().isActive()) {
                return Either.right((Object)Unit.Unit());
            }
            return Either.left((Object)this.commonErrors.USER_IS_NOT_ACTIVE());
        }
        return Either.left((Object)this.requestParticipantError.NO_EDIT_PARTICIPANT_PERMISSION());
    }

    private Either<AnError, Unit> validateAddParticipantOnRequestCreatedAgainstCustomerPermission(CheckedUser user, ServiceDesk serviceDesk, Project project, List<CheckedUser> userParticipantsToAdd) {
        if (!this.serviceDeskLicenseAndPermissionService.canCreateRequest((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.NO_PERMISSION_TO_CREATE_REQUEST());
        }
        if (this.requestParticipantPermissionService.canCreateRequestWithAnyParticipant(user, serviceDesk, project)) {
            return Either.right((Object)Unit.Unit());
        }
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.validateAddParticipantsAgainstOrganisationMembership(user, (Option<Issue>)Option.none(), project, userParticipantsToAdd);
        }
        return Either.left((Object)this.NO_ADD_PARTICIPANT_TO_REQUEST_PORTAL_PERMISSION());
    }

    private Either<AnError, Unit> validateAddParticipantsAgainstOrganisationMembership(CheckedUser user, Option<Issue> issueOption, Project project, List<CheckedUser> userParticipantsToAdd) {
        if (!this.hasEditIssuePermission(user, issueOption)) {
            return Either.left((Object)this.requestParticipantError.NO_EDIT_PARTICIPANT_PERMISSION());
        }
        Collection<CheckedUser> differentOrganisationUsers = this.organizationMemberManager.filterUsersNotInMyOrganization(user, project, userParticipantsToAdd);
        if (differentOrganisationUsers.isEmpty()) {
            return Either.right((Object)Unit.Unit());
        }
        Set<String> differentOrganisationUsernames = differentOrganisationUsers.stream().map(CheckedUser::getName).collect(Collectors.toSet());
        return Either.left((Object)this.PARTICIPANT_NOT_IN_SAME_ORGANISATION_ERROR(differentOrganisationUsernames));
    }

    private boolean hasEditIssuePermission(CheckedUser user, Option<Issue> issueOption) {
        return (Boolean)issueOption.map(issue -> this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user.forJIRA())).getOr(Suppliers.alwaysTrue());
    }

    private AnError PARTICIPANT_NOT_IN_SAME_ORGANISATION_ERROR(Set<String> invalidParticipantUserNames) {
        return this.errorResultHelper.badRequest400("sd.request.participants.not.in.same.organisation.error", new Object[]{StringUtils.join(invalidParticipantUserNames, (String)", ")}).build();
    }

    private AnError NO_ADD_PARTICIPANT_TO_REQUEST_PORTAL_PERMISSION() {
        return this.errorResultHelper.forbidden403("sd.request.participants.portal.validate.no.permission", new Object[0]).build();
    }
}

