/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.field;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantsInternalManagerImpl
implements RequestParticipantsInternalManager {
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final RequestParticipantValidator requestParticipantValidator;
    private final RequestParticipantError requestParticipantError;
    private final UserFactory userFactory;

    @Autowired
    public RequestParticipantsInternalManagerImpl(ParticipantsCustomFieldManager participantsCustomFieldManager, RequestParticipantValidator requestParticipantValidator, RequestParticipantError requestParticipantError, UserFactory userFactory) {
        this.participantsCustomFieldManager = participantsCustomFieldManager;
        this.requestParticipantValidator = requestParticipantValidator;
        this.requestParticipantError = requestParticipantError;
        this.userFactory = userFactory;
    }

    @Override
    public Either<AnError, List<CheckedUser>> getValidParticipants(@Nonnull Issue issue) {
        return this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue).map(uncheckedParticipants -> Lists.newArrayList(this.requestParticipantValidator.filterUsersWhoCannotBeParticipants((Collection<CheckedUser>)uncheckedParticipants, issue)));
    }

    @Override
    public Either<AnError, List<CheckedUser>> getAllExistingParticipants(@Nonnull Issue issue) {
        return this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue).map(ImmutableList::copyOf);
    }

    @Override
    public boolean isUserInParticipantList(CheckedUser checkedUser, Issue issue) {
        List participantList = (List)this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue).map(participants -> participants.stream().filter(participant -> participant.equals(checkedUser)).filter(participant -> this.requestParticipantValidator.canUserBeParticipant((CheckedUser)participant, issue)).collect(Collectors.toList())).getOrElse(Collections.emptyList());
        return !participantList.isEmpty();
    }

    @Override
    public Either<AnError, List<CheckedUser>> addParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue, @Nonnull List<CheckedUser> userParticipantsToAdd) {
        return Steps.begin(this.validateParticipants(issue, userParticipantsToAdd)).then(validatedParticipantsToAdd -> this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue)).then((validatedParticipantsToAdd, existingParticipants) -> {
            HashSet<CheckedUser> updatedParticipantsSet = new HashSet<CheckedUser>((Collection<CheckedUser>)existingParticipants);
            boolean modified = updatedParticipantsSet.addAll((Collection<CheckedUser>)validatedParticipantsToAdd);
            if (modified) {
                return this.updateParticipantsField(currentUser, issue, updatedParticipantsSet);
            }
            return this.getValidParticipants(issue);
        }).yield((validatedParticipantsToAdd, existingParticipants, updatedParticipants) -> updatedParticipants);
    }

    @Override
    public Either<AnError, List<CheckedUser>> removeParticipants(@Nonnull CheckedUser currentUser, @Nonnull Issue issue, @Nonnull List<CheckedUser> userParticipantsToRemove) {
        return Steps.begin(this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue)).then(existingParticipants -> {
            HashSet<CheckedUser> updatedParticipantsSet = new HashSet<CheckedUser>((Collection<CheckedUser>)existingParticipants);
            boolean modified = updatedParticipantsSet.removeAll(userParticipantsToRemove);
            if (modified) {
                return this.updateParticipantsField(currentUser, issue, updatedParticipantsSet);
            }
            return Either.right((Object)Lists.newArrayList((Iterable)existingParticipants));
        }).yield((existingParticipants, updatedParticipants) -> updatedParticipants);
    }

    @Override
    public Either<AnError, List<CheckedUser>> validateRequestParticipantFieldIssueCreationParam(ServiceDesk serviceDesk, Project project, Map<String, String[]> formValues) {
        CustomField participantsCustomField = this.participantsCustomFieldManager.getParticipantsCustomField();
        ArrayList participants = formValues.containsKey(participantsCustomField.getId()) ? Lists.newArrayList((Object[])formValues.get(participantsCustomField.getId())) : Collections.emptyList();
        if (participants.isEmpty()) {
            return Either.right(new ArrayList());
        }
        return this.validateUserNameAsParticipants(participants, project);
    }

    private Either<AnError, List<CheckedUser>> validateUserNameAsParticipants(List<String> userNames, Project project) {
        List wrapped = userNames.stream().map(arg_0 -> ((UserFactory)this.userFactory).wrapUsername(arg_0)).map(StepsConverters::newerEither).collect(Collectors.toList());
        List validParticipants = Lists.newArrayList((Iterable)Eithers.filterRight(wrapped)).stream().filter(user -> this.requestParticipantValidator.canUserBeParticipantOnProject((CheckedUser)user, project)).collect(Collectors.toList());
        List validParticipantUsernames = validParticipants.stream().map(CheckedUser::getName).collect(Collectors.toList());
        Set<String> invalidParticipants = userNames.stream().filter(username -> !validParticipantUsernames.contains(username)).collect(Collectors.toSet());
        if (!invalidParticipants.isEmpty()) {
            return Either.left((Object)this.requestParticipantError.INVALID_PARTICIPANT_USERNAMES_ERROR(invalidParticipants));
        }
        return Either.right(validParticipants);
    }

    private Either<AnError, List<CheckedUser>> validateParticipants(Issue issue, List<CheckedUser> requestParticipantsToAdd) {
        Set<String> invalidParticipants = requestParticipantsToAdd.stream().filter(participant -> !this.requestParticipantValidator.canUserBeParticipant((CheckedUser)participant, issue)).map(CheckedUser::getName).collect(Collectors.toSet());
        if (!invalidParticipants.isEmpty()) {
            return Either.left((Object)this.requestParticipantError.INVALID_PARTICIPANT_USERNAMES_ERROR(invalidParticipants));
        }
        return Either.right(requestParticipantsToAdd);
    }

    private Either<AnError, List<CheckedUser>> updateParticipantsField(CheckedUser currentUser, Issue issue, Set<CheckedUser> participants) {
        return Steps.begin(this.participantsCustomFieldManager.updateUserParticipants(currentUser, issue, participants)).then(success -> this.getValidParticipants(issue)).yield((success, updatedParticipants) -> updatedParticipants);
    }
}

