/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantQuery;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantService;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantUpdateParameters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.RequestParticipantQueryImpl;
import com.atlassian.servicedesk.internal.feature.reqparticipants.RequestParticipantUpdateParametersImpl;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestParticipantServiceImpl
implements RequestParticipantService {
    private final RequestParticipantsInternalService requestParticipantsInternalService;
    private final UserFactory userFactory;
    private final InternalCustomerRequestService internalCustomerRequestService;

    @Autowired
    public RequestParticipantServiceImpl(RequestParticipantsInternalService requestParticipantsInternalService, UserFactory userFactory, InternalCustomerRequestService internalCustomerRequestService) {
        this.requestParticipantsInternalService = requestParticipantsInternalService;
        this.userFactory = userFactory;
        this.internalCustomerRequestService = internalCustomerRequestService;
    }

    public RequestParticipantQuery.Builder newQueryBuilder() {
        return RequestParticipantQueryImpl.builder();
    }

    public Either<AnError, PagedResponse<ApplicationUser>> getRequestParticipants(ApplicationUser applicationUser, RequestParticipantQuery requestParticipantQuery) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser))).then(checkedUser -> this.internalCustomerRequestService.getRequestForId(applicationUser, requestParticipantQuery.customerRequest())).then(this::getParticipantsByIssue).yield((checkedUser, issue, participants) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)requestParticipantQuery.pagedRequest(), (List)participants)));
    }

    public RequestParticipantUpdateParameters.Builder newUpdateBuilder() {
        return RequestParticipantUpdateParametersImpl.builder();
    }

    public Either<AnError, PagedResponse<ApplicationUser>> addRequestParticipants(ApplicationUser applicationUser, RequestParticipantUpdateParameters requestParticipantUpdateParameters) {
        Long issueId = requestParticipantUpdateParameters.customerRequest().getIssue().getId();
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser))).then(currentUser -> this.internalCustomerRequestService.getRequestForId(applicationUser, issueId)).then((currentUser, issue) -> StepsConverters.newerEither((Either)this.userFactory.wrap((Collection)requestParticipantUpdateParameters.requestParticipants()))).then(this::doAddParticipantToIssue).yield((currentUser, issue, usersToAdd, participantLists) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)LimitedPagedRequestImpl.create((int)50), (List)participantLists)));
    }

    public Either<AnError, PagedResponse<ApplicationUser>> removeRequestParticipants(ApplicationUser applicationUser, RequestParticipantUpdateParameters requestParticipantUpdateParameters) {
        Long issueId = requestParticipantUpdateParameters.customerRequest().getIssue().getId();
        return StepsConverters.olderEither((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser))).then(() -> this.internalCustomerRequestService.getRequestForId(applicationUser, issueId)).then(() -> StepsConverters.newerEither((Either)this.userFactory.wrap((Collection)requestParticipantUpdateParameters.requestParticipants()))).then(this::doRemoveParticipantsFromIssue).yield((checkedUser, issue, usersToRemove, participantLists) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)LimitedPagedRequestImpl.create((int)50), (List)participantLists)));
    }

    private io.atlassian.fugue.Either<AnError, List<ApplicationUser>> getParticipantsByIssue(CheckedUser checkedUser, Issue issue) {
        return this.requestParticipantsInternalService.getValidParticipants(checkedUser, issue).map(this::sortByName);
    }

    private io.atlassian.fugue.Either<AnError, List<ApplicationUser>> doAddParticipantToIssue(CheckedUser loggedInUser, Issue issue, List<CheckedUser> participants) {
        return this.requestParticipantsInternalService.addParticipants(loggedInUser, issue, participants).map(this::sortByName);
    }

    private io.atlassian.fugue.Either<AnError, List<ApplicationUser>> doRemoveParticipantsFromIssue(CheckedUser loggedInUser, Issue issue, List<CheckedUser> participants) {
        return this.requestParticipantsInternalService.removeParticipants(loggedInUser, issue, participants).map(this::sortByName);
    }

    private List<ApplicationUser> sortByName(List<CheckedUser> checkedUsers) {
        ArrayList users = Lists.newArrayList((Iterable)Lists.transform(checkedUsers, CheckedUser::forJIRA));
        users.sort(new ApplicationUserBestNameComparator());
        return users;
    }
}

