/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants;

import com.atlassian.annotations.Internal;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;

@Internal
public class RequestParticipantQueryImpl
implements RequestParticipantQuery {
    private final Long customerRequest;
    private final LimitedPagedRequest pagedRequest;

    private RequestParticipantQueryImpl(long customerRequest, LimitedPagedRequest pagedRequest) {
        this.customerRequest = customerRequest;
        this.pagedRequest = pagedRequest;
    }

    public Long customerRequest() {
        return this.customerRequest;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public static RequestParticipantQuery.Builder builder() {
        return new RequestParticipantQueryBuilder();
    }

    private static final class RequestParticipantQueryBuilder
    implements RequestParticipantQuery.Builder {
        private Long customerRequest;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)50);

        private RequestParticipantQueryBuilder() {
        }

        public RequestParticipantQuery.Builder customerRequest(Long customerRequest) {
            this.customerRequest = customerRequest;
            return this;
        }

        public RequestParticipantQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
            return this;
        }

        public RequestParticipantQuery build() {
            return new RequestParticipantQueryImpl(this.customerRequest, this.pagedRequest);
        }
    }
}

