/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.events.UserChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.events.UsersAddedToCustomField;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.NewlyAddedParticipantsHelper;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class NewlyAddedParticipantsHelperImpl
implements NewlyAddedParticipantsHelper {
    private final RequestParticipantsInternalManager requestParticipantsManager;
    private final RequestParticipantValidator requestParticipantValidator;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final UserChangeItemBeanUtils userChangeItemBeanUtils;
    private final IssueEventHelper issueEventUtil;

    @Autowired
    public NewlyAddedParticipantsHelperImpl(RequestParticipantsInternalManager requestParticipantsManager, RequestParticipantValidator requestParticipantValidator, ParticipantsCustomFieldManager participantsCustomFieldManager, UserChangeItemBeanUtils userChangeItemBeanUtils, IssueEventHelper issueEventUtil) {
        this.requestParticipantsManager = requestParticipantsManager;
        this.requestParticipantValidator = requestParticipantValidator;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
        this.userChangeItemBeanUtils = userChangeItemBeanUtils;
        this.issueEventUtil = issueEventUtil;
    }

    public List<CheckedUser> getNewParticipants(IssueEvent issueEvent) {
        boolean isCreated = this.issueEventUtil.isCreatedEvent(issueEvent);
        Issue issue = issueEvent.getIssue();
        List changeItemBeans = this.issueEventUtil.getChangeItemBeans(issueEvent);
        return this.getNewParticipants(isCreated, issue, changeItemBeans);
    }

    public List<CheckedUser> getNewParticipants(boolean isCreatedEvent, Issue issue, Collection<ChangeItemBean> changeItemBeans) {
        if (isCreatedEvent) {
            return this.getNewParticipantsOnCreate(issue);
        }
        return this.getNewParticipantsOnChange(issue, changeItemBeans);
    }

    private List<CheckedUser> getNewParticipantsOnChange(Issue issue, Collection<ChangeItemBean> changeItemBeans) {
        if (issue == null) {
            return Collections.emptyList();
        }
        CustomField participantsCustomField = this.participantsCustomFieldManager.getParticipantsCustomField();
        if (participantsCustomField == null) {
            return Collections.emptyList();
        }
        return (List)this.userChangeItemBeanUtils.findNewlyAddedUsersFromIssueEvent(changeItemBeans, participantsCustomField).map(UsersAddedToCustomField::getAddedUsers).map(addedUsers -> this.requestParticipantValidator.filterUsersWhoCannotBeParticipants((Collection<CheckedUser>)addedUsers, issue).stream().collect(Collectors.toList())).getOrElse(Collections.emptyList());
    }

    private List<CheckedUser> getNewParticipantsOnCreate(Issue issue) {
        if (issue == null) {
            return Collections.emptyList();
        }
        return (List)this.requestParticipantsManager.getValidParticipants(issue).getOrElse(Collections.emptyList());
    }
}

