/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.report;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.feature.report.SeriesMapper;
import com.atlassian.servicedesk.internal.feature.report.series.GoalUpdateInfo;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesImpl;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SeriesQStoreImpl
implements SeriesQStore {
    private final DatabaseAccessor dbAccessor;

    @Autowired
    public SeriesQStoreImpl(DatabaseAccessor dbAccessor) {
        this.dbAccessor = dbAccessor;
    }

    @Override
    public Option<Series> getSeries(int seriesId) {
        Series series = (Series)this.dbAccessor.runInTransaction(conn -> (SeriesImpl)((SQLQuery)((SQLQuery)conn.select((Expression)new SeriesMapper()).from((Expression)Tables.SERIES)).where((Predicate)Tables.SERIES.ID.eq((Object)seriesId))).fetchFirst());
        return Option.option((Object)series);
    }

    @Override
    public Option<Series> createSeries(Report report, Series series) {
        Timestamp now = new Timestamp(new Date().getTime());
        Integer seriesId = (Integer)this.dbAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.SERIES).set((Path)Tables.SERIES.COLOR, (Object)series.getColor()).set((Path)Tables.SERIES.JQL, (Object)series.getJql()).set(Tables.SERIES.REPORT_ID, (Object)report.getId().intValue()).set((Path)Tables.SERIES.SERIES_DATA_TYPE, (Object)series.getSeriesType().getTypeKey()).set(Tables.SERIES.TIME_METRIC_ID, (Object)series.getTimeMetricId()).set((Path)Tables.SERIES.SERIES_LABEL, (Object)series.getLabel()).set(Tables.SERIES.GOAL_ID, (Object)series.getGoalId()).set(Tables.SERIES.CREATED_DATE, (Object)now).set(Tables.SERIES.UPDATED_DATE, (Object)now).executeWithKey(Tables.SERIES.ID));
        return this.getSeries(seriesId);
    }

    @Override
    public void bulkSaveSeries(Report report, List<Series> series) {
        for (Series s : series) {
            this.createSeries(report, s);
        }
    }

    private void deleteSeries(int seriesId) {
        this.dbAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.SERIES).where((Predicate)Tables.SERIES.ID.eq((Object)seriesId)).execute());
    }

    @Override
    public void deleteSeries(Series series) {
        this.deleteSeries(series.getId().intValue());
    }

    @Override
    public void bulkDeleteSeries(List<Integer> series) {
        for (int seriesId : series) {
            this.deleteSeries(seriesId);
        }
    }

    @Override
    public long deleteSeriesByMetricId(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        return (Long)this.dbAccessor.runInTransaction(conn -> this.deleteSeriesByMetricId((DatabaseConnection)conn, serviceDesk, timeMetric));
    }

    @Override
    public long deleteSeriesByMetricId(DatabaseConnection databaseConnection, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        return databaseConnection.delete((RelationalPath)Tables.SERIES).where((Predicate)Tables.SERIES.TIME_METRIC_ID.eq((Object)timeMetric.getId().longValue())).execute();
    }

    @Override
    public List<Series> getSeriesByMetricId(long metricId) {
        List series = (List)this.dbAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new SeriesMapper()).from((Expression)Tables.SERIES)).where((Predicate)Tables.SERIES.TIME_METRIC_ID.eq((Object)metricId))).fetch());
        return new ArrayList<Series>(series);
    }

    @Override
    public void deleteAndUpdateSeriesWithGoalUpdateInfo(GoalUpdateInfo goalUpdateInfo, DatabaseConnection conn) {
        this.deleteSeriesWithDeletedGoals(conn, goalUpdateInfo.getDeletedGoalIds());
        goalUpdateInfo.getOriginalIdsToNewIds().forEach((originalId, newId) -> this.updateSeriesWithNewGoalId(conn, (Integer)originalId, (Integer)newId));
    }

    private long deleteSeriesWithDeletedGoals(DatabaseConnection conn, List<Integer> deletedGoalIds) {
        return conn.delete((RelationalPath)Tables.SERIES).where((Predicate)Tables.SERIES.GOAL_ID.in(deletedGoalIds)).execute();
    }

    private long updateSeriesWithNewGoalId(DatabaseConnection conn, Integer originalGoalId, Integer newGoalId) {
        return conn.update((RelationalPath)Tables.SERIES).where((Predicate)Tables.SERIES.GOAL_ID.eq((Object)originalGoalId)).set(Tables.SERIES.GOAL_ID, (Object)newGoalId).execute();
    }
}

