/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.queue;

import com.atlassian.servicedesk.api.queue.Queue;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class QueueImpl
implements Queue {
    private final long id;
    private final long serviceDeskId;
    private final String name;
    private final String jql;
    private final Optional<Long> issueCount;
    private final List<String> fields;

    QueueImpl(long id, long serviceDeskId, String name, String jql, Optional<Long> issueCount, List<String> fields) {
        this.id = id;
        this.serviceDeskId = serviceDeskId;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.jql = (String)Preconditions.checkNotNull((Object)jql);
        this.issueCount = (Optional)Preconditions.checkNotNull(issueCount);
        this.fields = ImmutableList.copyOf(fields);
    }

    public long getId() {
        return this.id;
    }

    public long getServiceDeskId() {
        return this.serviceDeskId;
    }

    public String getName() {
        return this.name;
    }

    public String getJql() {
        return this.jql;
    }

    public Optional<Long> getIssueCount() {
        return this.issueCount;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueImpl that = (QueueImpl)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.serviceDeskId, (Object)that.serviceDeskId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.jql, (Object)that.jql) && Objects.equal(this.issueCount, that.issueCount) && Objects.equal(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.serviceDeskId, this.name, this.jql, this.issueCount, this.fields});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("serviceDeskId", this.serviceDeskId).add("name", (Object)this.name).add("jql", (Object)this.jql).add("issueCount", this.issueCount).add("fields", this.fields).toString();
    }
}

