/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.queue;

import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.internal.cache.CacheClearer;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.feature.queue.ProjectState;
import com.atlassian.servicedesk.internal.feature.queue.ProjectStateCacheManager;
import com.atlassian.servicedesk.internal.util.SafeJsonExternalCacheReader;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.vcache.ChangeRate;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.joda.time.DateTimeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectStateCacheManagerImpl
implements ProjectStateCacheManager {
    private final ServiceDeskIssueService sdIssueService;
    private final DirectExternalCache<String> projectStateExternalCache;
    private final SafeJsonExternalCacheReader cacheReader;
    private final CacheClearer cacheClearer;

    @Autowired
    public ProjectStateCacheManagerImpl(ServiceDeskIssueService sdIssueService, VCacheFactory vCacheFactory, SafeJsonExternalCacheReader cacheReader, CacheClearer cacheClearer) {
        this.sdIssueService = sdIssueService;
        this.cacheReader = cacheReader;
        this.cacheClearer = cacheClearer;
        this.projectStateExternalCache = this.buildProjectStateCache(vCacheFactory);
    }

    @PostConstruct
    private void postConstruction() {
        this.cacheClearer.registerCacheClearing(() -> this.cacheClearer.waitForCacheClear((ExternalWriteOperationsUnbuffered<?>)this.projectStateExternalCache));
    }

    @Override
    public ProjectState getProjectState(@Nonnull Project project) {
        Assertions.notNull((String)"project", (Object)project);
        return this.cacheReader.read(this.projectStateExternalCache, ProjectState.class, project.getKey(), () -> this.loadProjectState(project));
    }

    @Override
    public void onIssueEvent(IssueEvent issueEvent) {
        this.onEvent(issueEvent.getProject().getKey());
    }

    @Override
    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        this.onEvent(issueChangedEvent.getIssue().getProjectObject().getKey());
    }

    @Override
    public void onCommentCreatedEvent(CommentCreatedEvent commentCreatedEvent) {
        this.onEvent(commentCreatedEvent.getComment().getIssue().getProjectObject().getKey());
    }

    @Override
    public void onCommentUpdatedEvent(CommentUpdatedEvent commentUpdatedEvent) {
        this.onEvent(commentUpdatedEvent.getComment().getIssue().getProjectObject().getKey());
    }

    @Override
    public void onCommentDeletedEvent(CommentDeletedEvent commentDeletedEvent) {
        this.onEvent(commentDeletedEvent.getComment().getIssue().getProjectObject().getKey());
    }

    private void onEvent(String projectKey) {
        this.projectStateExternalCache.remove(new String[]{projectKey});
    }

    private DirectExternalCache<String> buildProjectStateCache(VCacheFactory vCacheFactory) {
        Marshaller marshaller = MarshallerFactory.serializableMarshaller(String.class);
        ExternalCacheSettings cacheSettings = new ExternalCacheSettingsBuilder().dataChangeRateHint(ChangeRate.HIGH_CHANGE).entryGrowthRateHint(ChangeRate.LOW_CHANGE).build();
        return vCacheFactory.getDirectExternalCache(CacheUtil.standardName(this, "sdProjectStateCache"), marshaller, cacheSettings);
    }

    private ProjectState loadProjectState(Project project) {
        Timestamp lastUpdatedTime = this.getLastUpdatedTime(project);
        long projectIssueCount = this.sdIssueService.numberOfIssuesForProjectWithoutSecurity(project);
        return new ProjectState(projectIssueCount, lastUpdatedTime);
    }

    private Timestamp getLastUpdatedTime(Project project) {
        Option<Issue> latestUpdatedIssue = this.sdIssueService.mostRecentUpdatedIssueWithoutSecurity(project);
        if (latestUpdatedIssue.isDefined()) {
            return ((Issue)latestUpdatedIssue.get()).getUpdated();
        }
        return new Timestamp(DateTimeUtils.currentTimeMillis());
    }
}

