/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.precondition;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.feature.precondition.Alert;
import com.atlassian.servicedesk.internal.api.feature.precondition.Precondition;
import com.atlassian.servicedesk.internal.api.feature.precondition.RequestTypePrecondition;
import com.atlassian.servicedesk.internal.feature.precondition.PreconditionAccessor;
import com.atlassian.servicedesk.internal.feature.precondition.PreconditionService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PreconditionServiceImpl
implements PreconditionService {
    private static final Logger LOG = LoggerFactory.getLogger(PreconditionServiceImpl.class);
    private ApplicationContext applicationContext;
    private PreconditionAccessor preconditionAccessor;

    @Autowired
    public PreconditionServiceImpl(ApplicationContext applicationContext, PreconditionAccessor preconditionAccessor) {
        this.applicationContext = applicationContext;
        this.preconditionAccessor = preconditionAccessor;
    }

    @Override
    public List<Alert> checkPreconditions(ServiceDesk serviceDesk, Project project, Portal portal) {
        List<Alert> applicationAlerts = this.getApplicationRegisteredPreconditionAlerts(serviceDesk, project, portal);
        List<Alert> osgiAlerts = this.preconditionAccessor.checkPreconditions(serviceDesk, project, portal);
        return Stream.concat(applicationAlerts.stream(), osgiAlerts.stream()).collect(Collectors.toList());
    }

    private List<Alert> getApplicationRegisteredPreconditionAlerts(ServiceDesk serviceDesk, Project project, Portal portal) {
        return this.applicationContext.getBeansOfType(Precondition.class).values().stream().flatMap(precondition -> precondition.checkPrecondition(serviceDesk, project, portal).stream()).collect(Collectors.toList());
    }

    @Override
    public List<Alert> checkPreconditionsForRequestType(ServiceDesk serviceDesk, Project project, Portal portal, RequestType requestType, IssueType issueType) {
        return this.applicationContext.getBeansOfType(RequestTypePrecondition.class).values().stream().flatMap(precondition -> precondition.checkPreconditionForRequestType(serviceDesk, project, portal, requestType, issueType).stream()).collect(Collectors.toList());
    }
}

