/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.precondition;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.lifecycle.services.OptionalService;
import com.atlassian.pocketknife.spi.lifecycle.services.OptionalServiceAccessor;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.feature.precondition.Alert;
import com.atlassian.servicedesk.internal.api.feature.precondition.Precondition;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreconditionAccessor
extends OptionalServiceAccessor<Precondition> {
    @Autowired
    public PreconditionAccessor(BundleContext bundleContext) {
        super(bundleContext, Precondition.class.getCanonicalName());
    }

    public List<Alert> checkPreconditions(ServiceDesk serviceDesk, Project project, Portal portal) {
        try (OptionalService service2 = this.obtain();){
            if (service2.isAvailable()) {
                List<Alert> list = service2.getAll().stream().flatMap(precondition -> precondition.checkPrecondition(serviceDesk, project, portal).stream()).collect(Collectors.toList());
                return list;
            }
            List<Alert> list = Collections.emptyList();
            return list;
        }
    }
}

