/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.people;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.rest.responses.AgentWorkloadDetails;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalBaseViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalViewService;
import io.atlassian.fugue.Maybe;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentWorkloadServiceHelper {
    private static Logger log = LoggerFactory.getLogger(AgentWorkloadServiceHelper.class);
    private final InternalTimeMetricService internalTimeMetricService;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final ApplicationProperties applicationProperties;
    private final GoalViewService goalViewService;

    @Autowired
    public AgentWorkloadServiceHelper(InternalTimeMetricService internalTimeMetricService, ServiceDeskIssueService serviceDeskIssueService, ApplicationProperties applicationProperties, GoalViewService goalViewService) {
        this.internalTimeMetricService = internalTimeMetricService;
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.applicationProperties = applicationProperties;
        this.goalViewService = goalViewService;
    }

    public Map<String, AgentWorkloadDetails> getAgentWorkloadData(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, Map<String, List<Issue>> data) {
        ApplicationUser user = checkedUser.forJIRA();
        List<TimeMetric> timeMetrics = this.internalTimeMetricService.getTimeMetrics(user, serviceDesk);
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, assigneeAndIssuesEntry -> this.assigneeAndIssuesToAgentWorkloadDetails((Map.Entry<String, List<Issue>>)assigneeAndIssuesEntry, project, timeMetrics, user)));
    }

    private AgentWorkloadDetails assigneeAndIssuesToAgentWorkloadDetails(Map.Entry<String, List<Issue>> assigneeAndIssuesEntry, Project project, List<TimeMetric> timeMetrics, ApplicationUser user) {
        List<Issue> issues = assigneeAndIssuesEntry.getValue();
        String assignee = assigneeAndIssuesEntry.getKey();
        Map<String, Long> severityToIssueCount = this.getSeverityCountsForIssues(issues, timeMetrics, user);
        String jql = this.getEncodedAssigneeJQL(assignee, project);
        return AgentWorkloadDetails.convertSeveritiesAndJQLToWorkloadObject(severityToIssueCount, jql);
    }

    private Map<String, Long> getSeverityCountsForIssues(List<Issue> issues, List<TimeMetric> timeMetrics, ApplicationUser user) {
        return issues.stream().map(issue -> this.evaluateIssueUrgency(user, (Issue)issue, timeMetrics)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private String getEncodedAssigneeJQL(String assignee, Project project) {
        String jql = this.serviceDeskIssueService.getUnresolvedForAssigneeJql(assignee, project);
        try {
            return URLEncoder.encode(jql, this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn("Could not encode JQL for assignee because the encoding type in the JIRA application properties, '{}',  is unsupported. JQL: {}", (Object)this.applicationProperties.getEncoding(), (Object)jql);
            return jql;
        }
    }

    private String evaluateIssueUrgency(ApplicationUser viewingUser, Issue issue, List<TimeMetric> metrics) {
        List urgencyList = metrics.stream().map(metric -> this.goalViewService.getGoalSummaryView(viewingUser, issue, (TimeMetric)((Object)metric))).filter(Maybe::isDefined).map(Maybe::get).map(GoalBaseViewData::getEmergencyLevel).collect(Collectors.toList());
        if (urgencyList.contains("breached")) {
            return "breached";
        }
        if (urgencyList.contains("urgent")) {
            return "urgent";
        }
        return "normal";
    }
}

