/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.setting;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganisationSettingManager;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationSettingServiceImpl
implements CustomerOrganizationSettingService {
    private final CustomerOrganisationSettingManager organisationSettingManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;
    private final ServiceDeskUserLicenseService userLicenseService;
    private final CustomerOrganizationError customerOrganizationError;

    @Autowired
    public CustomerOrganizationSettingServiceImpl(CustomerOrganisationSettingManager organisationSettingManager, ServiceDeskPermissions serviceDeskPermissions, CommonErrors commonErrors, FeatureManager featureManager, ServiceDeskUserLicenseService userLicenseService, CustomerOrganizationError customerOrganizationError) {
        this.organisationSettingManager = organisationSettingManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
        this.userLicenseService = userLicenseService;
        this.customerOrganizationError = customerOrganizationError;
    }

    @Override
    @Nonnull
    public Either<AnError, Unit> restrictToJiraAdmin(@Nonnull CheckedUser currentUser, boolean restricted) {
        if (!this.serviceDeskPermissions.canAdministerJIRA((SDUser)currentUser)) {
            return Either.left((Object)this.commonErrors.CONFIGURATION_PERMISSION_ERROR());
        }
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        this.organisationSettingManager.restrictToJiraAdmin(restricted);
        return Either.right((Object)Unit.VALUE);
    }

    @Override
    public Either<AnError, Boolean> isRestrictedToJiraAdmin() {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return Either.right((Object)this.organisationSettingManager.isRestrictedToJiraAdmin());
    }

    @Override
    public boolean canManageOrganizations(@Nonnull CheckedUser user) {
        if (!this.canViewAllOrganizations(user)) {
            return false;
        }
        boolean isRestrictedToJiraAdmin = this.organisationSettingManager.isRestrictedToJiraAdmin();
        if (isRestrictedToJiraAdmin) {
            return this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
        }
        return true;
    }

    @Override
    public boolean canViewAllOrganizations(@Nonnull CheckedUser user) {
        return this.userLicenseService.hasValidAgentLicense((SDUser)user);
    }

    @Override
    public boolean canManageOrganizationsInProject(@Nonnull CheckedUser user, @Nonnull Project project) {
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return false;
        }
        boolean isRestrictedToJiraAdmin = this.organisationSettingManager.isRestrictedToJiraAdmin();
        if (isRestrictedToJiraAdmin) {
            return this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
        }
        return true;
    }

    @Override
    public boolean canDeleteOrganizations(@Nonnull CheckedUser user) {
        return this.canViewAllOrganizations(user) && this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
    }

    @Override
    public Either<AnError, Boolean> canManageOrganizationsEither(@Nonnull CheckedUser user) {
        if (this.canViewAllOrganizations(user) && !this.organisationSettingManager.isRestrictedToJiraAdmin() || this.serviceDeskPermissions.canAdministerJIRA((SDUser)user) && this.organisationSettingManager.isRestrictedToJiraAdmin()) {
            return Either.right((Object)true);
        }
        if (this.organisationSettingManager.isRestrictedToJiraAdmin()) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
    }
}

