/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.project;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsParams;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsResult;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectManager;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectService;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationProjectServiceImpl
implements CustomerOrganizationProjectService {
    private final CustomerOrganizationProjectManager customerOrganizationProjectManager;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationError customerOrganizationError;
    private final CustomerOrganizationSettingService customerOrganizationSettingService;
    private final ServiceDeskPermissions serviceDeskPermissions;

    @Autowired
    public CustomerOrganizationProjectServiceImpl(CustomerOrganizationProjectManager customerOrganizationProjectManager, FeatureManager featureManager, CommonErrors commonErrors, CustomerOrganizationError customerOrganizationError, CustomerOrganizationSettingService customerOrganizationSettingService, ServiceDeskPermissions serviceDeskPermissions) {
        this.customerOrganizationProjectManager = customerOrganizationProjectManager;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.customerOrganizationError = customerOrganizationError;
        this.customerOrganizationSettingService = customerOrganizationSettingService;
        this.serviceDeskPermissions = serviceDeskPermissions;
    }

    @Override
    public Either<AnError, InviteCustomerOrganizationsResult> addOrganizations(@Nonnull CheckedUser user, @Nonnull InviteCustomerOrganizationsParams inviteCustomerOrganizationsParams) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(inviteCustomerOrganizationsParams, "inviteCustomerOrganizationsParams");
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canManageOrganizationsInProject(user, inviteCustomerOrganizationsParams.getProject())) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        return this.customerOrganizationProjectManager.addOrganizations(inviteCustomerOrganizationsParams);
    }

    @Override
    public Either<AnError, Unit> disassociateOrganization(@Nonnull CheckedUser checkedUser, @Nonnull Project project, @Nonnull CustomerOrganization customerOrganization) {
        Objects.requireNonNull(checkedUser);
        Objects.requireNonNull(project);
        Objects.requireNonNull(customerOrganization);
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.customerOrganizationSettingService.canManageOrganizationsInProject(checkedUser, project)) {
            return Either.left((Object)this.customerOrganizationError.NO_MANAGE_ORGANIZATION_PERMISSION());
        }
        this.customerOrganizationProjectManager.disassociateOrganization(project, customerOrganization);
        return Either.right((Object)Unit.VALUE);
    }

    @Override
    public Either<AnError, Collection<CustomerOrganization>> getOrganizations(CheckedUser user, Project project) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.customerOrganizationProjectManager.getOrganizations(project);
    }
}

