/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.project;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsParams;
import com.atlassian.servicedesk.internal.feature.organization.InviteCustomerOrganizationsResult;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationNotFoundException;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.project.CustomerOrganizationProjectManager;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationProjectManagerImpl
implements CustomerOrganizationProjectManager {
    private final DatabaseAccessor databaseAccessor;
    private final ServiceDeskManager serviceDeskManager;
    private final CustomerOrganizationQStore organizationQStore;
    private final CustomerOrganizationProjectQStore customerOrganizationProjectQStore;
    private final CustomerOrganizationError customerOrganizationError;
    private final CommonErrors commonErrors;

    @Autowired
    public CustomerOrganizationProjectManagerImpl(DatabaseAccessor databaseAccessor, ServiceDeskManager serviceDeskManager, CustomerOrganizationQStore organizationQStore, CustomerOrganizationProjectQStore customerOrganizationProjectQStore, CustomerOrganizationError customerOrganizationError, CommonErrors commonErrors) {
        this.databaseAccessor = databaseAccessor;
        this.serviceDeskManager = serviceDeskManager;
        this.organizationQStore = organizationQStore;
        this.customerOrganizationProjectQStore = customerOrganizationProjectQStore;
        this.customerOrganizationError = customerOrganizationError;
        this.commonErrors = commonErrors;
    }

    @Override
    public Either<AnError, InviteCustomerOrganizationsResult> addOrganizations(@Nonnull InviteCustomerOrganizationsParams inviteCustomerOrganizationsParams) {
        Objects.requireNonNull(inviteCustomerOrganizationsParams, "inviteCustomerOrganizationsParams");
        Either<AnError, JSDSuccess> validateResult = this.validateInvite(inviteCustomerOrganizationsParams);
        if (validateResult.isLeft()) {
            return Either.left((Object)validateResult.left().get());
        }
        if (inviteCustomerOrganizationsParams.getNewOrganizationNames().isEmpty() && inviteCustomerOrganizationsParams.getExistingOrganizationIds().isEmpty()) {
            return Either.right((Object)InviteCustomerOrganizationsResult.EMPTY);
        }
        try {
            return (Either)this.databaseAccessor.runInTransaction(databaseConnection -> {
                Collection<CustomerOrganization> newOrganizations = this.organizationQStore.getOrCreate(inviteCustomerOrganizationsParams.getNewOrganizationNames(), (DatabaseConnection)databaseConnection);
                Set newOrganizationIds = newOrganizations.stream().map(CustomerOrganization::getId).collect(Collectors.toSet());
                HashSet<Integer> customerOrganizationsIdsToAdd = new HashSet<Integer>(inviteCustomerOrganizationsParams.getExistingOrganizationIds());
                customerOrganizationsIdsToAdd.addAll(newOrganizationIds);
                this.customerOrganizationProjectQStore.addOrganizationsToProject((Set<Integer>)customerOrganizationsIdsToAdd, inviteCustomerOrganizationsParams.getProject().getId(), (DatabaseConnection)databaseConnection);
                List<CustomerOrganization> addedOrganizations = this.organizationQStore.getByIds((Set<Integer>)customerOrganizationsIdsToAdd, (DatabaseConnection)databaseConnection);
                return Either.right((Object)InviteCustomerOrganizationsResult.success(addedOrganizations));
            });
        }
        catch (OrganizationNotFoundException e) {
            return Either.right((Object)InviteCustomerOrganizationsResult.fail(this.organizationQStore.findInvalidIds(inviteCustomerOrganizationsParams.getExistingOrganizationIds())));
        }
    }

    @Override
    public void disassociateOrganization(@Nonnull Project project, @Nonnull CustomerOrganization organization) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(organization);
        this.customerOrganizationProjectQStore.disassociateProjectAndOrganization(project.getId(), organization.getId());
    }

    @Override
    public Either<AnError, Collection<CustomerOrganization>> getOrganizations(Project project) {
        if (!this.serviceDeskManager.isServiceDeskEnabled(project)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Either.right(this.customerOrganizationProjectQStore.getOrganizationsForProject(project.getId()));
    }

    @Override
    public void disassociateProject(Project project) {
        this.customerOrganizationProjectQStore.removeAllFromProject(project.getId());
    }

    @Override
    public Collection<Long> getProjectsForOrganization(int organizationId) {
        return this.customerOrganizationProjectQStore.getProjectsForOrganization(organizationId);
    }

    private Either<AnError, JSDSuccess> validateInvite(InviteCustomerOrganizationsParams inviteCustomerOrganizationsParams) {
        if (!this.serviceDeskManager.isServiceDeskEnabled(inviteCustomerOrganizationsParams.getProject())) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        Set invalidNames = inviteCustomerOrganizationsParams.getNewOrganizationNames().stream().filter(orgName -> orgName.length() > 200).collect(Collectors.toSet());
        if (!invalidNames.isEmpty()) {
            return Either.left((Object)this.customerOrganizationError.ORGANISATION_NAME_LIMIT(200));
        }
        Set emptyNames = inviteCustomerOrganizationsParams.getNewOrganizationNames().stream().filter(StringUtils::isBlank).collect(Collectors.toSet());
        if (!emptyNames.isEmpty()) {
            return Either.left((Object)this.customerOrganizationError.ORGANIZATION_NAME_EMPTY());
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }
}

