/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.jql;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InOrganisationValidator {
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;
    private final I18nHelper.BeanFactory i18nFactory;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;
    private final FeatureManager featureManager;

    @Autowired
    public InOrganisationValidator(ServiceDeskOperationalStatus serviceDeskOperationalStatus, I18nHelper.BeanFactory i18nFactory, CustomerOrganizationManager customerOrganizationManager, ServiceDeskUserLicenseService serviceDeskUserLicenseService, FeatureManager featureManager) {
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
        this.i18nFactory = i18nFactory;
        this.customerOrganizationManager = customerOrganizationManager;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
        this.featureManager = featureManager;
    }

    public MessageSet validate(ApplicationUser applicationUser, @Nonnull FunctionOperand functionOperand) {
        MessageSetImpl message = new MessageSetImpl();
        HashSet<String> organisationNames = new HashSet<String>(functionOperand.getArgs());
        if (!this.serviceDeskOperationalStatus.isOperational()) {
            this.addErrorMessage(applicationUser, (MessageSet)message, "sd.customer.organisation.error.function.no.license");
        } else if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            this.addErrorMessage(applicationUser, (MessageSet)message, "sd.customer.organisation.error.function.not.enabled");
        } else if (!this.serviceDeskUserLicenseService.hasValidAgentLicense(applicationUser)) {
            this.addErrorMessage(applicationUser, (MessageSet)message, "sd.customer.organisation.error.function.no.permission");
        } else if (this.hasEmptyArguments(organisationNames)) {
            this.addErrorMessage(applicationUser, (MessageSet)message, "sd.customer.organisation.error.function.empty.organisation");
        } else {
            Collection<String> nonExistentOrganisations = this.getNonExistentOrganisations(organisationNames);
            if (nonExistentOrganisations.size() > 0) {
                this.addErrorMessage(applicationUser, (MessageSet)message, nonExistentOrganisations, "sd.customer.organisation.error.function.non.existent");
            }
        }
        return message;
    }

    private void addErrorMessage(ApplicationUser applicationUser, MessageSet message, Collection nonExistentOrganisations, String i18n) {
        message.addErrorMessage(this.i18nFactory.getInstance(applicationUser).getText(i18n, StringUtils.join((Collection)nonExistentOrganisations, (String)", ")));
    }

    private void addErrorMessage(ApplicationUser applicationUser, MessageSet message, String i18n) {
        message.addErrorMessage(this.i18nFactory.getInstance(applicationUser).getText(i18n));
    }

    private Collection<String> getNonExistentOrganisations(Set<String> organisationNames) {
        Set<String> actualNames = this.getActualOrganisationNames(organisationNames);
        return organisationNames.stream().filter(name -> !actualNames.contains(name.toLowerCase())).collect(Collectors.toList());
    }

    private Set<String> getActualOrganisationNames(Set<String> organisationNames) {
        return this.customerOrganizationManager.getCustomerOrganizationByNames(organisationNames).stream().map(CustomerOrganization::getName).map(String::toLowerCase).collect(Collectors.toSet());
    }

    private boolean hasEmptyArguments(Set<String> organisationNames) {
        return organisationNames.stream().anyMatch(StringUtils::isBlank);
    }
}

