/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization.api;

import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationServiceDeskUpdateParameters;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class OrganizationServiceDeskUpdateParametersImpl
implements OrganizationServiceDeskUpdateParameters {
    private final Integer serviceDeskId;
    private final CustomerOrganization customerOrganization;

    protected OrganizationServiceDeskUpdateParametersImpl(Integer serviceDeskId, CustomerOrganization customerOrganization) {
        this.serviceDeskId = (Integer)Preconditions.checkNotNull((Object)serviceDeskId);
        this.customerOrganization = (CustomerOrganization)Preconditions.checkNotNull((Object)customerOrganization);
    }

    public Integer serviceDeskId() {
        return this.serviceDeskId;
    }

    public CustomerOrganization organization() {
        return this.customerOrganization;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationServiceDeskUpdateParametersImpl that = (OrganizationServiceDeskUpdateParametersImpl)o;
        return Objects.equals(this.serviceDeskId(), that.serviceDeskId()) && Objects.equals(this.organization(), that.organization());
    }

    public int hashCode() {
        return Objects.hash(this.serviceDeskId(), this.organization());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceDeskId", (Object)this.serviceDeskId()).add("Organization", (Object)this.organization()).toString();
    }

    public static final class Builder
    implements OrganizationServiceDeskUpdateParameters.Builder {
        private Integer serviceDeskId;
        private CustomerOrganization customerOrganization;

        private Builder() {
        }

        private Builder(OrganizationServiceDeskUpdateParametersImpl initialData) {
            this.serviceDeskId = initialData.serviceDeskId();
            this.customerOrganization = initialData.organization();
        }

        public Builder serviceDeskId(Integer serviceDeskId) {
            this.serviceDeskId = serviceDeskId;
            return this;
        }

        public Builder organization(CustomerOrganization customerOrganization) {
            this.customerOrganization = customerOrganization;
            return this;
        }

        public OrganizationServiceDeskUpdateParametersImpl build() {
            return new OrganizationServiceDeskUpdateParametersImpl(this.serviceDeskId, this.customerOrganization);
        }
    }
}

