/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationMemberSearchManager {
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final UserSearchManager userSearchManager;
    private final UserFactory userFactory;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final UserManager userManager;

    @Autowired
    public OrganizationMemberSearchManager(UserSearchManagerHelper userSearchManagerHelper, UserSearchManager userSearchManager, UserFactory userFactory, CustomerOrganizationMemberManager customerOrganizationMemberManager, UserManager userManager) {
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.userSearchManager = userSearchManager;
        this.userFactory = userFactory;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.userManager = userManager;
    }

    @Nonnull
    public Either<AnError, List<CheckedUser>> searchForUsersInOrganization(@Nonnull CheckedUser searcher, @Nonnull CustomerOrganization organisation, @Nonnull String queryString, int limit) {
        Objects.requireNonNull(searcher, "searcher");
        Objects.requireNonNull(organisation, "organisation");
        Objects.requireNonNull(queryString, "queryString");
        List membersInOrganisation = this.customerOrganizationMemberManager.getUserKeysInOrganization(organisation).stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        UserSearchParams params = this.userSearchManagerHelper.buildActiveOnlyUserSearchParams(Option.some((Object)limit));
        return Either.right(this.userSearchManager.filterUsers(membersInOrganisation, queryString, params, true).flatMap(user -> StreamSupport.stream(this.userFactory.wrap(user).toOption().spliterator(), false)).collect(Collectors.toList()));
    }
}

