/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.organization;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.UpdateOrganizationParams;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationMemberQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationProjectQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.CustomerOrganizationQStore;
import com.atlassian.servicedesk.internal.feature.organization.dao.exceptions.OrganizationExistsException;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.model.CustomerOrganizationWithOtherProjectCount;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class CustomerOrganizationManagerImpl
implements CustomerOrganizationManager {
    private final CustomerOrganizationQStore organizationQStore;
    private final CustomerOrganizationMemberQStore organizationMemberQStore;
    private final CustomerOrganizationProjectQStore organizationProjectQStore;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final CustomerOrganizationError organizationError;
    private final CommonErrors commonErrors;
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public CustomerOrganizationManagerImpl(CustomerOrganizationQStore organizationQStore, CustomerOrganizationMemberQStore organizationMemberQStore, CustomerOrganizationProjectQStore organizationProjectQStore, ServiceDeskInternalManager serviceDeskManager, CustomerOrganizationError organizationError, CommonErrors commonErrors, DatabaseAccessor databaseAccessor) {
        this.organizationQStore = organizationQStore;
        this.organizationMemberQStore = organizationMemberQStore;
        this.organizationProjectQStore = organizationProjectQStore;
        this.serviceDeskManager = serviceDeskManager;
        this.organizationError = organizationError;
        this.databaseAccessor = databaseAccessor;
        this.commonErrors = commonErrors;
    }

    @Override
    public Either<AnError, CustomerOrganization> getOrganizationById(int orgId) {
        List<CustomerOrganization> organizations = this.organizationQStore.getByIds(Sets.newHashSet((Object[])new Integer[]{orgId}));
        if (organizations.isEmpty()) {
            return Either.left((Object)this.organizationError.ORGANISATION_NOT_FOUND(Sets.newHashSet((Object[])new Integer[]{orgId})));
        }
        return Either.right((Object)organizations.get(0));
    }

    @Override
    public Either<AnError, Collection<CustomerOrganization>> getOrganizationsForProject(Project project) {
        Objects.requireNonNull(project, "project");
        if (!this.serviceDeskManager.isServiceDeskEnabled(project)) {
            return Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Either.right(this.organizationProjectQStore.getOrganizationsForProject(project.getId()));
    }

    @Override
    public int deleteOrganization(int orgId) {
        return (Integer)this.databaseAccessor.runInTransaction(databaseConnection -> {
            this.organizationProjectQStore.removeOrganizationFromAllProjects(orgId, (DatabaseConnection)databaseConnection);
            this.organizationMemberQStore.removeAllMembers(orgId, (DatabaseConnection)databaseConnection);
            this.organizationQStore.delete(orgId, (DatabaseConnection)databaseConnection);
            return orgId;
        });
    }

    @Override
    public Collection<CustomerOrganization> getCustomerOrganizationByNames(Set<String> names) {
        Objects.requireNonNull(names, "names");
        return this.organizationQStore.getByNames(names);
    }

    @Override
    public Collection<CustomerOrganization> getOrganizationsById(Collection<Integer> ids) {
        Objects.requireNonNull(ids, "ids");
        return this.organizationQStore.getByIds(new HashSet<Integer>(ids));
    }

    @Override
    public List<Integer> filterOrganizationsInProject(Set<Integer> organizationIds, Long projectId) {
        Objects.requireNonNull(projectId);
        Objects.requireNonNull(organizationIds);
        return this.organizationProjectQStore.filterOrganizationsInProject(organizationIds, projectId);
    }

    @Override
    public Either<AnError, CustomerOrganizationWithOtherProjectCount> getOrganizationWithOtherProjectCount(Project projectToExcludeFromCount, CustomerOrganization customerOrganization) {
        return this.organizationProjectQStore.getOrganizationWithOtherProjectCount(projectToExcludeFromCount.getId(), customerOrganization.getId()).toRight(() -> this.organizationError.ORGANISATION_NOT_FOUND(Sets.newHashSet((Object[])new Integer[]{customerOrganization.getId()})));
    }

    @Override
    public List<CustomerOrganization> getAllOrganizations() {
        return this.organizationQStore.getAllOrganizations();
    }

    @Override
    public Either<AnError, CustomerOrganization> createOrganization(String organizationName) {
        return Either.right((Object)this.databaseAccessor.runInTransaction(conn -> this.organizationQStore.getOrCreate(organizationName, (DatabaseConnection)conn)));
    }

    @Override
    public Either<AnError, CustomerOrganization> updateOrganization(CustomerOrganization organization, UpdateOrganizationParams updateOrganizationParams) {
        Objects.requireNonNull(organization, "organization");
        Objects.requireNonNull(updateOrganizationParams, "updateOrganizationParams");
        Either<AnError, Unit> valid = this.validateOrganizationName(updateOrganizationParams.getNewName());
        if (valid.isLeft()) {
            return Either.left((Object)valid.left().get());
        }
        try {
            return Either.right((Object)this.organizationQStore.update(organization.getId(), updateOrganizationParams.getNewName()));
        }
        catch (OrganizationExistsException e) {
            return Either.left((Object)this.organizationError.ORGANISATION_ALREADY_EXISTS(Sets.newHashSet((Object[])new String[]{updateOrganizationParams.getNewName()})));
        }
    }

    @Override
    public Collection<CustomerOrganization> getCustomerOrganizationsByNamePrefix(String prefix, int maxNumResults) {
        Objects.requireNonNull(prefix, "prefix");
        if (maxNumResults <= 0) {
            return Collections.emptyList();
        }
        Collection<CustomerOrganization> organizations = StringUtils.isEmpty((String)prefix) ? this.organizationQStore.getAllOrganizations() : this.organizationQStore.findByNameQuery(prefix);
        return organizations.stream().sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())).limit(maxNumResults).collect(Collectors.toList());
    }

    private Either<AnError, Unit> validateOrganizationName(String orgName) {
        if (StringUtils.isBlank((String)orgName)) {
            return Either.left((Object)this.organizationError.ORGANIZATION_NAME_EMPTY());
        }
        if (orgName.length() > 200) {
            return Either.left((Object)this.organizationError.ORGANISATION_NAME_LIMIT(200));
        }
        return Either.right((Object)Unit.Unit());
    }
}

