/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.notificationsubscription;

import com.atlassian.fugue.Maybe;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionDao;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionDefaultHelper;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionManager;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionRecord;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationSubscriptionManagerImpl
implements NotificationSubscriptionManager {
    private final DatabaseAccessor databaseAccessor;
    private final NotificationSubscriptionDao notificationSubscriptionDao;
    private final NotificationSubscriptionDefaultHelper subscriptionDefaultValueHelper;
    private final UserManager userManager;
    private final UserFactory userFactory;

    @Autowired
    public NotificationSubscriptionManagerImpl(DatabaseAccessor databaseAccessor, NotificationSubscriptionDao notificationSubscriptionDao, NotificationSubscriptionDefaultHelper subscriptionDefaultValueHelper, UserManager userManager, UserFactory userFactory) {
        this.databaseAccessor = databaseAccessor;
        this.notificationSubscriptionDao = notificationSubscriptionDao;
        this.subscriptionDefaultValueHelper = subscriptionDefaultValueHelper;
        this.userManager = userManager;
        this.userFactory = userFactory;
    }

    @Override
    public void subscribe(CheckedUser subscriber, Issue issue) {
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            this.notificationSubscriptionDao.createOrUpdateSubscription(subscriber, issue, true, (DatabaseConnection)databaseConnection);
            return Either.right((Object)Unit.Unit());
        });
    }

    @Override
    public void subscribe(Collection<CheckedUser> subscribers, Issue issue) {
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            this.notificationSubscriptionDao.createOrUpdateSubscriptions(subscribers, issue, true, (DatabaseConnection)databaseConnection);
            return Unit.Unit();
        });
    }

    @Override
    public void unsubscribe(CheckedUser subscriber, Issue issue) {
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            this.notificationSubscriptionDao.createOrUpdateSubscription(subscriber, issue, false, (DatabaseConnection)databaseConnection);
            return Either.right((Object)Unit.Unit());
        });
    }

    @Override
    public boolean isSubscribed(CheckedUser user, Issue issue) {
        Option subscriptionRecords = (Option)this.databaseAccessor.runInTransaction(databaseConnection -> this.notificationSubscriptionDao.getSubscriptionRecord(user, issue, (DatabaseConnection)databaseConnection));
        if (subscriptionRecords.isEmpty()) {
            return this.subscriptionDefaultValueHelper.getDefaultValueForUser(user, issue);
        }
        return ((NotificationSubscriptionRecord)subscriptionRecords.get()).isSubscribed();
    }

    @Override
    public Set<CheckedUser> getSubscribers(Issue issue) {
        IssueSubscriptionUserInfo subscriptionUserInfo = this.getIssueSubscriptionUserInfos(issue);
        Set<CheckedUser> userWithSubscribedRecord = subscriptionUserInfo.getSubscribedUsers();
        Set<CheckedUser> userWithUnsubscribedRecord = subscriptionUserInfo.getUnSubscribedUsers();
        Set<CheckedUser> defaultSubscribers = this.subscriptionDefaultValueHelper.getDefaultPotentialSubscribers(issue);
        Collection filterDefaultSubscribers = CollectionUtils.subtract(defaultSubscribers, userWithUnsubscribedRecord);
        HashSet<CheckedUser> subscribers = new HashSet<CheckedUser>();
        subscribers.addAll(userWithSubscribedRecord);
        subscribers.addAll(filterDefaultSubscribers);
        return subscribers;
    }

    @Override
    public Set<CheckedUser> getUsersWithSubscriptionRecord(Issue issue) {
        Collection notificationSubscriptionRecord = (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.notificationSubscriptionDao.getAllSubscriptionRecords(issue, (DatabaseConnection)databaseConnection));
        return this.getUserFromSubscriptionRecords(notificationSubscriptionRecord);
    }

    private Set<CheckedUser> getUserFromSubscriptionRecords(Collection<NotificationSubscriptionRecord> subscriptionDbObjects) {
        Set userKeys = subscriptionDbObjects.stream().map(NotificationSubscriptionRecord::getUserKey).collect(Collectors.toSet());
        return userKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).map(appUser -> this.userFactory.wrap(appUser).toOption()).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toSet());
    }

    private IssueSubscriptionUserInfo getIssueSubscriptionUserInfos(Issue issue) {
        Collection notificationSubscriptionRecords = (Collection)this.databaseAccessor.runInTransaction(databaseConnection -> this.notificationSubscriptionDao.getAllSubscriptionRecords(issue, (DatabaseConnection)databaseConnection));
        ArrayList<NotificationSubscriptionRecord> subscribedRecords = new ArrayList<NotificationSubscriptionRecord>();
        ArrayList<NotificationSubscriptionRecord> unsubcribedRecords = new ArrayList<NotificationSubscriptionRecord>();
        notificationSubscriptionRecords.forEach(record -> {
            if (record.isSubscribed()) {
                subscribedRecords.add((NotificationSubscriptionRecord)record);
            } else {
                unsubcribedRecords.add((NotificationSubscriptionRecord)record);
            }
        });
        Set<CheckedUser> subscribedUsers = this.getUserFromSubscriptionRecords(subscribedRecords);
        Set<CheckedUser> unSubscribedUsers = this.getUserFromSubscriptionRecords(unsubcribedRecords);
        return new IssueSubscriptionUserInfo(subscribedUsers, unSubscribedUsers);
    }

    private class IssueSubscriptionUserInfo {
        private Set<CheckedUser> subscribedUsers;
        private Set<CheckedUser> unSubscribedUsers;

        public IssueSubscriptionUserInfo(Set<CheckedUser> subscribedUsers, Set<CheckedUser> unSubscribedUsers) {
            this.subscribedUsers = subscribedUsers;
            this.unSubscribedUsers = unSubscribedUsers;
        }

        public Set<CheckedUser> getSubscribedUsers() {
            return this.subscribedUsers;
        }

        public Set<CheckedUser> getUnSubscribedUsers() {
            return this.unSubscribedUsers;
        }
    }
}

