/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.project;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class InternalServiceDeskProjectManagerImpl
implements InternalServiceDeskProjectManager {
    private final ProjectManager projectManager;
    private final CommonErrors commonErrors;

    @Autowired
    public InternalServiceDeskProjectManagerImpl(ProjectManager projectManager, CommonErrors commonErrors) {
        this.projectManager = projectManager;
        this.commonErrors = commonErrors;
    }

    public Either<AnError, Project> getProject(Long projectId) {
        Option projectOpt = Option.option((Object)this.projectManager.getProjectObj(projectId));
        return projectOpt.toRight(Suppliers.ofInstance((Object)this.commonErrors.PROJECT_NOT_FOUND()));
    }

    public Either<AnError, Project> getProjectByKey(String projectKey) {
        Option projectOpt = Option.option((Object)this.projectManager.getProjectObjByKey(projectKey));
        return projectOpt.toRight(Suppliers.ofInstance((Object)this.commonErrors.PROJECT_NOT_FOUND()));
    }

    public Either<AnError, Project> getProjectByKeyIgnoreCase(String projectKey) {
        Option projectOpt = Option.option((Object)this.projectManager.getProjectObjByKey(projectKey));
        if (projectOpt.isEmpty()) {
            projectOpt = Option.option((Object)this.projectManager.getProjectObjByKeyIgnoreCase(projectKey));
        }
        return projectOpt.toRight(Suppliers.ofInstance((Object)this.commonErrors.PROJECT_NOT_FOUND()));
    }

    public Either<AnError, Project> getProjectByName(String projectName) {
        Option projectOpt = Option.option((Object)this.projectManager.getProjectObjByName(projectName));
        return projectOpt.toRight(Suppliers.ofInstance((Object)this.commonErrors.PROJECT_NOT_FOUND()));
    }

    public List<Project> getListOfProjectsById(List<Long> projectIds) {
        return this.projectManager.convertToProjectObjects(projectIds);
    }
}

