/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.issue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHashData;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueListHashDataCallback;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueSearchService;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskIssueSearchServiceImpl
implements ServiceDeskIssueSearchService {
    private SearchService searchService;
    private ErrorResultHelper errorHelper;
    private SearchProvider searchProvider;
    private IssueDataService issueDataService;
    private ServiceDeskPermissionService serviceDeskPermissionService;

    @Autowired
    public ServiceDeskIssueSearchServiceImpl(SearchService searchService, ErrorResultHelper errorHelper, SearchProvider searchProvider, IssueDataService issueDataService, ServiceDeskPermissionService serviceDeskPermissionService) {
        this.searchService = searchService;
        this.errorHelper = errorHelper;
        this.searchProvider = searchProvider;
        this.issueDataService = issueDataService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, SearchResults> getIssues(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Query jqlQuery, int startIndex, int issuesPerPage) {
        SearchResults searchResults;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
        Assertions.notNull((String)"jql", (Object)jqlQuery);
        io.atlassian.fugue.Either<AnError, Boolean> agentPermissionResult = this.checkAgentPermission(user, serviceDesk);
        if (agentPermissionResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentPermissionResult.left().get());
        }
        if (startIndex < 0) {
            return StepsConverters.newerEither((Either)this.errorHelper.badRequest400("sd.issue.search.invalid.pagination", new Object[0]).toEither());
        }
        try {
            searchResults = this.searchProvider.search(jqlQuery, user.forJIRA(), PagerFilter.newPageAlignedFilter((int)startIndex, (int)issuesPerPage));
        }
        catch (SearchException e) {
            return StepsConverters.newerEither((Either)this.errorHelper.internalServiceError500("sd.issue.search.exception", new Object[]{e}).toEither());
        }
        return io.atlassian.fugue.Either.right((Object)searchResults);
    }

    @Override
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    public io.atlassian.fugue.Either<AnError, List<IssueHashData>> getIssueHashData(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Query jqlQuery, int startIndex, int issuesPerPage) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
        Assertions.notNull((String)"jql", (Object)jqlQuery);
        io.atlassian.fugue.Either<AnError, Boolean> agentPermissionResult = this.checkAgentPermission(user, serviceDesk);
        if (agentPermissionResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentPermissionResult.left().get());
        }
        IssueListHashDataCallback callback = new IssueListHashDataCallback();
        this.issueDataService.findAndSort(user.forJIRA(), jqlQuery, (DataCallback)callback, PagerFilter.newPageAlignedFilter((int)startIndex, (int)issuesPerPage));
        return io.atlassian.fugue.Either.right(callback.getIssueData());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> countIssues(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull Query jqlQuery) {
        long issueCount;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
        Assertions.notNull((String)"jqlQuery", (Object)jqlQuery);
        io.atlassian.fugue.Either<AnError, Boolean> agentPermissionResult = this.checkAgentPermission(user, serviceDesk);
        if (agentPermissionResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentPermissionResult.left().get());
        }
        try {
            issueCount = this.searchService.searchCount(user.forJIRA(), jqlQuery);
        }
        catch (SearchException e) {
            return StepsConverters.newerEither((Either)this.errorHelper.internalServiceError500("sd.issue.search.exception", new Object[]{e}).toEither());
        }
        return io.atlassian.fugue.Either.right((Object)issueCount);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Query> parseQuery(@Nonnull CheckedUser user, @Nonnull String jql) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"jql", (Object)jql);
        SearchService.ParseResult result = this.searchService.parseQuery(user.forJIRA(), jql);
        if (!result.isValid()) {
            return StepsConverters.newerEither((Either)this.errorHelper.badRequest400("sd.issue.search.invalid.jql", new Object[]{result.getErrors()}).toEither());
        }
        return io.atlassian.fugue.Either.right((Object)result.getQuery());
    }

    private io.atlassian.fugue.Either<AnError, Boolean> checkAgentPermission(CheckedUser user, ServiceDesk serviceDesk) {
        io.atlassian.fugue.Either agentResultEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user.forJIRA(), serviceDesk));
        if (agentResultEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentResultEither.left().get());
        }
        Boolean isAgent2 = (Boolean)agentResultEither.right().get();
        if (!isAgent2.booleanValue()) {
            return StepsConverters.newerEither((Either)this.errorHelper.forbidden403("sd.issue.search.nonagent", new Object[0]).toEither());
        }
        return io.atlassian.fugue.Either.right((Object)true);
    }
}

