/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskIssueManagerImpl
implements ServiceDeskIssueManager {
    private final IssueManager issueManager;
    private final CommonErrors commonErrors;

    @Autowired
    public ServiceDeskIssueManagerImpl(IssueManager issueManager, CommonErrors commonErrors) {
        this.issueManager = issueManager;
        this.commonErrors = commonErrors;
    }

    @Override
    public Either<AnError, Issue> getIssueById(Long issueId) {
        return this.toEither((Option<Issue>)Option.option((Object)this.issueManager.getIssueObject(issueId)));
    }

    private Either<AnError, Issue> toEither(Option<Issue> issueOpt) {
        return issueOpt.toRight(() -> ((CommonErrors)this.commonErrors).ISSUE_NOT_FOUND());
    }

    @Override
    public Either<AnError, Issue> getIssueByKey(String issueKey) {
        return this.toEither((Option<Issue>)Option.option((Object)this.issueManager.getIssueObject(issueKey)));
    }

    @Override
    public Either<AnError, Issue> updateIssue(ApplicationUser user, MutableIssue issue, UpdateIssueRequest request) {
        return this.toEither((Option<Issue>)Option.option((Object)this.issueManager.updateIssue(user, issue, request)));
    }
}

