/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.issue;

import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHashData;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
public class IssueListHashDataCallback
implements DataCallback {
    private final Set<String> fields = Sets.newHashSet((Object[])new String[]{"key", "updated"});
    private List<IssueHashData> issueData = Lists.newArrayList();
    private Option<Timestamp> currentUpdatedDate = Option.none();

    public Set<String> getFields() {
        return this.fields;
    }

    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (fieldName.equals("updated")) {
            this.currentUpdatedDate = Option.some((Object)new Timestamp(LuceneUtils.stringToDate((String)data).getTime()));
        }
    }

    public void documentComplete(Long issueId, String issueKey) {
        if (this.currentUpdatedDate.isDefined()) {
            this.issueData.add(new IssueHashData(issueKey, (Timestamp)this.currentUpdatedDate.get()));
        }
    }

    public List<IssueHashData> getIssueData() {
        return this.issueData;
    }
}

