/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueHelperImpl
implements IssueHelper {
    private final IssueService issueService;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueFactory issueFactory;
    private final UserFactory userFactory;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public IssueHelperImpl(IssueService issueService, FieldScreenRendererFactory fieldScreenRendererFactory, IssueFactory issueFactory, UserFactory userFactory, ErrorResultHelper errorResultHelper) {
        this.issueService = issueService;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueFactory = issueFactory;
        this.userFactory = userFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public FieldScreenRenderer createFieldScreenRenderer(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION);
    }

    @Override
    public MutableIssue createIssue(Project project, IssueType issueType) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(project);
        issue.setIssueTypeObject(issueType);
        return issue;
    }

    @Override
    public io.atlassian.fugue.Option<CheckedUser> getReporterOpt(Issue issue) {
        return this.optionalCheckedUser(issue.getReporterUser());
    }

    @Override
    public io.atlassian.fugue.Option<CheckedUser> getAssigneeOpt(Issue issue) {
        return this.optionalCheckedUser(issue.getAssigneeUser());
    }

    private io.atlassian.fugue.Option<CheckedUser> optionalCheckedUser(ApplicationUser applicationUser) {
        return io.atlassian.fugue.Option.option((Object)applicationUser).flatMap(appUser -> {
            Option checkedUser = this.userFactory.wrap(appUser).toOption();
            return StepsConverters.newerOption((Option)checkedUser);
        });
    }

    @Override
    public Either<AnError, Issue> getIssueByKey(CheckedUser user, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user.forJIRA(), issueKey);
        MutableIssue issue = issueResult.getIssue();
        return io.atlassian.fugue.Option.option((Object)issue).toRight(this::issueNotFoundError);
    }

    @Override
    public Either<AnError, Project> getProjectFromIssue(Issue issue) {
        return io.atlassian.fugue.Option.option((Object)issue.getProjectObject()).toRight(this::projectNotFoundError);
    }

    private AnError issueNotFoundError() {
        return this.errorResultHelper.notFound404("sd.issue.helper.issue.key.not.found", new Object[0]).build();
    }

    private AnError projectNotFoundError() {
        return this.errorResultHelper.notFound404("sd.issue.helper.project.not.found", new Object[0]).build();
    }
}

