/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.jira.crowd;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.jira.crowd.ServiceDeskCrowdUserQueryDslDao;
import com.atlassian.servicedesk.internal.querydsl.mapping.jira.JiraTables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskCrowdUserQueryDslDaoImpl
implements ServiceDeskCrowdUserQueryDslDao {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskCrowdUserQueryDslDaoImpl.class);
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ServiceDeskCrowdUserQueryDslDaoImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public boolean isUserDeletedExternally(CheckedUser checkedUser) {
        boolean deleted;
        Integer deletedExternally = (Integer)this.databaseAccessor.run(connection -> (Integer)((SQLQuery)((SQLQuery)connection.select(JiraTables.CROWD_USER.DELETED_EXTERNALLY).from((Expression)JiraTables.CROWD_USER)).where((Predicate)JiraTables.CROWD_USER.DIRECTORY_ID.eq((Object)checkedUser.forJIRA().getDirectoryId()).and((Predicate)JiraTables.CROWD_USER.LOWER_USERNAME.eq((Object)StringUtils.lowerCase((String)checkedUser.getName()))))).fetchOne());
        boolean bl = deleted = deletedExternally != null && deletedExternally != 0;
        if (deleted && checkedUser.forJIRA().isActive()) {
            log.warn("There seems to be an inconsistent user state for {}, as user is active but marked as deleted externally", (Object)checkedUser.getName());
        }
        return deleted;
    }
}

