/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.lifecycle.services.OptionalService;
import com.atlassian.pocketknife.spi.lifecycle.services.OptionalServiceAccessor;
import com.atlassian.servicedesk.internal.api.feature.gettingstarted.PostServiceDeskCreationParticipant;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PostCreationParticipantAccessor
extends OptionalServiceAccessor<PostServiceDeskCreationParticipant> {
    private static final Logger LOG = LoggerFactory.getLogger(PostCreationParticipantAccessor.class);

    @Autowired
    public PostCreationParticipantAccessor(BundleContext bundleContext) {
        super(bundleContext, PostServiceDeskCreationParticipant.class.getCanonicalName());
    }

    public List<AnError> executePostCreationJobs(ApplicationUser applicationUser, Project project) {
        try (OptionalService service2 = this.obtain();){
            if (service2.isAvailable()) {
                List<AnError> list = service2.getAll().stream().flatMap(participant -> this.executePostCreationJob(applicationUser, project, (PostServiceDeskCreationParticipant)participant).stream()).collect(Collectors.toList());
                return list;
            }
            List<AnError> list = Collections.emptyList();
            return list;
        }
    }

    private List<AnError> executePostCreationJob(ApplicationUser applicationUser, Project project, PostServiceDeskCreationParticipant participant) {
        return (List)participant.executePostCreationJob(applicationUser, project).fold(anError -> ImmutableList.of((Object)anError), unit -> Collections.emptyList());
    }
}

