/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.SeriesDataType;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.CascadingCustomFieldUtil;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.ProjectTemplateCustomFieldsManager;
import com.atlassian.servicedesk.internal.feature.gettingstarted.GettingStartedReportCreationService;
import com.atlassian.servicedesk.internal.feature.gettingstarted.ServiceDeskProjectTemplateType;
import com.atlassian.servicedesk.internal.feature.report.CountLineGraph;
import com.atlassian.servicedesk.internal.feature.report.ReportManagerScala;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesColours;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesImpl;
import com.atlassian.servicedesk.internal.rest.responses.SeriesColour;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GettingStartedReportCreationServiceImpl
implements GettingStartedReportCreationService {
    private final InternalTimeMetricService timeMetricService;
    private final PriorityManager priorityManager;
    private final ReportManagerScala reportManager;
    private final I18nHelper.BeanFactory i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final SearchService searchService;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final ProjectTemplateCustomFieldsManager customFieldsManager;
    private static final long NO_VALUE = -1L;
    private static final String EMPTY_JQL = "";

    @Autowired
    public GettingStartedReportCreationServiceImpl(InternalTimeMetricService timeMetricService, PriorityManager priorityManager, ReportManagerScala reportManager, I18nHelper.BeanFactory i18nHelper, ApplicationProperties applicationProperties, SearchService searchService, VpOriginCustomFieldService vpOriginCustomFieldService, ProjectTemplateCustomFieldsManager customFieldsManager) {
        this.timeMetricService = timeMetricService;
        this.priorityManager = priorityManager;
        this.reportManager = reportManager;
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.customFieldsManager = customFieldsManager;
    }

    @Override
    public List<Report> createDefaultReports(ApplicationUser user, ServiceDesk serviceDesk, ServiceDeskProjectTemplateType templateType) {
        I18nHelper i18n = this.i18nHelper.getInstance(this.applicationProperties.getDefaultLocale());
        Option<TimeMetric> timeToResolutionMetricOption = this.getTimeMetric(user, serviceDesk, i18n.getText("sd.sla.metric.time.to.resolution.name"));
        List priorities = this.priorityManager.getPriorities();
        Priority topPriority = (Priority)priorities.get(0);
        ArrayList<Report> reports = new ArrayList<Report>();
        switch (templateType) {
            case ITIL: {
                reports.addAll(this.itilReports(i18n, timeToResolutionMetricOption, this.incidentJql(i18n), priorities));
                break;
            }
            case ITILV2: {
                Option<TimeMetric> timeToFirstResponseMetricOption = this.getTimeMetric(user, serviceDesk, i18n.getText("sd.sla.metric.time.to.first.response.name"));
                Option<TimeMetric> timeToApproveNormalChangeMetricOption = this.getTimeMetric(user, serviceDesk, i18n.getText("sd.project.template.itil.v2.sla.time.to.approve.normal.change.name"));
                reports.addAll(this.itilV2Reports(i18n, timeToResolutionMetricOption, timeToFirstResponseMetricOption, timeToApproveNormalChangeMetricOption, this.incidentJql(i18n), priorities));
                break;
            }
            case CLASSIC: {
                reports.addAll(this.defaultReports(i18n, timeToResolutionMetricOption, this.buildPriorityName(topPriority, i18n), this.buildPriorityBasedJql(topPriority), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.jira.name")), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.intranet.name")), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.website.name"))));
                break;
            }
            case CUSTOMER_SUPPORT: {
                reports.addAll(this.customerSupportReports(i18n, timeToResolutionMetricOption, this.buildPriorityName(topPriority, i18n), this.buildPriorityBasedJql(topPriority)));
                break;
            }
            case BASIC: {
                Option<TimeMetric> timeToFirstResponseMetricOption = this.getTimeMetric(user, serviceDesk, i18n.getText("sd.sla.metric.time.to.first.response.name"));
                reports.addAll(this.basicReports(i18n, timeToResolutionMetricOption, timeToFirstResponseMetricOption, this.buildPriorityName(topPriority, i18n), this.buildPriorityBasedJql(topPriority), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.jira.name")), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.intranet.name")), this.buildComponentJql(i18n.getText("sd.premade.project.servicedesk.component.website.name"))));
                break;
            }
        }
        reports.forEach(report -> this.reportManager.createReportAndSeries(serviceDesk, (Report)report));
        return reports;
    }

    private Option<TimeMetric> getTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, String timeMetricName) {
        return Option.fromOptional(this.timeMetricService.getTimeMetrics(user, serviceDesk).stream().filter(t -> t.getName().equals(timeMetricName)).map(t -> t).findFirst());
    }

    private List<Report> defaultReports(I18nHelper i18n, Option<TimeMetric> timeToResolutionMetricOption, String topPriorityName, String topPriorityJql, String componentJiraJql, String componentIntranetJql, String componentPublicWebsiteJql) {
        ArrayList reports = Lists.newArrayList((Object[])new Report[]{this.createdVsResolvedReport(1, i18n)});
        timeToResolutionMetricOption.forEach(timeToResolutionMetric -> {
            reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.time.to.resolution"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(2), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.all.issues"), EMPTY_JQL, SeriesColours.ADG_LIME_GREEN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.highest.priority.only", topPriorityName), topPriorityJql, SeriesColours.ADG_ORANGE(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L)));
            reports.add(this.slaMetVsMissed(3, i18n, (TimeMetric)timeToResolutionMetric));
            reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.resolution.by.component"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(4), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.premade.project.servicedesk.component.website.name"), componentPublicWebsiteJql, SeriesColours.ADG_LIME_GREEN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.premade.project.servicedesk.component.intranet.name"), componentIntranetJql, SeriesColours.ADG_LIGHT_BROWN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.premade.project.servicedesk.component.jira.name"), componentJiraJql, SeriesColours.ADG_MAUVE(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L)));
        });
        return reports;
    }

    private List<Report> basicReports(I18nHelper i18n, Option<TimeMetric> timeToResolutionMetricOption, Option<TimeMetric> timeToFirstResponseMetricOption, String topPriorityName, String topPriorityJql, String componentJiraJql, String componentIntranetJql, String componentPublicWebsiteJql) {
        ArrayList basicReports = Lists.newArrayList(this.defaultReports(i18n, timeToResolutionMetricOption, topPriorityName, topPriorityJql, componentJiraJql, componentIntranetJql, componentPublicWebsiteJql));
        if (timeToFirstResponseMetricOption.isDefined() && timeToResolutionMetricOption.isDefined()) {
            basicReports.add(this.getSlaSuccessRateReport(2, i18n, (TimeMetric)timeToFirstResponseMetricOption.get(), (TimeMetric)timeToResolutionMetricOption.get()));
        }
        return basicReports;
    }

    private Report getSlaSuccessRateReport(int order, I18nHelper i18n, TimeMetric timeToFirstResponse, TimeMetric timeToResolution) {
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.basic.reports.sla.success.rate"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.report.initial.time.to.first.response"), EMPTY_JQL, SeriesColours.ADG_GREEN(), SeriesDataType.SLA_PERCENTAGE, (Option<Long>)Option.some((Object)new Long(timeToFirstResponse.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.report.initial.time.to.resolution"), EMPTY_JQL, SeriesColours.ADG_CYAN(), SeriesDataType.SLA_PERCENTAGE, (Option<Long>)Option.some((Object)new Long(timeToResolution.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L));
    }

    private List<Report> customerSupportReports(I18nHelper i18n, Option<TimeMetric> timeToResolutionMetricOption, String topPriorityName, String topPriorityJql) {
        ArrayList reports = Lists.newArrayList((Object[])new Report[]{this.createdVsResolvedReport(1, i18n)});
        timeToResolutionMetricOption.forEach(timeToResolutionMetric -> {
            reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.time.to.resolution"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(2), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.all.issues"), EMPTY_JQL, SeriesColours.ADG_LIME_GREEN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.highest.priority.only", topPriorityName), topPriorityJql, SeriesColours.ADG_ORANGE(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L)));
            reports.add(this.slaMetVsMissed(3, i18n, (TimeMetric)timeToResolutionMetric));
        });
        reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.customer.support.report.support.requests.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(4), (List)ImmutableList.of((Object)this.createCreatedRequestTypeSeries(i18n, "sd.project.template.customer.support.requesttype.technical.support.name", SeriesColours.ADG_RED()), (Object)this.createCreatedRequestTypeSeries(i18n, "sd.project.template.customer.support.requesttype.licensing.name", SeriesColours.ADG_GREEN()), (Object)this.createCreatedRequestTypeSeries(i18n, "sd.project.template.customer.support.requesttype.trial.questions.name", SeriesColours.ADG_CYAN()), (Object)this.createCreatedRequestTypeSeries(i18n, "sd.project.template.customer.support.requesttype.other.questions.name", SeriesColours.ADG_LIGHT_BROWN())), Long.valueOf(0L)));
        AtomicInteger seriesColourIndex = new AtomicInteger();
        reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.customer.support.report.bug.by.type.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(5), this.priorityManager.getPriorities().stream().map(priority -> this.createIssueTypeWithPrioritySeries(i18n, "sd.project.template.customer.support.issuetype.bug.name", priority.getName(), this.getSeriesColour(seriesColourIndex.getAndIncrement()))).collect(Collectors.toList()), Long.valueOf(0L)));
        return reports;
    }

    private String buildPriorityBasedJql(Priority priority) {
        if (priority != null) {
            Query query = JqlQueryBuilder.newBuilder().where().priority(new String[]{priority.getName()}).buildQuery();
            return this.searchService.getJqlString(query);
        }
        return EMPTY_JQL;
    }

    private String buildPriorityName(Priority priority, I18nHelper i18n) {
        if (priority != null) {
            return priority.getName();
        }
        return i18n.getText("sd.series.initial.none");
    }

    private String buildComponentJql(String component) {
        if (StringUtils.isNotBlank((String)component)) {
            Query query = JqlQueryBuilder.newBuilder().where().component(new String[]{component}).buildQuery();
            return this.searchService.getJqlString(query);
        }
        return EMPTY_JQL;
    }

    private String incidentJql(I18nHelper i18n) {
        Query query = JqlQueryBuilder.newBuilder().where().issueType().eq(i18n.getText("sd.project.template.itil.issuetype.incident.name")).buildQuery();
        return this.searchService.getJqlString(query);
    }

    private String incidentByPriorityJQL(I18nHelper i18n, Priority priority) {
        Query query = JqlQueryBuilder.newBuilder().where().issueType().eq(i18n.getText("sd.project.template.itil.issuetype.incident.name")).and().priority().eq(priority.getName()).buildQuery();
        return this.searchService.getJqlString(query);
    }

    private List<Report> itilV2Reports(I18nHelper i18n, Option<TimeMetric> timeToResolutionMetricOption, Option<TimeMetric> timeToFirstResponseMetricOption, Option<TimeMetric> timeToApproveNormalChangeMetricOption, String incidentJQL, List<Priority> priorities) {
        ArrayList<Report> reports = new ArrayList<Report>();
        reports.addAll(this.itilReports(i18n, timeToResolutionMetricOption, incidentJQL, priorities));
        if (timeToFirstResponseMetricOption.isDefined() && timeToResolutionMetricOption.isDefined()) {
            reports.add(this.getSlaSuccessRateReport(reports.size() + 1, i18n, (TimeMetric)timeToFirstResponseMetricOption.get(), (TimeMetric)timeToResolutionMetricOption.get()));
        }
        reports.add(this.getServiceRequestsReport(reports.size() + 1, i18n));
        reports.add(this.getProblemsByPriorityReport(reports.size() + 1, i18n));
        reports.add(this.getChangeByTypeReport(reports.size() + 1, i18n));
        timeToApproveNormalChangeMetricOption.forEach(timeToApproveNormalChangeMetric -> reports.add(this.getTimeToApproveNormalChangeReport(reports.size() + 1, i18n, (TimeMetric)timeToApproveNormalChangeMetric)));
        return reports;
    }

    private Report getServiceRequestsReport(int order, I18nHelper i18n) {
        int seriesColourIndex = 0;
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.itil.v2.report.service.requests.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.v2.report.service.requests.all"), this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().issueType().in(new String[]{i18n.getText("sd.project.template.itil.issuetype.service.request.name"), i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")}).endWhere().buildQuery()), this.getSeriesColour(seriesColourIndex++), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.name"), this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldService.getVpOriginCustomField().getFieldName()).eq(i18n.getText("sd.project.template.itil.v2.requesttype.onboard.new.employees.name")).endWhere().buildQuery()), this.getSeriesColour(seriesColourIndex++), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.requesttype.compsupport.name"), this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldService.getVpOriginCustomField().getFieldName()).eq(i18n.getText("sd.project.template.itil.requesttype.compsupport.name")).endWhere().buildQuery()), this.getSeriesColour(seriesColourIndex++), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name"), this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldService.getVpOriginCustomField().getFieldName()).eq(i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name")).endWhere().buildQuery()), this.getSeriesColour(seriesColourIndex++), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none())), Long.valueOf(0L));
    }

    private Report getProblemsByPriorityReport(int order, I18nHelper i18n) {
        AtomicInteger seriesColourIndex = new AtomicInteger();
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.itil.v2.report.problems.by.priority.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), this.priorityManager.getPriorities().stream().map(priority -> this.createIssueTypeWithPrioritySeries(i18n, "sd.project.template.itil.issuetype.problem.name", priority.getName(), this.getSeriesColour(seriesColourIndex.getAndIncrement()))).collect(Collectors.toList()), Long.valueOf(0L));
    }

    private Report getChangeByTypeReport(int order, I18nHelper i18n) {
        Query allChangeJql = JqlQueryBuilder.newBuilder().where().issueType().eq(i18n.getText("sd.project.template.itil.issuetype.change.name")).endWhere().buildQuery();
        ArrayList<Series> changeByTypeSeries = new ArrayList<Series>();
        AtomicInteger seriesColourIndex = new AtomicInteger();
        changeByTypeSeries.add(new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.v2.report.change.by.type.all"), this.searchService.getJqlString(allChangeJql), this.getSeriesColour(seriesColourIndex.getAndIncrement()), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none()));
        Option<CustomField> changeTypeOption = this.customFieldsManager.getOrCreateChangeTypeCustomField();
        if (changeTypeOption.isDefined()) {
            changeByTypeSeries.addAll(this.createCustomFieldValueSeriesList((CustomField)changeTypeOption.get(), allChangeJql, seriesColourIndex));
        }
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.itil.v2.report.change.by.type.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), changeByTypeSeries, Long.valueOf(0L));
    }

    private Report getTimeToApproveNormalChangeReport(int order, I18nHelper i18n, TimeMetric timeToApproveNormalChangeMetric) {
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.itil.v2.sla.time.to.approve.normal.change.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.v2.sla.time.to.approve.normal.change.name"), EMPTY_JQL, SeriesColours.ADG_LIME_GREEN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToApproveNormalChangeMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L));
    }

    private List<Report> itilReports(I18nHelper i18n, Option<TimeMetric> timeToResolutionMetricOption, String incidentJQL, List<Priority> priorities) {
        ArrayList reports = Lists.newArrayList((Object[])new Report[]{this.createdVsResolvedReport(1, i18n)});
        timeToResolutionMetricOption.forEach(timeToResolutionMetric -> {
            reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.time.to.resolution"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(reports.size() + 1), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.all.issues"), EMPTY_JQL, SeriesColours.ADG_LIME_GREEN(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.project.template.itil.reports.sla.series.incidents.name"), incidentJQL, SeriesColours.ADG_ORANGE(), SeriesDataType.TIME_METRIC_ELAPSED_TIME, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L)));
            reports.add(this.slaMetVsMissed(reports.size() + 1, i18n, (TimeMetric)timeToResolutionMetric));
        });
        AtomicInteger seriesColourIndex = new AtomicInteger();
        reports.add(new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.project.template.itil.reports.incident.by.priority.report.name"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(reports.size() + 1), priorities.stream().map(priority -> new SeriesImpl(-1L, -1L, priority.getName(), this.incidentByPriorityJQL(i18n, (Priority)priority), this.getSeriesColour(seriesColourIndex.getAndIncrement()), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none())).collect(Collectors.toList()), Long.valueOf(0L)));
        return reports;
    }

    private Report createdVsResolvedReport(int order, I18nHelper i18n) {
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.tickets.created.vs.resolved"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText(SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY.getTypeKey()), EMPTY_JQL, SeriesColours.ADG_BRIGHT_PINK(), SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText(SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY.getTypeKey()), EMPTY_JQL, SeriesColours.ADG_EMERALD(), SeriesDataType.RESOLVED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none())), Long.valueOf(0L));
    }

    private String getSeriesColour(int index) {
        List<SeriesColour> approvedColours = SeriesColours.getAdgApprovedColorsAsJava();
        if (index >= approvedColours.size()) {
            index = 0;
        }
        return approvedColours.get(index).full();
    }

    private Report slaMetVsMissed(int order, I18nHelper i18n, TimeMetric timeToResolutionMetric) {
        return new Report(Long.valueOf(-1L), Long.valueOf(-1L), i18n.getText("sd.report.initial.sla.resolution"), Option.some((Object)CountLineGraph.getTypeKey()), Integer.valueOf(order), (List)ImmutableList.of((Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.succeeded"), EMPTY_JQL, SeriesColours.ADG_GREEN(), SeriesDataType.SLA_SUCCEEDED, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none()), (Object)new SeriesImpl(-1L, -1L, i18n.getText("sd.series.initial.breached"), EMPTY_JQL, SeriesColours.ADG_RED(), SeriesDataType.SLA_BREACHED, (Option<Long>)Option.some((Object)new Long(timeToResolutionMetric.getId().intValue())), (Option<Integer>)Option.none())), Long.valueOf(0L));
    }

    private Series createCreatedRequestTypeSeries(I18nHelper i18n, String requestTypeNameKey, String color) {
        String requestTypeName = i18n.getText(requestTypeNameKey);
        return new SeriesImpl(-1L, -1L, requestTypeName, this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldService.getVpOriginCustomField().getName()).eq(requestTypeName).endWhere().buildQuery()), color, SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none());
    }

    private Series createIssueTypeWithPrioritySeries(I18nHelper i18n, String issueTypeNameKey, String priorityNameKey, String color) {
        String issueType = i18n.getText(issueTypeNameKey);
        Query query = JqlQueryBuilder.newBuilder().where().issueType().eq(issueType).and().priority().eq(priorityNameKey).endWhere().buildQuery();
        return new SeriesImpl(-1L, -1L, priorityNameKey, this.searchService.getJqlString(query), color, SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none());
    }

    private List<Series> createCustomFieldValueSeriesList(CustomField customField, Query prereqJql, AtomicInteger seriesColourIndex) {
        List<Object> customFieldSeries = new ArrayList<Series>();
        Option<Options> optionsOption = CascadingCustomFieldUtil.getOptionsForCustomField(customField);
        if (optionsOption.isDefined()) {
            customFieldSeries = ((Options)optionsOption.get()).stream().map(option -> this.createCustomFieldValueSeries(prereqJql, customField.getFieldName(), option.toString(), this.getSeriesColour(seriesColourIndex.getAndIncrement()))).collect(Collectors.toList());
        }
        return customFieldSeries;
    }

    private Series createCustomFieldValueSeries(Query prereqJql, String customFieldName, String customFieldValue, String color) {
        Query newJql = JqlQueryBuilder.newBuilder((Query)prereqJql).where().and().field(customFieldName).eq(customFieldValue).endWhere().buildQuery();
        return new SeriesImpl(-1L, -1L, customFieldValue, this.searchService.getJqlString(newJql), color, SeriesDataType.CREATED_COUNT, (Option<Long>)Option.none(), (Option<Integer>)Option.none());
    }
}

