/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalGettingStartedHelper;
import com.atlassian.servicedesk.internal.feature.gettingstarted.DefaultFieldConfig;
import com.atlassian.servicedesk.internal.feature.gettingstarted.FieldConfigBuilder;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.DefaultKeys;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeIssueTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectComponentMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectStatusMapping;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeRequestTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresets;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresetsEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class CustomerSupportProjectMetadata
implements PremadeProjectMetadata {
    private static final String COMMON_REQUESTS_GROUP_KEY = "sd.project.template.customer.support.requesttype.general.group";
    private static final String TECHNICAL_SUPPORT_RT_KEY = "technicalsupport";
    private static final String BUG_RT_KEY = "bug";
    private static final String LICENSING_RT_KEY = "licensing";
    private static final String TRIAL_QUESTIONS_RT_KEY = "trialquestions";
    private static final String SUGGEST_FEATURE_RT_KEY = "suggestfeature";
    private static final String SUGGEST_IMPROVEMENT_RT_KEY = "suggestimprovement";
    private static final String QUESTIONS_RT_KEY = "otherquestions";
    private final I18nHelper i18n;
    private final SearchService searchService;
    private final PriorityManager priorityManager;
    private final ApprovalGettingStartedHelper approvalGettingStartedHelper;
    private final Supplier<String> vpOriginCustomFieldName;

    public CustomerSupportProjectMetadata(I18nHelper i18n, SearchService searchService, PriorityManager priorityManager, ApprovalGettingStartedHelper approvalGettingStartedHelper, VpOriginCustomFieldService vpOriginCustomFieldService) {
        this.i18n = i18n;
        this.searchService = searchService;
        this.priorityManager = priorityManager;
        this.approvalGettingStartedHelper = approvalGettingStartedHelper;
        this.vpOriginCustomFieldName = () -> vpOriginCustomFieldService.getVpOriginCustomField().getFieldName();
    }

    @Override
    public List<PremadeProjectComponentMetadata> components(Project project) {
        return this.components();
    }

    @Override
    public List<PremadeIssueTypeMetadata> issueTypes(Project project) {
        return this.issueTypes();
    }

    @Override
    public void addCustomFieldsToScreen(FieldScreen fieldScreen) {
    }

    @Override
    public List<String> getRequestTypeGroupOrder() {
        return new ArrayList<String>();
    }

    @Override
    public PremadeWorkflowPresets workflow(Project project, boolean allowUnassigned) {
        return new PremadeWorkflowPresets((List<PremadeWorkflowPresetsEntry>)this.getPremadeWorkflowPresetEntries(project, allowUnassigned), this.i18n.getText("sd.workflow.scheme.name.for.project", project.getKey()), this.i18n.getText("sd.workflow.scheme.desc.for.project", project.getKey()));
    }

    private ImmutableList<PremadeWorkflowPresetsEntry> getPremadeWorkflowPresetEntries(Project project, boolean allowUnassigned) {
        return ImmutableList.of((Object)this.getSupportWorkflow(project), (Object)this.getTaskSubtaskPremadeWorkflow(project));
    }

    private PremadeWorkflowPresetsEntry getSupportWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk Service Request Fulfilment Workflow.jwb", this.i18n.getText("sd.workflow.name.for.service.request", project.getKey()), this.i18n.getText("sd.workflow.desc.for.service.request", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.customer.support.issuetype.support.name")));
    }

    private PremadeWorkflowPresetsEntry getTaskSubtaskPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Task Subtask Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.task", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.task", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.project.template.customer.support.issuetype.bug.name"), (Object)this.i18n.getText("sd.project.template.customer.support.issuetype.new.feature.name")));
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForEmptyProject(boolean allowUnassigned) {
        ArrayList<PremadeProjectQueueMetadata> customerQueues = new ArrayList<PremadeProjectQueueMetadata>();
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.queues.all.open"), this.allOpenJQL(), 0));
        if (allowUnassigned) {
            customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.unassigned.name"), this.unassignedIssueQueueJQL(), 1));
        }
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.itil.queues.assignedtome.name"), this.assignedToMeQueueJQL(), 2));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.waiting.on.customer"), this.waitingOnCustomerJQL(), 3));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.bugs"), this.bugsJQL(), 4));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.issues"), this.openSupportIssuesJQL(), 5));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.issues.licensing"), this.licensingAndBillingJQL(), 6));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.trial.questions"), this.trialQuestionsJQL(), 7));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.other.questions"), this.otherQuestionsJQL(), 8));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.feature.suggestion.technical"), this.technicalSupportJQL(), 9));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.open.support.feature.suggestions"), this.featureSuggestionJQL(), 10));
        customerQueues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.customer.support.queue.resolved.last.seven.days"), this.resolvedLastWeekJQL(), 11, DefaultKeys.defaultColumnsWithFeedback));
        return customerQueues;
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForExistingProject() {
        return Collections.emptyList();
    }

    @Override
    public PremadeProjectStatusMapping statusMapping() {
        return new PremadeProjectStatusMapping((Map<String, String>)ImmutableMap.of());
    }

    @Override
    public Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, Portal portal, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        return this.defaultIssuesVelocityMap(allowUnassigned, user, project, translatedStatus, i18n, webResourceUrlProvider, vpOriginCustomFieldService);
    }

    private String allOpenJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String unassignedIssueQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsEmpty().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String assignedToMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String waitingOnCustomerJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().status().eq(this.i18n.getText("sd.workflow.basic.request.with.approvals.waiting.for.customer")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String resolvedLastWeekJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().resolutionDateAfter("-1w").endWhere().orderBy().resolutionDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String bugsJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.customer.support.issuetype.bug.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String openSupportIssuesJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().issueType().eq(this.i18n.getText("sd.project.template.customer.support.issuetype.support.name")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String licensingAndBillingJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldName.get()).eq(this.i18n.getText("sd.project.template.customer.support.requesttype.licensing.name")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String trialQuestionsJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldName.get()).eq(this.i18n.getText("sd.project.template.customer.support.requesttype.trial.questions.name")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String otherQuestionsJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldName.get()).eq(this.i18n.getText("sd.project.template.customer.support.requesttype.other.questions.name")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String technicalSupportJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().field(this.vpOriginCustomFieldName.get()).eq(this.i18n.getText("sd.project.template.customer.support.requesttype.technical.support.name")).and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String featureSuggestionJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.project.template.customer.support.issuetype.new.feature.name")).endWhere().buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    List<PremadeProjectComponentMetadata> components() {
        return ImmutableList.of((Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.customer.support.component.jira.name"), this.i18n.getText("sd.project.template.customer.support.component.jira.description"), 0L), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.project.template.customer.support.component.website.name"), this.i18n.getText("sd.project.template.customer.support.component.website.description"), 0L));
    }

    List<PremadeIssueTypeMetadata> issueTypes() {
        return ImmutableList.of((Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.customer.support.issuetype.support.name"), this.i18n.getText("sd.project.template.customer.support.issuetype.support.description"), "/servicedesk/issue-type-icons?icon=support", this.defaultSupportRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.customer.support.issuetype.bug.name"), this.i18n.getText("sd.project.template.customer.support.issuetype.bug.description"), "/servicedesk/issue-type-icons?icon=bug", this.defaultBugRequestTypes()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.customer.support.issuetype.new.feature.name"), this.i18n.getText("sd.project.template.customer.support.issuetype.new.feature.description"), "/servicedesk/issue-type-icons?icon=new-feature", this.defaultNewFeatureRequestTypes()));
    }

    private List<PremadeRequestTypeMetadata> defaultSupportRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(TECHNICAL_SUPPORT_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.technical.support.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.technical.support.description"), "", RequestTypeSystemIcon.ICON_WRENCH, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", "", true), (Object)this.requestTypeField("components", this.i18n.getText("sd.project.template.customer.support.requesttype.technical.support.field.components.name"), "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(LICENSING_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.licensing.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.licensing.description"), "", RequestTypeSystemIcon.ICON_ENVELOPE, this.statusMapping(), this.getLicensingAndBillingFields(), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(TRIAL_QUESTIONS_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.trial.questions.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.trial.questions.description"), "", RequestTypeSystemIcon.ICON_QUESTION, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(QUESTIONS_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.other.questions.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.other.questions.description"), "", RequestTypeSystemIcon.ICON_LOOP, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))));
    }

    private List<DefaultFieldConfig> getLicensingAndBillingFields() {
        ArrayList<DefaultFieldConfig> fields = new ArrayList<DefaultFieldConfig>();
        fields.add(this.requestTypeField("summary", "", "", true));
        fields.add(this.requestTypeField("description", "", "", false));
        fields.add(this.requestTypeField("attachment", "", "", false));
        List priorities = this.priorityManager.getPriorities();
        if (priorities.size() > 0) {
            Priority secondHighest = priorities.size() == 1 ? (Priority)priorities.get(0) : (Priority)priorities.get(1);
            fields.add(new FieldConfigBuilder().setFieldId("priority").setRequired(false).setDisplayed(false).setValues((Map<String, List<String>>)ImmutableMap.of((Object)"priority", (Object)ImmutableList.of((Object)secondHighest.getId()))).build());
        }
        return fields;
    }

    private List<PremadeRequestTypeMetadata> defaultBugRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(BUG_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.bug.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.bug.description"), "", RequestTypeSystemIcon.ICON_THUNDER, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", this.i18n.getText("sd.project.template.customer.support.requesttype.bug.field.summary.description"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.customer.support.requesttype.bug.field.description.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.bug.field.description.description"), true), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))));
    }

    private List<PremadeRequestTypeMetadata> defaultNewFeatureRequestTypes() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(SUGGEST_FEATURE_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.suggest.feature.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.suggest.feature.description"), "", RequestTypeSystemIcon.ICON_CAMERA, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(SUGGEST_IMPROVEMENT_RT_KEY, this.i18n.getText("sd.project.template.customer.support.requesttype.suggest.improvement.name"), this.i18n.getText("sd.project.template.customer.support.requesttype.suggest.improvement.description"), "", RequestTypeSystemIcon.ICON_LIGHT_BULB, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", "", "", true), (Object)this.requestTypeField("description", "", "", false), (Object)this.requestTypeField("attachment", "", "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(COMMON_REQUESTS_GROUP_KEY))));
    }

    private DefaultFieldConfig requestTypeField(String fieldId, String label, String help, boolean required2) {
        return new FieldConfigBuilder().setFieldId(fieldId).setLabel(label).setHelp(help).setRequired(required2).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build();
    }

    private DefaultFieldConfig hiddenRequestTypeField(String fieldId) {
        return new FieldConfigBuilder().setFieldId(fieldId).setLabel("").setHelp("").setRequired(false).setDisplayed(false).setValues((Map<String, List<String>>)ImmutableMap.of()).build();
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order) {
        return new PremadeProjectQueueMetadata(name, jql, order);
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order, List<String> columns) {
        return new PremadeProjectQueueMetadata(name, jql, order, columns);
    }

    @VisibleForTesting
    Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("issueTypeAsHtml", i18n.getText("sd.project.template.customer.support.issuetype.support.name"));
        map.put("statusAsHtml", translatedStatus);
        map.put("summaryAsHtml", i18n.getText("sd.project.template.default.itil.issue.summary"));
        map.put("descriptionAsHtml", i18n.getText("sd.project.template.default.itil.issue.description"));
        map.put("projectKey", project.getKey());
        map.put("projectName", project.getName());
        map.put("priority", ((Priority)this.priorityManager.getPriorities().get(0)).getId());
        map.put("assignee", allowUnassigned ? null : user.getName());
        map.put("reporter", project.getLeadUserName());
        map.put("requestTypeFieldname", vpOriginCustomFieldService.getVpOriginCustomField().getFieldName());
        map.put("requestTypeValue", project.getKey().toLowerCase() + "/" + TECHNICAL_SUPPORT_RT_KEY);
        return Collections.unmodifiableMap(map);
    }
}

