/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.gettingstarted;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.query.Query;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApproversCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.gettingstarted.DefaultFieldConfig;
import com.atlassian.servicedesk.internal.feature.gettingstarted.FieldConfigBuilder;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.DefaultKeys;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeIssueTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectComponentMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectStatusMapping;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeRequestTypeMetadata;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresets;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeWorkflowPresetsEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicServiceDeskProjectMetadata
implements PremadeProjectMetadata {
    private static final String GENERAL_GROUP_KEY = "sd.project.template.basic.request.type.groups.general";
    private static final String NEED_APPROVAL_GROUP_KEY = "sd.project.template.basic.request.type.groups.needapproval";
    private static final String DESKTOP_SUPPORT_RT_KEY = "desktoplaptopsupport";
    private static final String GET_IT_HELP_RT_KEY = "getithelp";
    private static final String PURCHASE_UNDER_100_RT_KEY = "purchaseunder100";
    private static final String EMPLOYEE_EXIT_RT_KEY = "employeeexit";
    private static final String NEW_EMPLOYEE_RT_KEY = "newemployee";
    private static final String TRAVEL_REQUESTS_RT_KEY = "travelrequests";
    private static final String PURCHASE_OVER_100_RT_KEY = "purchaseover100";
    private final I18nHelper i18n;
    private final SearchService searchService;
    private final PriorityManager priorityManager;
    private final ApproversCustomFieldManager approversCustomFieldManager;

    public BasicServiceDeskProjectMetadata(I18nHelper i18n, SearchService searchService, PriorityManager priorityManager, ApproversCustomFieldManager approversCustomFieldManager) {
        this.i18n = i18n;
        this.searchService = searchService;
        this.priorityManager = priorityManager;
        this.approversCustomFieldManager = approversCustomFieldManager;
    }

    @Override
    public List<PremadeProjectComponentMetadata> components(Project project) {
        return ImmutableList.of((Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.premade.project.servicedesk.component.jira.name"), this.i18n.getText("sd.premade.project.servicedesk.component.jira.description")), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.premade.project.servicedesk.component.intranet.name"), this.i18n.getText("sd.premade.project.servicedesk.component.intranet.description")), (Object)new PremadeProjectComponentMetadata(this.i18n.getText("sd.premade.project.servicedesk.component.website.name"), this.i18n.getText("sd.premade.project.servicedesk.component.website.description")));
    }

    private DefaultFieldConfig requestTypeField(String fieldId, String label, String help, boolean required2) {
        return new FieldConfigBuilder().setFieldId(fieldId).setLabel(label).setHelp(help).setRequired(required2).setDisplayed(true).setValues((Map<String, List<String>>)ImmutableMap.of()).build();
    }

    @Override
    public List<PremadeIssueTypeMetadata> issueTypes(Project project) {
        return ImmutableList.of((Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.description"), "/servicedesk/issue-type-icons?icon=it-help", this.getItHelpRequestTypeConfig()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.project.template.itil.issuetype.service.request.name"), this.i18n.getText("sd.project.template.itil.issuetype.service.request.description"), "/servicedesk/issue-type-icons?icon=service-request", this.getServiceRequestRequestTypeConfig()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.description"), "/servicedesk/issue-type-icons?icon=request-with-approvals", this.getServiceRequestWithApprovalsRequestTypeConfig()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.description"), "/servicedesk/issue-type-icons?icon=task", this.getTaskRequestTypeConfig()), (Object)new PremadeIssueTypeMetadata(this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.description"), "/servicedesk/issue-type-icons?icon=subtask", this.getSubtaskRequestTypeConfig()));
    }

    @Override
    public void addCustomFieldsToScreen(FieldScreen fieldScreen) {
    }

    @Override
    public List<String> getRequestTypeGroupOrder() {
        return new ArrayList<String>();
    }

    private List<PremadeRequestTypeMetadata> getItHelpRequestTypeConfig() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(GET_IT_HELP_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.getithelp.name"), this.i18n.getText("sd.project.template.basic.requesttype.getithelp.description"), "", RequestTypeSystemIcon.ICON_QUESTION, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.getithelp.field.summary"), this.i18n.getText("sd.project.template.basic.requesttype.getithelp.field.summary.help"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.getithelp.field.description"), "", true)), (List<String>)ImmutableList.of((Object)this.i18n.getText(GENERAL_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(DESKTOP_SUPPORT_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.name"), this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.description"), "", RequestTypeSystemIcon.ICON_ROBOT, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.field.summary"), this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.field.summary.help"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.field.description"), this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.field.description.help"), true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.desktoplaptopsupport.field.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(GENERAL_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(PURCHASE_UNDER_100_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.purchaseunder100.name"), this.i18n.getText("sd.project.template.basic.requesttype.purchaseunder100.description"), "", RequestTypeSystemIcon.ICON_DOLLAR, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.purchaseunder100.field.summary"), "", true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.purchaseunder100.field.description"), "", true), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.purchaseunder100.field.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(GENERAL_GROUP_KEY))));
    }

    private List<PremadeRequestTypeMetadata> getServiceRequestRequestTypeConfig() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(EMPLOYEE_EXIT_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.name"), this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.description"), "", RequestTypeSystemIcon.ICON_LOOP, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.field.summary"), "", true), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.field.duedate"), this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.field.duedate.help"), true), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.field.description"), "", false), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.employeeexit.field.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(GENERAL_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(NEW_EMPLOYEE_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.newemployee.name"), this.i18n.getText("sd.project.template.basic.requesttype.newemployee.description"), "", RequestTypeSystemIcon.ICON_ADD_PERSON, this.statusMapping(), (List<DefaultFieldConfig>)ImmutableList.of((Object)this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.summary"), this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.summary.help"), true), (Object)this.requestTypeField("duedate", this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.duedate"), this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.duedate.help"), false), (Object)this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.description"), "", false), (Object)this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.newemployee.field.attachment"), "", false)), (List<String>)ImmutableList.of((Object)this.i18n.getText(GENERAL_GROUP_KEY))));
    }

    private List<PremadeRequestTypeMetadata> getServiceRequestWithApprovalsRequestTypeConfig() {
        return ImmutableList.of((Object)new PremadeRequestTypeMetadata(TRAVEL_REQUESTS_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.travelrequests.name"), this.i18n.getText("sd.project.template.basic.requesttype.travelrequests.description"), "", RequestTypeSystemIcon.ICON_AEROPLANE, this.statusMapping(), this.getTravelRequestsRequestTypeFields(), (List<String>)ImmutableList.of((Object)this.i18n.getText(NEED_APPROVAL_GROUP_KEY))), (Object)new PremadeRequestTypeMetadata(PURCHASE_OVER_100_RT_KEY, this.i18n.getText("sd.project.template.basic.requesttype.purchaseover100.name"), this.i18n.getText("sd.project.template.basic.requesttype.purchaseover100.description"), "", RequestTypeSystemIcon.ICON_SHARE, this.statusMapping(), this.getPurchaseOver100RequestTypeFields(), (List<String>)ImmutableList.of((Object)this.i18n.getText(NEED_APPROVAL_GROUP_KEY))));
    }

    private List<DefaultFieldConfig> getTravelRequestsRequestTypeFields() {
        ArrayList<DefaultFieldConfig> fields = new ArrayList<DefaultFieldConfig>();
        fields.add(this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.summary"), this.i18n.getText("sd.project.template.basic.requesttype.travelrequests.field.summary.help"), true));
        fields.add(this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.description"), this.i18n.getText("sd.project.template.basic.requesttype.travelrequests.field.description.help"), true));
        Option<DefaultFieldConfig> approversFieldOpt = this.getDefaultApproversField();
        approversFieldOpt.forEach(fields::add);
        fields.add(this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.attachment"), "", false));
        List priorities = this.priorityManager.getPriorities();
        if (priorities.size() > 0) {
            Priority secondHighest = priorities.size() == 1 ? (Priority)priorities.get(0) : (Priority)priorities.get(1);
            fields.add(new FieldConfigBuilder().setFieldId("priority").setRequired(false).setDisplayed(false).setValues((Map<String, List<String>>)ImmutableMap.of((Object)"priority", (Object)ImmutableList.of((Object)secondHighest.getId()))).build());
        }
        return fields;
    }

    private List<DefaultFieldConfig> getPurchaseOver100RequestTypeFields() {
        ArrayList<DefaultFieldConfig> fields = new ArrayList<DefaultFieldConfig>();
        fields.add(this.requestTypeField("summary", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.summary"), "", true));
        fields.add(this.requestTypeField("description", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.description"), "", true));
        Option<DefaultFieldConfig> approversFieldOpt = this.getDefaultApproversField();
        approversFieldOpt.forEach(fields::add);
        fields.add(this.requestTypeField("attachment", this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.attachment"), "", false));
        return fields;
    }

    private Option<DefaultFieldConfig> getDefaultApproversField() {
        Option<CustomField> approversFieldOpt = this.approversCustomFieldManager.getOrCreateApproversCustomField();
        return approversFieldOpt.map(approversField -> this.requestTypeField(approversField.getId(), this.i18n.getText("sd.project.template.basic.requesttype.requestwithapprovals.field.approvers"), "", false));
    }

    private List<PremadeRequestTypeMetadata> getTaskRequestTypeConfig() {
        return ImmutableList.of();
    }

    private List<PremadeRequestTypeMetadata> getSubtaskRequestTypeConfig() {
        return ImmutableList.of();
    }

    @Override
    public PremadeWorkflowPresets workflow(Project project, boolean allowUnassigned) {
        return new PremadeWorkflowPresets((List<PremadeWorkflowPresetsEntry>)this.getPremadeWorkflowPresetEntries(project), this.i18n.getText("sd.workflow.scheme.name.for.project", project.getKey()), this.i18n.getText("sd.workflow.scheme.desc.for.project", project.getKey()));
    }

    private ImmutableList<PremadeWorkflowPresetsEntry> getPremadeWorkflowPresetEntries(Project project) {
        return ImmutableList.of((Object)this.getServiceRequestPremadeWorkflow(project), (Object)this.getServiceRequestWithApprovalsPremadeWorkflow(project), (Object)this.getTaskSubtaskPremadeWorkflow(project));
    }

    private PremadeWorkflowPresetsEntry getServiceRequestPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk Service Request Fulfilment Workflow.jwb", this.i18n.getText("sd.workflow.name.for.service.request", project.getKey()), this.i18n.getText("sd.workflow.desc.for.service.request", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name"), (Object)this.i18n.getText("sd.project.template.itil.issuetype.service.request.name")));
    }

    private PremadeWorkflowPresetsEntry getServiceRequestWithApprovalsPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk Service Request Fulfilment With Approvals Workflow.jwb", this.i18n.getText("sd.workflow.name.for.service.request.with.approvals", project.getKey()), this.i18n.getText("sd.workflow.desc.for.service.request.with.approvals", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")));
    }

    private PremadeWorkflowPresetsEntry getTaskSubtaskPremadeWorkflow(Project project) {
        return new PremadeWorkflowPresetsEntry("/project-templates/Service Desk ITIL V2 Task Subtask Workflow.jwb", this.i18n.getText("sd.workflow.itil.v2.name.task", project.getKey()), this.i18n.getText("sd.workflow.itil.v2.desc.task", project.getKey()), (List<String>)ImmutableList.of((Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.task.name"), (Object)this.i18n.getText("sd.premade.project.servicedesk.issuetype.subtask.name")));
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForEmptyProject(boolean allowUnassigned) {
        ArrayList<PremadeProjectQueueMetadata> queues = new ArrayList<PremadeProjectQueueMetadata>();
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.queues.all.open"), this.allOpenJQL(), 0));
        if (allowUnassigned) {
            queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.unassigned.name"), this.unassignedIssueQueueJQL(), 1));
        }
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.assignedtome.name"), this.assignedToMeQueueJQL(), 2));
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.waitingonme.name"), this.waitingOnMeQueueJQL(), 3));
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.waitingoncustomer.name"), this.waitingOnCustomerQueueJQL(), 4));
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.itissues.name"), this.itIssuesQueueJQL(), 5));
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.servicerequests.name"), this.serviceRequestQueueJQL(), 6));
        List<String> columns = DefaultKeys.defaultColumnsWithFeedback;
        queues.add(this.createPremadeProjectQueueMetadata(this.i18n.getText("sd.project.template.basic.queues.recentlyresolved.name"), this.recentlyResolvedQueueJQL(), 7, columns));
        return queues;
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order) {
        return new PremadeProjectQueueMetadata(name, jql, order);
    }

    private PremadeProjectQueueMetadata createPremadeProjectQueueMetadata(String name, String jql, int order, List<String> columns) {
        return new PremadeProjectQueueMetadata(name, jql, order, columns);
    }

    private String allOpenJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String unassignedIssueQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsEmpty().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String assignedToMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String waitingOnMeQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().and().status().in(new String[]{this.i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support"), this.i18n.getText("sd.workflow.in.progress"), this.i18n.getText("sd.workflow.escalated")}).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String waitingOnCustomerQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().and().status().eq(this.i18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.customer")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String itIssuesQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(this.i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name")).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String serviceRequestQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().in(new String[]{this.i18n.getText("sd.project.template.itil.issuetype.service.request.name"), this.i18n.getText("sd.premade.project.servicedesk.issuetype.service.request.approvals.name")}).endWhere().orderBy().add(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), SortOrder.ASC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    private String recentlyResolvedQueueJQL() {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().resolutionDate().gtEq("-1w").endWhere().orderBy().resolutionDate(SortOrder.DESC).buildQuery();
        return this.searchService.getJqlString(jqlQuery);
    }

    @Override
    public List<PremadeProjectQueueMetadata> queuesForExistingProject() {
        return ImmutableList.of((Object)this.dueSoon(3), (Object)this.slaBreached(2), (Object)this.slaAtRisk(1), (Object)this.myOpenTicketsForExistingProject(0));
    }

    private PremadeProjectQueueMetadata myOpenTicketsForExistingProject(Integer order) {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().assigneeIsCurrentUser().and().unresolved().endWhere().buildQuery();
        String query = this.searchService.getJqlString(jqlQuery);
        return new PremadeProjectQueueMetadata(this.i18n.getText("sd.premade.queue.my.tickets.name"), query, order);
    }

    private PremadeProjectQueueMetadata dueSoon(Integer order) {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().due().ltEq("2d").endWhere().buildQuery();
        String query = this.searchService.getJqlString(jqlQuery);
        return new PremadeProjectQueueMetadata(this.i18n.getText("sd.premade.queue.due.soon.name"), query, order);
    }

    private PremadeProjectQueueMetadata slaBreached(Integer order) {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().addFunctionCondition(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), Operator.EQUALS, "breached").endWhere().buildQuery();
        String query = this.searchService.getJqlString(jqlQuery);
        return new PremadeProjectQueueMetadata(this.i18n.getText("sd.premade.queue.sla.breached.name"), query, order);
    }

    private PremadeProjectQueueMetadata slaAtRisk(Integer order) {
        Query jqlQuery = JqlQueryBuilder.newBuilder().where().unresolved().and().addStringCondition(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), Operator.LESS_THAN, "30m").and().addFunctionCondition(this.i18n.getText("sd.sla.metric.time.to.resolution.name"), Operator.NOT_EQUALS, "breached").endWhere().buildQuery();
        String query = this.searchService.getJqlString(jqlQuery);
        return new PremadeProjectQueueMetadata(this.i18n.getText("sd.premade.queue.sla.at.risk.name"), query, order);
    }

    @Override
    public PremadeProjectStatusMapping statusMapping() {
        return new PremadeProjectStatusMapping((Map<String, String>)ImmutableMap.of());
    }

    @Override
    public Map<String, Object> defaultIssuesVelocityMap(boolean allowUnassigned, CheckedUser user, Project project, Portal portal, String translatedStatus, I18nHelper i18n, WebResourceUrlProvider webResourceUrlProvider, VpOriginCustomFieldService vpOriginCustomFieldService) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("issueTypeAsHtml", i18n.getText("sd.premade.project.servicedesk.issuetype.ithelp.name"));
        map.put("statusAsHtml", translatedStatus);
        map.put("summaryAsHtml", i18n.getText("sd.project.template.default.itil.issue.summary"));
        map.put("descriptionAsHtml", i18n.getText("sd.project.template.default.itil.issue.description"));
        map.put("projectKey", project.getKey());
        map.put("projectName", project.getName());
        map.put("priority", ((Priority)this.priorityManager.getPriorities().get(0)).getId());
        map.put("assignee", allowUnassigned ? null : user.getName());
        map.put("reporter", project.getLeadUserName());
        map.put("requestTypeFieldname", vpOriginCustomFieldService.getVpOriginCustomField().getFieldName());
        map.put("requestTypeValue", project.getKey().toLowerCase() + "/" + GET_IT_HELP_RT_KEY);
        return Collections.unmodifiableMap(map);
    }
}

