/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.settings;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettings;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackValidator;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsInternalManager;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsService;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeedbackSettingsServiceImpl
implements FeedbackSettingsService {
    private final FeedbackSettingsInternalManager feedbackSettingsInternalManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final RequestFeedbackValidator requestFeedbackValidator;
    private final CommonErrors commonErrors;

    @Autowired
    public FeedbackSettingsServiceImpl(CommonErrors commonErrors, FeedbackSettingsInternalManager feedbackSettingsInternalManager, ServiceDeskPermissionService serviceDeskPermissionService, RequestFeedbackValidator requestFeedbackValidator) {
        this.commonErrors = commonErrors;
        this.feedbackSettingsInternalManager = feedbackSettingsInternalManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.requestFeedbackValidator = requestFeedbackValidator;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, FeedbackSettings> getFeedbackSettings(ApplicationUser user, ServiceDesk serviceDesk) {
        Option<AnError> errorOpt = this.checkConditions(user, serviceDesk);
        if (errorOpt.isDefined()) {
            return io.atlassian.fugue.Either.left((Object)errorOpt.get());
        }
        return io.atlassian.fugue.Either.right((Object)this.feedbackSettingsInternalManager.getFeedbackSettings(serviceDesk));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Boolean> setFeedbackFeatureEnabled(ApplicationUser user, ServiceDesk serviceDesk, boolean isEnabled2) {
        Option<AnError> errorOpt = this.checkConditions(user, serviceDesk);
        if (errorOpt.isDefined()) {
            return io.atlassian.fugue.Either.left((Object)errorOpt.get());
        }
        return this.feedbackSettingsInternalManager.setFeedbackFeatureEnabled(serviceDesk, isEnabled2);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, String> setFeedbackQuestion(ApplicationUser user, ServiceDesk serviceDesk, String question) {
        Option<AnError> errorOpt = this.checkConditions(user, serviceDesk);
        if (errorOpt.isDefined()) {
            return io.atlassian.fugue.Either.left((Object)errorOpt.get());
        }
        io.atlassian.fugue.Either<AnError, String> validatedQuestionEither = this.requestFeedbackValidator.validateFeedbackQuestion(question);
        if (validatedQuestionEither.isLeft()) {
            return validatedQuestionEither;
        }
        return this.feedbackSettingsInternalManager.setFeedbackQuestion(serviceDesk, (String)validatedQuestionEither.right().get());
    }

    private Option<AnError> checkConditions(ApplicationUser user, ServiceDesk serviceDesk) {
        io.atlassian.fugue.Either adminAgentEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk));
        if (adminAgentEither.isLeft()) {
            return Option.some((Object)adminAgentEither.left().get());
        }
        if (!((Boolean)adminAgentEither.right().get()).booleanValue()) {
            return Option.some((Object)this.commonErrors.PROJECT_ADMIN_PERMISSION());
        }
        return Option.none();
    }
}

