/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.settings;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettings;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettingsManager;
import com.atlassian.servicedesk.internal.capability.Capability;
import com.atlassian.servicedesk.internal.capability.CapabilityService;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsInternalManager;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={FeedbackSettingsManager.class})
public class FeedbackSettingsInternalManagerImpl
implements FeedbackSettingsInternalManager {
    @Autowired
    private I18nHelper i18nHelper;
    @Autowired
    private CapabilityService capabilityService;

    @Nonnull
    public FeedbackSettings getFeedbackSettings(@Nonnull ServiceDesk serviceDesk) {
        return new FeedbackSettings(this.isFeedbackServiceEnabled(serviceDesk), 5, 1, this.getFeedbackQuestionOrDefault(serviceDesk));
    }

    @Override
    public boolean isFeedbackServiceEnabled(@Nonnull ServiceDesk serviceDesk) {
        Option<String> capabilityOpt = this.capabilityService.getCapability(serviceDesk, "SERVICE_FEEDBACK_REQUEST");
        return Boolean.parseBoolean((String)capabilityOpt.getOrNull());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Boolean> setFeedbackFeatureEnabled(@Nonnull ServiceDesk serviceDesk, boolean isEnabled2) {
        io.atlassian.fugue.Either<ErrorCollection, Capability> capabilityEither = this.capabilityService.setCapability(serviceDesk, "SERVICE_FEEDBACK_REQUEST", Boolean.toString(isEnabled2));
        return StepsConverters.newerEither((Either)ErrorCollectionHelper.toAnErrorEither((Either)StepsConverters.olderEither(capabilityEither).map(cp -> this.isFeedbackServiceEnabled(serviceDesk))));
    }

    @Override
    @Nonnull
    public String getFeedbackQuestionOrDefault(@Nonnull ServiceDesk serviceDesk) {
        Option<String> questionOpt = this.capabilityService.getCapability(serviceDesk, "SERVICE_FEEDBACK_QUESTION");
        return (String)questionOpt.getOrElse((Object)this.i18nHelper.getText("sd.service.request.feedback.question"));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, String> setFeedbackQuestion(@Nonnull ServiceDesk serviceDesk, @Nonnull String question) {
        io.atlassian.fugue.Either<ErrorCollection, Capability> capabilityEither = this.capabilityService.setCapability(serviceDesk, "SERVICE_FEEDBACK_QUESTION", question);
        return StepsConverters.newerEither((Either)ErrorCollectionHelper.toAnErrorEither((Either)StepsConverters.olderEither(capabilityEither).map(cp -> this.getFeedbackQuestionOrDefault(serviceDesk))));
    }
}

