/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.report;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQuery;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FeedbackReportQueryImpl
implements FeedbackReportQuery {
    private Option<String> agentName;
    private Option<String> requestType;
    private Option<List<Long>> ratingList;
    private Option<ServiceDesk> serviceDesk;
    private Option<Date> startDate;
    private Option<Date> endDate;
    private LimitedPagedRequest pagedRequest;

    FeedbackReportQueryImpl(String agentName, String requestType, List<Long> ratingList, LimitedPagedRequest pagedRequest, ServiceDesk serviceDesk, Date startDate, Date endDate) {
        this.agentName = Option.option((Object)agentName);
        this.requestType = Option.option((Object)requestType);
        this.ratingList = Option.option(ratingList);
        this.serviceDesk = Option.option((Object)serviceDesk);
        this.pagedRequest = pagedRequest;
        this.startDate = Option.option((Object)startDate);
        this.endDate = Option.option((Object)endDate);
    }

    public Option<String> agentName() {
        return this.agentName;
    }

    public Option<String> requestType() {
        return this.requestType;
    }

    public Option<List<Long>> ratingList() {
        return this.ratingList;
    }

    public Option<ServiceDesk> serviceDesk() {
        return this.serviceDesk;
    }

    public Option<Date> startDate() {
        return this.startDate;
    }

    public Option<Date> endDate() {
        return this.endDate;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public Query buildJqlQuery(CustomField feedbackCF, CustomField feedbackDateCF) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        this.buildWhere(builder, feedbackCF, feedbackDateCF);
        this.buildOrderBy(builder, feedbackDateCF);
        return builder.buildQuery();
    }

    private void buildWhere(JqlQueryBuilder builder, CustomField feedbackCF, CustomField feedbackDateCF) {
        JqlClauseBuilder clauseBuilder = builder.where().defaultAnd();
        this.serviceDesk.map(sd -> clauseBuilder.project(new Long[]{sd.getProjectId()}));
        this.agentName.map(ag -> clauseBuilder.assigneeUser(ag));
        this.ratingList.fold(() -> clauseBuilder.addCondition(feedbackCF.getClauseNames().getPrimaryName(), Operator.IS_NOT, (Operand)EmptyOperand.EMPTY), ls -> clauseBuilder.addNumberCondition(feedbackCF.getClauseNames().getPrimaryName(), (Collection)ls));
        this.startDate.map(sd -> clauseBuilder.addDateCondition(feedbackDateCF.getClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, sd));
        this.endDate.map(ed -> clauseBuilder.addDateCondition(feedbackDateCF.getClauseNames().getPrimaryName(), Operator.LESS_THAN_EQUALS, ed));
        clauseBuilder.endWhere();
    }

    private void buildOrderBy(JqlQueryBuilder builder, CustomField feedbackDateCF) {
        JqlOrderByBuilder orderByBuilder = builder.orderBy();
        orderByBuilder.add(feedbackDateCF.getClauseNames().getPrimaryName(), SortOrder.DESC);
        orderByBuilder.endOrderBy();
    }
}

