/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.report;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQuery;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQueryBuilder;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportRequest;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportQueryImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class FeedbackReportQueryBuilderImpl
implements FeedbackReportQueryBuilder {
    private String agentName;
    private String requestType;
    private List<Long> ratingList;
    private ServiceDesk serviceDesk;
    private Date startDate;
    private Date endDate;
    private LimitedPagedRequest pageRequest = LimitedPagedRequestImpl.create((int)100);

    public FeedbackReportQueryBuilder agentName(String agentName) {
        this.agentName = agentName;
        return this;
    }

    public FeedbackReportQueryBuilder requestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    public FeedbackReportQueryBuilder ratingList(List<Long> ratingList) {
        this.ratingList = ratingList;
        return this;
    }

    public FeedbackReportQueryBuilder pageRequest(PagedRequest pageRequest) {
        this.pageRequest = LimitedPagedRequestImpl.create((PagedRequest)pageRequest, (int)100);
        return this;
    }

    public FeedbackReportQueryBuilder serviceDesk(ServiceDesk serviceDesk) {
        this.serviceDesk = serviceDesk;
        return this;
    }

    public FeedbackReportQueryBuilder startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public FeedbackReportQueryBuilder endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public FeedbackReportQueryBuilder feedbackReportRequest(FeedbackReportRequest reportRequest, ServiceDesk serviceDesk) {
        this.agentName = reportRequest.getAgentName();
        this.requestType = reportRequest.getRequestType();
        this.ratingList = reportRequest.getRatingList();
        this.serviceDesk = serviceDesk;
        return this;
    }

    public FeedbackReportQuery build() {
        return new FeedbackReportQueryImpl(this.agentName, this.requestType, this.ratingList, this.pageRequest, this.serviceDesk, this.startDate, this.endDate);
    }
}

