/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback.report;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import com.atlassian.servicedesk.internal.api.feedback.Feedback;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQuery;
import com.atlassian.servicedesk.internal.feature.feedback.FeedbackErrors;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackInternalManager;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReport;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportBuilder;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportDataCallback;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportInternalManager;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportPage;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportPageBuilder;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportResult;
import com.atlassian.servicedesk.internal.feature.feedback.report.FeedbackReportSummary;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueSearchService;
import io.atlassian.fugue.Option;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeedbackReportInternalManagerImpl
implements FeedbackReportInternalManager {
    private final IssueDataService issueDataService;
    private final ServiceDeskIssueSearchService issueSearchService;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final RequestFeedbackDateCFManager requestFeedbackDateCFManager;
    private final RequestFeedbackInternalManager requestFeedbackInternalManager;
    private final RequestTypeService requestTypeService;
    private final FeedbackErrors feedbackErrors;
    private static final String OVERALL_SECTION = "overall";

    @Autowired
    public FeedbackReportInternalManagerImpl(IssueDataService issueDataService, ServiceDeskIssueSearchService issueSearchService, RequestFeedbackInternalManager requestFeedbackInternalManager, RequestFeedbackCFManager requestFeedbackCFManager, RequestFeedbackDateCFManager requestFeedbackDateCFManager, RequestTypeService requestTypeService, FeedbackErrors feedbackErrors) {
        this.issueDataService = issueDataService;
        this.issueSearchService = issueSearchService;
        this.requestFeedbackInternalManager = requestFeedbackInternalManager;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.requestFeedbackDateCFManager = requestFeedbackDateCFManager;
        this.requestTypeService = requestTypeService;
        this.feedbackErrors = feedbackErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, FeedbackReportResult> getFeedbackReportByQueryObject(CheckedUser checkedUser, FeedbackReportQuery reportQuery, String expand) {
        if (StringUtils.isNotBlank((String)expand) && expand.contains(OVERALL_SECTION)) {
            return this.buildReportWithExpansion(checkedUser, reportQuery);
        }
        return this.buildPlainReport(checkedUser, reportQuery);
    }

    @Override
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    public io.atlassian.fugue.Either<AnError, FeedbackReportSummary> getSummaryDetail(CheckedUser checkedUser, FeedbackReportQuery reportQuery) {
        return Steps.begin(this.toJqlQuery(reportQuery)).then(this::getFeedbackCF).then((query, fbCF) -> io.atlassian.fugue.Either.right((Object)new FeedbackReportDataCallback((CustomField)fbCF))).then((query, fbCF, callback) -> io.atlassian.fugue.Either.right((Object)this.issueDataService.find(checkedUser.forJIRA(), query, (DataCallback)callback))).yield((query, fbCF, callback, res) -> callback).map(callback -> new FeedbackReportSummary(callback.getAverageRating(), callback.getCountRating()));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, FeedbackReportPage> queryReportBasedOnQueryObject(CheckedUser checkedUser, FeedbackReportQuery reportQuery) {
        return Steps.begin(this.toJqlQuery(reportQuery)).then(query -> this.issueSearchService.getIssues(checkedUser, (ServiceDesk)reportQuery.serviceDesk().get(), (Query)query, reportQuery.pagedRequest().getStart(), reportQuery.pagedRequest().getLimit())).yield((query, result) -> result).map(result -> this.convertIssueToFeedbackReport((SearchResults)result, reportQuery));
    }

    private io.atlassian.fugue.Either<AnError, FeedbackReportResult> buildReportWithExpansion(CheckedUser checkedUser, FeedbackReportQuery reportQuery) {
        return Steps.begin(this.queryReportBasedOnQueryObject(checkedUser, reportQuery)).then(() -> this.getSummaryDetail(checkedUser, reportQuery)).yield((feedbackReportPageResponse, feedbackReportSummary) -> FeedbackReportResult.builder().reportDetail((FeedbackReportPage)feedbackReportPageResponse).summary((FeedbackReportSummary)feedbackReportSummary).build());
    }

    private io.atlassian.fugue.Either<AnError, FeedbackReportResult> buildPlainReport(CheckedUser checkedUser, FeedbackReportQuery reportQuery) {
        return this.queryReportBasedOnQueryObject(checkedUser, reportQuery).map(feedbackReportPageResponse -> FeedbackReportResult.builder().reportDetail((FeedbackReportPage)feedbackReportPageResponse).build());
    }

    private FeedbackReportPage convertIssueToFeedbackReport(SearchResults searchResults, FeedbackReportQuery reportQuery) {
        FeedbackReportPageBuilder feedbackReportPageBuilder = new FeedbackReportPageBuilder();
        feedbackReportPageBuilder.setFeedbackReports(searchResults.getIssues().stream().map(this::toFeedbackReport).collect(Collectors.toList())).setLimit(reportQuery.pagedRequest().getLimit()).setSize(searchResults.getIssues().size()).setStart(searchResults.getStart()).setTotal(searchResults.getTotal());
        return feedbackReportPageBuilder.build();
    }

    private FeedbackReport toFeedbackReport(Issue issue) {
        io.atlassian.fugue.Either requestTypeEither;
        Option<Feedback> feedbackOpt;
        FeedbackReportBuilder reportBuilder = new FeedbackReportBuilder();
        reportBuilder.setAgent(issue.getAssignee());
        reportBuilder.setIssueKey(issue.getKey());
        Project project = issue.getProjectObject();
        if (project != null) {
            reportBuilder.setProjectKey(project.getKey());
        }
        if ((feedbackOpt = this.requestFeedbackInternalManager.getFeedback(issue)).isDefined()) {
            Feedback feedback = (Feedback)feedbackOpt.get();
            reportBuilder.setRating(feedback.getRating());
            reportBuilder.setFeedbackDate(feedback.getRatingDate());
            reportBuilder.setComment((Option<String>)feedback.getComment());
        }
        if ((requestTypeEither = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypeForIssueOverrideSecurity(issue))).isRight()) {
            reportBuilder.setRequestType((RequestType)requestTypeEither.right().get());
        }
        return reportBuilder.build();
    }

    private io.atlassian.fugue.Either<AnError, Query> toJqlQuery(FeedbackReportQuery reportQuery) {
        return Steps.begin(this.getFeedbackCF()).then(this::getFeedbackDateCF).then((fbCF, fbdCF) -> io.atlassian.fugue.Either.right((Object)reportQuery.buildJqlQuery(fbCF, fbdCF))).yield((fbCF, fbdCF, jqlQuery) -> jqlQuery);
    }

    private io.atlassian.fugue.Either<AnError, CustomField> getFeedbackCF() {
        return this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF().toRight(this.feedbackErrors::FEEDBACK_CUSTOM_FIELD_NOT_FOUND);
    }

    private io.atlassian.fugue.Either<AnError, CustomField> getFeedbackDateCF() {
        return this.requestFeedbackDateCFManager.getOrCreateRequestFeedbackDateCF().toRight(this.feedbackErrors::FEEDBACK_CUSTOM_FIELD_NOT_FOUND);
    }
}

