/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.feedback.Feedback;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackParameters;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackToken;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackInternalService;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedback;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackInternalManager;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackValidator;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RequestFeedbackInternalServiceImpl
implements RequestFeedbackInternalService {
    private final RequestFeedbackValidator requestFeedbackValidator;
    private final RequestFeedbackInternalManager requestFeedbackInternalManager;

    @Autowired
    public RequestFeedbackInternalServiceImpl(RequestFeedbackValidator requestFeedbackValidator, RequestFeedbackInternalManager requestFeedbackInternalManager) {
        this.requestFeedbackValidator = requestFeedbackValidator;
        this.requestFeedbackInternalManager = requestFeedbackInternalManager;
    }

    public Either<AnError, ValidatedFeedback> storeFeedback(@Nonnull Issue issue, @Nonnull FeedbackParameters feedbackParameters, @Nonnull FeedbackToken feedbackToken) {
        Assertions.notNull((String)"Issue shouldn't be null", (Object)issue);
        Assertions.notNull((String)"Feedback shouldn't be null", (Object)feedbackParameters);
        Assertions.notNull((String)"Feedback token shouldn't be null", (Object)feedbackToken);
        return Steps.begin(this.requestFeedbackValidator.validateFeedbackToken(issue, feedbackToken)).then(token -> this.requestFeedbackValidator.validateFeedback(feedbackParameters)).then((token, feedback) -> this.requestFeedbackInternalManager.storeFeedback(issue, (ValidatedFeedback)feedback)).yield((token, feedback, updatedFeedback) -> updatedFeedback);
    }

    public Option<Feedback> getFeedback(@Nonnull Issue issue) {
        Assertions.notNull((String)"Issue shouldn't be null", (Object)issue);
        return this.requestFeedbackInternalManager.getFeedback(issue);
    }
}

