/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.healer;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannel;
import com.atlassian.servicedesk.internal.feature.emailchannel.healer.EmailChannelVerificationManager;
import com.atlassian.servicedesk.squalor.email.SDMailServerConnectionTestSuccess;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailChannelVerificationService {
    private final EmailChannelVerificationManager emailChannelVerificationManager;
    private final ServiceDeskLicenseAndPermissionService permissionService;
    private final CommonErrors commonErrors;

    @Autowired
    public EmailChannelVerificationService(EmailChannelVerificationManager emailChannelVerificationManager, ServiceDeskLicenseAndPermissionService permissionService, CommonErrors commonErrors) {
        this.emailChannelVerificationManager = emailChannelVerificationManager;
        this.permissionService = permissionService;
        this.commonErrors = commonErrors;
    }

    public Either<List<AnError>, SDMailServerConnectionTestSuccess> testEmailChannel(CheckedUser user, Project project, EmailChannel emailChannel) {
        if (!this.permissionService.canAdministerJIRA((SDUser)user)) {
            return Either.left(Collections.singletonList(this.commonErrors.ADMINISTER_PERMISSIONS_ERROR()));
        }
        return this.emailChannelVerificationManager.testEmailChannel(project, emailChannel);
    }
}

