/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.healer;

import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.mail.processor.api.channel.ChannelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValidator;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannel;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.ValidPlatformEmailChannel;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailChannelSettingValidator {
    private final ChannelManager channelManager;
    private final CommonErrors commonErrors;
    private final EmailChannelHelper emailChannelHelper;
    private final RequestTypeFieldValidator requestTypeFieldValidator;
    private final RequestTypeFieldManager requestTypeFieldManager;
    private final ServiceDeskIssueTypeManager serviceDeskIssueTypeManager;

    @Autowired
    public EmailChannelSettingValidator(ChannelManager channelManager, CommonErrors commonErrors, EmailChannelHelper emailChannelHelper, RequestTypeFieldValidator requestTypeFieldValidator, RequestTypeFieldManager requestTypeFieldManager, ServiceDeskIssueTypeManager serviceDeskIssueTypeManager) {
        this.channelManager = channelManager;
        this.commonErrors = commonErrors;
        this.emailChannelHelper = emailChannelHelper;
        this.requestTypeFieldValidator = requestTypeFieldValidator;
        this.requestTypeFieldManager = requestTypeFieldManager;
        this.serviceDeskIssueTypeManager = serviceDeskIssueTypeManager;
    }

    public Either<List<AnError>, ValidPlatformEmailChannel> verifyEmailChannel(Project project, EmailChannel emailChannel) {
        Either validEmailChannelEither = Steps.begin((Either)emailChannel.getChannelDefinition().toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_INVALID())).then(() -> emailChannel.getEmailChannelSetting().toRight(() -> ((CommonErrors)this.commonErrors).EMAIL_CHANNEL_INVALID())).then(() -> this.toValidChannel(emailChannel)).yield((channelDefinition, emailChannelSetting, validPlatformEmailChannel) -> validPlatformEmailChannel);
        if (validEmailChannelEither.isLeft()) {
            return validEmailChannelEither.leftMap(Collections::singletonList);
        }
        ValidPlatformEmailChannel validEmailChannel = (ValidPlatformEmailChannel)validEmailChannelEither.right().get();
        List<Option<AnError>> validationResults = this.validateEmailChannelSettings(project, validEmailChannel.setting());
        List result = validationResults.stream().filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
        return Eithers.cond((boolean)result.isEmpty(), result, (Object)validEmailChannel);
    }

    private Either<AnError, ValidPlatformEmailChannel> toValidChannel(EmailChannel emailChannel) {
        if (emailChannel instanceof ValidPlatformEmailChannel) {
            return Either.right((Object)((ValidPlatformEmailChannel)emailChannel));
        }
        return Either.left((Object)this.commonErrors.EMAIL_CHANNEL_INVALID());
    }

    private List<Option<AnError>> validateEmailChannelSettings(Project project, EmailChannelSetting emailChannelSetting) {
        Either<AnError, RequestType> errorRequestTypeEither = this.emailChannelHelper.requestTypeOf(emailChannelSetting, project);
        Option requestType = errorRequestTypeEither.toOption();
        return Arrays.asList(errorRequestTypeEither.left().toOption(), this.validateEmailChannelEnabled(emailChannelSetting), this.validateRequestType((Option<RequestType>)requestType), this.validateIssueType((Option<RequestType>)requestType, project));
    }

    private Option<AnError> validateEmailChannelEnabled(EmailChannelSetting emailChannelSetting) {
        return (Option)this.channelManager.getMailChannelByKey(ChannelKey.from((String)emailChannelSetting.getMailChannelKey())).filter(ChannelDefinition::isEnabled).fold(() -> Option.some((Object)this.commonErrors.EMAIL_CHANNEL_DISABLED()), some -> Option.none());
    }

    private Option<AnError> validateRequestType(Option<RequestType> requestTypeOption) {
        return requestTypeOption.flatMap(requestType -> this.requestTypeFieldValidator.isRequestTypeValidForEmailChannel((RequestType)requestType, this.requestTypeFieldManager.getFieldsJava((RequestType)requestType)).left().toOption());
    }

    private Option<AnError> validateIssueType(Option<RequestType> requestTypeOption, Project project) {
        return requestTypeOption.flatMap(requestType -> this.serviceDeskIssueTypeManager.getIssueTypeForProject(requestType.getIssueTypeId(), project).left().toOption().map(error -> this.commonErrors.REQUEST_TYPE_INVALID_ISSUE_TYPE()));
    }
}

