/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.handler;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.processor.api.handler.MailHandlerContext;
import com.atlassian.jira.mail.processor.api.handler.result.HandlerResult;
import com.atlassian.jira.mail.processor.spi.handler.MailHandler;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.feature.emailchannel.IncomingEmailService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.mail.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDMailHandler
implements MailHandler {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IncomingEmailService incomingEmailService;
    private final ErrorTranslationHelper errorTranslationHelper;

    @Autowired
    public SDMailHandler(JiraAuthenticationContext jiraAuthenticationContext, IncomingEmailService incomingEmailService, ErrorTranslationHelper errorTranslationHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.incomingEmailService = incomingEmailService;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    @Nonnull
    public HandlerResult handleNewMessage(MailHandlerContext mailHandlerContext, Message message) {
        return this.processMessage(mailHandlerContext, (Option<Issue>)Option.none(), message);
    }

    @Nonnull
    public HandlerResult handleReplyMessage(MailHandlerContext mailHandlerContext, Issue issue, Message message) {
        return this.processMessage(mailHandlerContext, (Option<Issue>)Option.some((Object)issue), message);
    }

    private HandlerResult processMessage(MailHandlerContext context, Option<Issue> currentIssue, Message message) {
        String mailChannelKey = context.getChannelKey().getKey();
        Either<AnError, Either<ValidationErrors, Issue>> processEmailResult = this.incomingEmailService.processEmailWithMailChannel(message, mailChannelKey, currentIssue);
        return (HandlerResult)processEmailResult.fold(this::failHandlingMail, issueEither -> (HandlerResult)issueEither.fold(this::failMailValidation, HandlerResult::ok));
    }

    private HandlerResult failHandlingMail(AnError error) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        String failureMessage = this.errorTranslationHelper.translateAnError(error, i18nHelper);
        return HandlerResult.fail((String)failureMessage);
    }

    private HandlerResult failMailValidation(ValidationErrors errors) {
        Optional<String> firstErrorMessage = errors.getErrorMessages().stream().findFirst().map(arg_0 -> ((ErrorTranslationHelper)this.errorTranslationHelper).translateErrorMessage(arg_0));
        Optional<String> firstFieldError = errors.getFieldErrors().entrySet().stream().findFirst().map(err -> String.format("%s : %s", err.getKey(), this.errorTranslationHelper.translateErrorMessage((ErrorMessage)err.getValue())));
        if (firstErrorMessage.isPresent()) {
            return HandlerResult.fail((String)firstErrorMessage.get());
        }
        if (firstFieldError.isPresent()) {
            return HandlerResult.fail((String)firstFieldError.get());
        }
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        return HandlerResult.fail((String)i18nHelper.getText("sd.user.error.unknown.email.handler.validate"));
    }
}

