/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.mail.MailUtils;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.customer.NoExceptionsCallable;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsService;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherActiveState;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherUsernames;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.comment.JiraCommentAndAttachments;
import com.atlassian.servicedesk.internal.comment.SDComment;
import com.atlassian.servicedesk.internal.comment.SDCommentAndAttachments;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.InviteService;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.SignupManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelHelper;
import com.atlassian.servicedesk.internal.feature.emailchannel.IncomingEmailManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.IncomingEmailService;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSetting;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.context.ServiceDeskOutsideCustomerPermissionContext;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncomingEmailServiceImpl
implements IncomingEmailService {
    private static final Logger logger = LoggerFactory.getLogger(IncomingEmailServiceImpl.class);
    private final EmailRequestsSettingsService emailRequestsSettingsService;
    private final EmailChannelSettingManager emailChannelSettingManager;
    private final UserFactory userFactory;
    private final SignupManager signUpManager;
    private final IncomingEmailManager incomingEmailManager;
    private final InviteService inviteService;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final EyeballService eyeballService;
    private final CustomerContextService customerContextService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final EmailChannelHelper emailChannelHelper;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final CommonErrors commonErrors;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final RequestTypeInternalService requestTypeService;
    private final ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext;
    private final OutsiderPermissionChecker outsiderPermissionChecker;

    @Autowired
    public IncomingEmailServiceImpl(EmailRequestsSettingsService emailRequestsSettingsService, EmailChannelSettingManager emailChannelSettingManager, UserFactory userFactory, SignupManager signUpManager, IncomingEmailManager incomingEmailManager, InviteService inviteService, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, EyeballService eyeballService, CustomerContextService customerContextService, ServiceDeskPermissions serviceDeskPermissions, EmailChannelHelper emailChannelHelper, AuthenticationContextUtil authenticationContextUtil, CommonErrors commonErrors, ErrorResultHelper errorResultHelper, ServiceDeskInternalManager serviceDeskInternalManager, RequestTypeInternalService requestTypeService, ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext, OutsiderPermissionChecker outsiderPermissionChecker) {
        this.emailRequestsSettingsService = emailRequestsSettingsService;
        this.emailChannelSettingManager = emailChannelSettingManager;
        this.userFactory = userFactory;
        this.signUpManager = signUpManager;
        this.incomingEmailManager = incomingEmailManager;
        this.inviteService = inviteService;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.eyeballService = eyeballService;
        this.customerContextService = customerContextService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.emailChannelHelper = emailChannelHelper;
        this.authenticationContextUtil = authenticationContextUtil;
        this.commonErrors = commonErrors;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.requestTypeService = requestTypeService;
        this.serviceDeskOutsideCustomerPermissionContext = serviceDeskOutsideCustomerPermissionContext;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> processEmailWithMailChannel(Message message, String mailChannelKey, io.atlassian.fugue.Option<Issue> issueOpt) {
        return Steps.begin((io.atlassian.fugue.Either)this.emailChannelSettingManager.getEmailChannelSettingsByChannelKey(mailChannelKey).leftMap(err -> this.commonErrors.EMAIL_CHANNEL_NOT_FOUND())).then(emailChannelSetting -> this.createNewOrCommentOnIssueWithMailChannel((EmailChannelSetting)emailChannelSetting, message, issueOpt)).then((emailChannelSetting, issue) -> this.emailChannelSettingManager.recordLastProcessedTime((EmailChannelSetting)emailChannelSetting, System.currentTimeMillis()).leftMap(err -> this.commonErrors.EMAIL_CHANNEL_NOT_FOUND())).yield((emailChannelSetting, issue, ignore) -> issue);
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> createNewOrCommentOnIssueWithMailChannel(EmailChannelSetting emailChannelSetting, Message message, io.atlassian.fugue.Option<Issue> issueOpt) {
        return Steps.begin(this.getMailHandlerProjectAndIssueContext(emailChannelSetting, issueOpt)).then(projectContext -> this.getOrCreateUserFromEmailAddress(message, (MailHandlerProjectAndIssueContext)projectContext)).then((projectContext, userEither) -> this.doCreateNewOrCommentOnIssueWithMailChannel(message, (MailHandlerProjectAndIssueContext)projectContext, (io.atlassian.fugue.Either<ValidationErrors, CheckedUser>)userEither)).yield((serviceDesk, userEither, issue) -> issue);
    }

    private io.atlassian.fugue.Either<AnError, MailHandlerProjectAndIssueContext> getMailHandlerProjectAndIssueContext(EmailChannelSetting emailChannelSetting, io.atlassian.fugue.Option<Issue> issueOption) {
        return Steps.begin((io.atlassian.fugue.Either)this.emailChannelHelper.serviceDeskOf(emailChannelSetting).leftMap(err -> this.commonErrors.SERVICEDESK_NOT_FOUND())).then(serviceDesk -> this.emailChannelHelper.projectOf(emailChannelSetting)).then(() -> this.getIssueContextOption(issueOption)).yield((serviceDesk, project, issueContextOption) -> new MailHandlerProjectAndIssueContext((ServiceDesk)serviceDesk, (Project)project, emailChannelSetting.getEmailAddress(), emailChannelSetting.getRequestTypeId(), (io.atlassian.fugue.Option<IssueContext>)issueContextOption));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Option<IssueContext>> getIssueContextOption(io.atlassian.fugue.Option<Issue> issueOption) {
        return io.atlassian.fugue.Either.right((Object)issueOption.map(issue -> {
            Project project = issue.getProjectObject();
            io.atlassian.fugue.Option serviceDeskOption = this.serviceDeskInternalManager.getServiceDesk(project, false).toOption();
            return new IssueContext((Issue)issue, project, (io.atlassian.fugue.Option<ServiceDesk>)serviceDeskOption);
        }));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> doCreateNewOrCommentOnIssueWithMailChannel(Message message, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext, io.atlassian.fugue.Either<ValidationErrors, CheckedUser> userEither) {
        return (io.atlassian.fugue.Either)userEither.fold(errors -> io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Either.left((Object)errors)), checkedUser -> this.inEmailContext((CheckedUser)checkedUser, () -> this.createNewOrCommentOnIssueWithMailChannelAsEmailSender((CheckedUser)checkedUser, message, mailHandlerProjectAndIssueContext)));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> createNewOrCommentOnIssueWithMailChannelAsEmailSender(CheckedUser emailSender, Message message, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext) {
        io.atlassian.fugue.Option<IssueContext> issueContextOpt = mailHandlerProjectAndIssueContext.getIssueContextOption();
        NoExceptionsCallable callable = () -> (io.atlassian.fugue.Either)issueContextOpt.filter(issueContext -> this.canCommentOnExistingIssue(emailSender, issueContext.getIssue())).fold(() -> this.createNewIssueWithMailChannel(emailSender, message, mailHandlerProjectAndIssueContext.getProject(), mailHandlerProjectAndIssueContext.getServiceDesk(), mailHandlerProjectAndIssueContext.getRequestTypeId(), mailHandlerProjectAndIssueContext.getEmailReceivedChannelAddress()).map(io.atlassian.fugue.Either::right), issueContext -> this.addCommentToIssue(emailSender, message, issueContext.getProject(), issueContext.getIssue(), issueContext.getServiceDeskOption()).map(this.toIssueWithDefault(issueContext.getIssue())));
        return (io.atlassian.fugue.Either)issueContextOpt.map(IssueContext::getIssue).filter(issue -> this.emailRequestsSettingsService.getOutsiderCommentsEnabled() && this.outsiderPermissionChecker.isUserAnOutsider(emailSender, issue)).fold(() -> ((NoExceptionsCallable)callable).call(), issue -> (io.atlassian.fugue.Either)this.serviceDeskOutsideCustomerPermissionContext.inOutsideCustomerContext(emailSender, (Issue)issue, callable));
    }

    private boolean canCommentOnExistingIssue(CheckedUser emailSender, Issue issue) {
        return this.serviceDeskPermissions.canCreateComment((SDUser)emailSender, issue);
    }

    private Function<io.atlassian.fugue.Either<ValidationErrors, io.atlassian.fugue.Option<Comment>>, io.atlassian.fugue.Either<ValidationErrors, Issue>> toIssueWithDefault(Issue issue) {
        return validationErrorsOrCommentOption -> validationErrorsOrCommentOption.map(commentOpt -> (Issue)commentOpt.fold(() -> issue, Comment::getIssue));
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, Issue> createNewIssueWithMailChannel(CheckedUser emailSender, Message message, Project project, ServiceDesk serviceDesk, int requestTypeId, String emailReceivedChannelAddress) {
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)emailSender, project)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.SERVICE_DESK_PERMISSION_VIOLATION());
        }
        return this.requestTypeService.getRequestTypeById(emailSender, Integer.valueOf(requestTypeId), project).flatMap(requestType -> this.createNewIssueWithRequestType(emailSender, message, project, serviceDesk, (RequestType)requestType, emailReceivedChannelAddress));
    }

    private io.atlassian.fugue.Either<AnError, Issue> createNewIssueWithRequestType(CheckedUser emailSender, Message message, Project project, ServiceDesk serviceDesk, RequestType requestType, String emailChannelAddress) {
        io.atlassian.fugue.Either<AnError, Issue> issueEither = this.incomingEmailManager.createIssueFromEmail(emailSender, message, serviceDesk, project, requestType, emailChannelAddress);
        if (issueEither.isRight()) {
            this.registerEyeballEventForEmailSender();
        }
        issueEither.forEach(issue -> this.incomingEmailManager.processAdditionalRequestParticipantSignupsForIssue(emailSender, message, serviceDesk, project, (Issue)issue));
        return issueEither;
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, io.atlassian.fugue.Option<Comment>>> addCommentToIssue(CheckedUser emailSender, Message message, Project project, Issue issue, io.atlassian.fugue.Option<ServiceDesk> serviceDeskOpt) {
        if (!this.serviceDeskPermissions.canViewServiceDesk((SDUser)emailSender, project)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.SERVICE_DESK_PERMISSION_VIOLATION());
        }
        return (io.atlassian.fugue.Either)serviceDeskOpt.fold(() -> this.addJiraCommentToIssue(emailSender, message, issue).map(this::toOptionalCommentJira), serviceDesk -> this.addServiceDeskCommentToIssue(emailSender, message, (ServiceDesk)serviceDesk, project, issue).map(this::toOptionalCommentServiceDesk));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, JiraCommentAndAttachments>> addJiraCommentToIssue(CheckedUser emailSender, Message message, Issue issue) {
        return this.incomingEmailManager.addJiraCommentFromEmail(emailSender, message, issue);
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, SDCommentAndAttachments>> addServiceDeskCommentToIssue(CheckedUser emailSender, Message message, ServiceDesk serviceDesk, Project project, Issue issue) {
        io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, SDCommentAndAttachments>> sdCommentEither = this.incomingEmailManager.addServiceDeskCommentFromEmail(emailSender, message, issue);
        if (sdCommentEither.isRight() && ((io.atlassian.fugue.Either)sdCommentEither.right().get()).isRight()) {
            this.registerEyeballEventForEmailSender();
        }
        sdCommentEither.forEach(validationErrorsOrSDCommentAndAttachments -> validationErrorsOrSDCommentAndAttachments.forEach(sdCommentAndAttachments -> this.incomingEmailManager.processAdditionalRequestParticipantSignupsForIssue(emailSender, message, serviceDesk, project, issue)));
        return sdCommentEither;
    }

    private io.atlassian.fugue.Either<ValidationErrors, io.atlassian.fugue.Option<Comment>> toOptionalCommentJira(io.atlassian.fugue.Either<ValidationErrors, JiraCommentAndAttachments> validationErrorsOrJiraCommentAndAttachments) {
        return validationErrorsOrJiraCommentAndAttachments.map(JiraCommentAndAttachments::getComment).map(io.atlassian.fugue.Option::option);
    }

    private io.atlassian.fugue.Either<ValidationErrors, io.atlassian.fugue.Option<Comment>> toOptionalCommentServiceDesk(io.atlassian.fugue.Either<ValidationErrors, SDCommentAndAttachments> validationErrorsOrSDCommentAndAttachments) {
        return validationErrorsOrSDCommentAndAttachments.map(SDCommentAndAttachments::getSdCommentOption).map(sdCommentsOpt -> sdCommentsOpt.map(SDComment::getComment));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> getOrCreateUserFromEmailAddress(Message message, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext) {
        return (io.atlassian.fugue.Either)this.getUserFromMessageHeader(message).fold(() -> this.getCustomerEmailFromMessage(message).flatMap(emailAddress -> this.createUserFromEmailAddress((String)emailAddress, mailHandlerProjectAndIssueContext)), user -> io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Either.right((Object)user)));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> createUserFromEmailAddress(String emailAddress, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext) {
        UserSearchParams emailParams = this.userSearchManagerHelper.buildEmailValidatorUserSearchParams(emailAddress, UserEmailMatcherActiveState.INCLUDE_INACTIVE_USERS, UserEmailMatcherUsernames.MATCH_USERNAMES);
        List<CheckedUser> userSearchResults = this.userSearchManager.searchUnlimited(emailAddress, emailParams).map(arg_0 -> ((UserFactory)this.userFactory).wrap(arg_0)).filter(Either::isRight).map(either -> (CheckedUser)either.right().get()).collect(Collectors.toList());
        if (userSearchResults.isEmpty()) {
            return this.createReporter(emailAddress, mailHandlerProjectAndIssueContext);
        }
        io.atlassian.fugue.Option<CheckedUser> firstActiveUserOption = this.findFirstActiveUser(userSearchResults, emailAddress);
        return (io.atlassian.fugue.Either)firstActiveUserOption.fold(() -> this.handleNoActiveUserFound(emailAddress, mailHandlerProjectAndIssueContext, userSearchResults), user -> io.atlassian.fugue.Either.right((Object)io.atlassian.fugue.Either.right((Object)user)));
    }

    @VisibleForTesting
    io.atlassian.fugue.Option<CheckedUser> findFirstActiveUser(Collection<CheckedUser> userSearchResults, String emailAddress) {
        return io.atlassian.fugue.Option.fromOptional(userSearchResults.stream().filter(checkedUser -> checkedUser.forJIRA().isActive()).sorted((o1, o2) -> {
            if (Objects.equals(o1.getEmailAddress(), o2.getEmailAddress())) {
                return 0;
            }
            if (Objects.equals(o1.getEmailAddress(), emailAddress)) {
                return -1;
            }
            return 1;
        }).findFirst());
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> handleNoActiveUserFound(String emailAddress, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext, List<CheckedUser> allInactiveUsers) {
        io.atlassian.fugue.Option first = Iterables.findFirst(allInactiveUsers, user -> StringUtils.equalsIgnoreCase((String)user.getName(), (String)emailAddress));
        if (first.isEmpty()) {
            return this.createReporter(emailAddress, mailHandlerProjectAndIssueContext);
        }
        return io.atlassian.fugue.Either.left((Object)this.USER_IS_INACTIVE_ERROR());
    }

    private io.atlassian.fugue.Either<AnError, String> getCustomerEmailFromMessage(Message message) {
        try {
            List fromAddresses = MailUtils.getSenders((Message)message);
            io.atlassian.fugue.Option headOption = fromAddresses.size() > 0 ? io.atlassian.fugue.Option.some(fromAddresses.get(0)) : io.atlassian.fugue.Option.none();
            return headOption.toRight(this::SENDER_RETRIEVAL_ERROR);
        }
        catch (MessagingException ex) {
            logger.debug("Could not retrieve the sender address from email.", (Throwable)ex);
            return io.atlassian.fugue.Either.left((Object)this.SENDER_RETRIEVAL_ERROR());
        }
    }

    private io.atlassian.fugue.Option<CheckedUser> getUserFromMessageHeader(Message message) {
        try {
            String[] userKeys = message.getHeader("X-JSD-userkey");
            io.atlassian.fugue.Option headOption = userKeys.length > 0 ? io.atlassian.fugue.Option.some((Object)userKeys[0]) : io.atlassian.fugue.Option.none();
            return headOption.flatMap(uk -> StepsConverters.newerOption((Option)this.userFactory.wrapUserKey(uk).toOption()));
        }
        catch (Exception e) {
            return io.atlassian.fugue.Option.none();
        }
    }

    private void registerEyeballEventForEmailSender() {
        this.eyeballService.tagSDEvent();
        this.eyeballService.triggerEvent();
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> createReporter(String emailAddress, MailHandlerProjectAndIssueContext mailHandlerProjectAndIssueContext) {
        io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> newReporterResult = this.signUpManager.signUpCustomerThroughSupportEmail(mailHandlerProjectAndIssueContext.getServiceDesk(), mailHandlerProjectAndIssueContext.getProject(), emailAddress);
        newReporterResult.foreach(reporterEither -> reporterEither.foreach(reporter -> this.inEmailContext((CheckedUser)reporter, () -> {
            this.inviteService.sendInviteCustomerCreatedViaEmailChannelIfUserNeverLoggedIn((CheckedUser)reporter, mailHandlerProjectAndIssueContext.getProject());
            return Unit.Unit();
        })));
        return newReporterResult;
    }

    private <T> T inEmailContext(CheckedUser user, Supplier<T> callback) {
        Callable<Object> inCustomerContextCall = () -> this.inCustomerContext(callback);
        return (T)this.authenticationContextUtil.runAs(user.forJIRA(), inCustomerContextCall);
    }

    private <T> T inCustomerContext(Supplier<T> callback) {
        NoExceptionsCallable wrappedCallback = callback::get;
        return (T)this.customerContextService.runInCustomerContext(wrappedCallback);
    }

    private AnError SENDER_RETRIEVAL_ERROR() {
        return this.errorResultHelper.notFound404("sd.email.handler.sender.retrieval.error", new Object[0]).build();
    }

    private AnError USER_IS_INACTIVE_ERROR() {
        return this.errorResultHelper.unauthorized401("sd.email.error.current.user.is.inactive", new Object[0]).build();
    }

    private static class IssueContext {
        private final Issue issue;
        private final Project project;
        private final io.atlassian.fugue.Option<ServiceDesk> serviceDeskOption;

        public IssueContext(Issue issue, Project project, io.atlassian.fugue.Option<ServiceDesk> serviceDeskOption) {
            this.issue = issue;
            this.serviceDeskOption = serviceDeskOption;
            this.project = project;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public Project getProject() {
            return this.project;
        }

        public io.atlassian.fugue.Option<ServiceDesk> getServiceDeskOption() {
            return this.serviceDeskOption;
        }
    }

    private static class MailHandlerProjectAndIssueContext {
        private final ServiceDesk serviceDesk;
        private final Project project;
        private final String emailReceivedChannelAddress;
        private final int requestTypeId;
        private final io.atlassian.fugue.Option<IssueContext> issueContextOption;

        public MailHandlerProjectAndIssueContext(ServiceDesk serviceDesk, Project project, String emailReceivedChannelAddress, int requestTypeId, io.atlassian.fugue.Option<IssueContext> issueContextOption) {
            this.serviceDesk = serviceDesk;
            this.project = project;
            this.emailReceivedChannelAddress = emailReceivedChannelAddress;
            this.requestTypeId = requestTypeId;
            this.issueContextOption = issueContextOption;
        }

        public ServiceDesk getServiceDesk() {
            return this.serviceDesk;
        }

        public Project getProject() {
            return this.project;
        }

        public String getEmailReceivedChannelAddress() {
            return this.emailReceivedChannelAddress;
        }

        public int getRequestTypeId() {
            return this.requestTypeId;
        }

        public io.atlassian.fugue.Option<IssueContext> getIssueContextOption() {
            return this.issueContextOption;
        }
    }
}

