/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.mail.MailUtils;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.admin.EmailCreateCustomerMode;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsService;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.channel.IssueChannelService;
import com.atlassian.servicedesk.internal.comment.InternalServiceDeskCommentService;
import com.atlassian.servicedesk.internal.comment.JiraCommentAndAttachments;
import com.atlassian.servicedesk.internal.comment.SDCommentAndAttachments;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.feature.customer.request.InternalCustomerRequestServiceScala;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeFieldValidator;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeWithFields;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.RequestTypeFieldInternalService;
import com.atlassian.servicedesk.internal.feature.emailchannel.IncomingEmailManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.IncomingEmailParser;
import com.atlassian.servicedesk.internal.feature.emailchannel.analyticsevents.NonServiceDeskEmailRequestCommentedEvent;
import com.atlassian.servicedesk.internal.feature.emailchannel.analyticsevents.OutsiderCommentedEvent;
import com.atlassian.servicedesk.internal.feature.emailchannel.analyticsevents.RequestCreatedSharedWithOrganizationViaEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.feature.emailchannel.analyticsevents.ServiceDeskEmailRequestCommentedEvent;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailChannelSettingManager;
import com.atlassian.servicedesk.internal.feature.jira.issuetype.ServiceDeskIssueTypeManager;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.invite.RequestParticipantsInvitationService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.InternalCommentNotificationsUtils;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Suppliers;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.Message;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncomingEmailManagerImpl
implements IncomingEmailManager {
    private static Logger log = LoggerFactory.getLogger(IncomingEmailManagerImpl.class);
    private final CommonErrors commonErrors;
    private final PortalService portalService;
    private final RequestTypeFieldInternalService requestTypeFieldInternalService;
    private final ServiceDeskIssueTypeManager serviceDeskIssueTypeManager;
    private final IncomingEmailParser incomingEmailParser;
    private final InternalCustomerRequestServiceScala customerRequestService;
    private final RequestTypeFieldValidator requestTypeFieldValidator;
    private final IssueChannelService issueChannelService;
    private final InternalServiceDeskCommentService internalServiceDeskCommentService;
    private final I18nHelper i18nHelper;
    private final AnalyticsService analyticsService;
    private final InternalCommentNotificationsUtils internalCommentNotificationsUtils;
    private final FeatureManager featureManager;
    private final UserFactory userFactory;
    private final OutsiderPermissionChecker outsiderPermissionChecker;
    private final RequestParticipantsInvitationService requestParticipantsInvitationService;
    private final RequestParticipantValidator requestParticipantValidator;
    private final RequestParticipantsInternalService requestParticipantsInternalService;
    private final ErrorTranslationHelper errorTranslationHelper;
    private final CustomerOrganizationsCFManager organisationsCFManager;
    private final CustomerOrganizationMemberManager organisationMemberManager;
    private final EmailChannelSettingManager emailChannelSettingManager;
    private final EmailRequestsSettingsService emailRequestsSettingsService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final InternalServiceDeskAccessService internalServiceDeskAccessService;

    @Autowired
    public IncomingEmailManagerImpl(CommonErrors commonErrors, PortalService portalService, RequestTypeFieldInternalService requestTypeFieldInternalService, ServiceDeskIssueTypeManager serviceDeskIssueTypeManager, IncomingEmailParser incomingEmailParser, InternalCustomerRequestServiceScala customerRequestService, RequestTypeFieldValidator requestTypeFieldValidator, IssueChannelService issueChannelService, InternalServiceDeskCommentService internalServiceDeskCommentService, I18nHelper i18nHelper, AnalyticsService analyticsService, InternalCommentNotificationsUtils internalCommentNotificationsUtils, FeatureManager featureManager, UserFactory userFactory, OutsiderPermissionChecker outsiderPermissionChecker, RequestParticipantsInvitationService requestParticipantsInvitationService, RequestParticipantValidator requestParticipantValidator, RequestParticipantsInternalService requestParticipantsInternalService, ErrorTranslationHelper errorTranslationHelper, CustomerOrganizationsCFManager organisationsCFManager, CustomerOrganizationMemberManager organisationMemberManager, EmailChannelSettingManager emailChannelSettingManager, EmailRequestsSettingsService emailRequestsSettingsService, ServiceDeskPermissionService serviceDeskPermissionService, InternalServiceDeskAccessService internalServiceDeskAccessService) {
        this.commonErrors = commonErrors;
        this.portalService = portalService;
        this.requestTypeFieldInternalService = requestTypeFieldInternalService;
        this.serviceDeskIssueTypeManager = serviceDeskIssueTypeManager;
        this.incomingEmailParser = incomingEmailParser;
        this.customerRequestService = customerRequestService;
        this.requestTypeFieldValidator = requestTypeFieldValidator;
        this.issueChannelService = issueChannelService;
        this.internalServiceDeskCommentService = internalServiceDeskCommentService;
        this.i18nHelper = i18nHelper;
        this.analyticsService = analyticsService;
        this.internalCommentNotificationsUtils = internalCommentNotificationsUtils;
        this.featureManager = featureManager;
        this.userFactory = userFactory;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
        this.requestParticipantsInvitationService = requestParticipantsInvitationService;
        this.requestParticipantValidator = requestParticipantValidator;
        this.requestParticipantsInternalService = requestParticipantsInternalService;
        this.errorTranslationHelper = errorTranslationHelper;
        this.organisationsCFManager = organisationsCFManager;
        this.organisationMemberManager = organisationMemberManager;
        this.emailChannelSettingManager = emailChannelSettingManager;
        this.emailRequestsSettingsService = emailRequestsSettingsService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.internalServiceDeskAccessService = internalServiceDeskAccessService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Issue> createIssueFromEmail(CheckedUser reporter, Message message, ServiceDesk serviceDesk, Project project, RequestType requestType, String emailChannelAddress) {
        return this.createIssueInJiraContext(reporter, project, serviceDesk, requestType, message, emailChannelAddress);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, SDCommentAndAttachments>> addServiceDeskCommentFromEmail(CheckedUser user, Message message, Issue issue) {
        io.atlassian.fugue.Either result = Steps.begin(this.incomingEmailParser.parse(message, true)).then(this::validateMessageForCommenting).then((parsedEmail, jsdSuccess) -> this.internalServiceDeskCommentService.addCommentAndAttachmentsFromEmailToExistingIssue(parsedEmail.getBody(), parsedEmail.getAttachments(), issue, user, this.createEmailCommentProperty(message))).yield((parsedEmail, jsdSuccess, validationErrorsOrCommentCreationResult) -> validationErrorsOrCommentCreationResult);
        result.left().forEach(this::logInSiteLocale);
        result.right().forEach(validationErrorsOrCommentCreationResult -> {
            validationErrorsOrCommentCreationResult.left().forEach(this::logInSiteLocale);
            if (validationErrorsOrCommentCreationResult.isRight()) {
                this.trackCommentViaEmailSuccess(issue);
                if (this.outsiderPermissionChecker.isUserAnOutsider(user, issue)) {
                    this.trackOutsiderCommentViaEmailSuccess(issue);
                }
            }
        });
        return result;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, JiraCommentAndAttachments>> addJiraCommentFromEmail(CheckedUser user, Message message, Issue issue) {
        io.atlassian.fugue.Either result = Steps.begin(this.incomingEmailParser.parse(message, true)).then(this::validateMessageForCommenting).then((parsedEmail, jsdSuccess) -> this.internalServiceDeskCommentService.addCommentAndAttachmentsFromEmailToExistingNonServiceDeskIssue(parsedEmail.getBody(), parsedEmail.getAttachments(), issue, user)).yield((parsedEmail, jsdSuccess, validationErrorsOrCommentCreationResult) -> validationErrorsOrCommentCreationResult);
        result.left().forEach(this::logInSiteLocale);
        result.right().forEach(validationErrorsOrCommentCreationResult -> {
            validationErrorsOrCommentCreationResult.left().forEach(this::logInSiteLocale);
            if (validationErrorsOrCommentCreationResult.isRight()) {
                this.trackNonServiceDeskCommentViaEmailSuccess(issue);
            }
        });
        return result;
    }

    @Override
    public void processAdditionalRequestParticipantSignupsForIssue(CheckedUser user, Message message, ServiceDesk serviceDesk, Project project, Issue issue) {
        List<String> allEmailChannelAddresses = this.emailChannelSettingManager.getEmailChannelSettings().stream().flatMap(emailChannelSetting -> StreamSupport.stream(Option.option((Object)emailChannelSetting.getEmailAddress()).spliterator(), false)).collect(Collectors.toList());
        List<String> allEmails = this.getAllEmailAddressesFromMessage(message, allEmailChannelAddresses);
        log.debug("Found the following email addresses in email issue {} : {}", (Object)issue.getKey(), (Object)StringUtils.join(allEmails, (String)", "));
        Pair<List<CheckedUser>, List<CheckedUser>> existingParticipantsPair = this.addParticipantsWithExistingAccounts(user, allEmails, issue);
        List allParticipants = (List)existingParticipantsPair.left();
        List validParticipants = (List)existingParticipantsPair.right();
        log.trace("Found all the following existing participants in email issue {} : {}", (Object)issue.getKey(), (Object)validParticipants.stream().map(CheckedUser::getEmailAddress).collect(Collectors.joining()));
        if (this.canCreateNewCustomerViaEmailCC(user, serviceDesk)) {
            Option reporter = StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.wrap(issue.getReporterUser()).toOption());
            Option<List<CheckedUser>> validParticipantsOnIssueAfterAnyInvites = this.inviteNewUsersAndAddAsParticipants(allEmails, (Option<CheckedUser>)reporter, allParticipants, user, serviceDesk, project, issue);
            List allParticipantsOnIssue = (List)validParticipantsOnIssueAfterAnyInvites.map(users -> ImmutableSet.builder().addAll((Iterable)users).addAll((Iterable)allParticipants).build().asList()).getOrElse((Object)allParticipants);
            this.logFailedParticipantEmails(allParticipantsOnIssue, allEmails);
        } else {
            log.debug("Inviting new user via email to/cc disabled : {}", (Object)issue.getKey());
            this.logFailedParticipantEmails(allParticipants, allEmails);
        }
    }

    @VisibleForTesting
    boolean canCreateNewCustomerViaEmailCC(CheckedUser user, ServiceDesk serviceDesk) {
        EmailCreateCustomerMode emailCreateCustomerMode = this.emailRequestsSettingsService.getEmailCreateCustomerMode();
        boolean allowCreateCustomersViaEmail = emailCreateCustomerMode.isCanAgentCreateAlways() && (Boolean)StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user.forJIRA(), serviceDesk)).getOr(Suppliers.alwaysFalse()) != false ? true : emailCreateCustomerMode.isCanAnyoneCreateWithPublicSignup() && this.internalServiceDeskAccessService.isPublicSignupEnabled(serviceDesk);
        return allowCreateCustomersViaEmail;
    }

    private void logFailedParticipantEmails(List<CheckedUser> newParticipants, List<String> allEmails) {
        Set newParticipantEmails = newParticipants.stream().map(user -> StringUtils.lowerCase((String)user.getEmailAddress())).collect(Collectors.toSet());
        String emailsNotAdded = allEmails.stream().filter(email -> !newParticipantEmails.contains(StringUtils.lowerCase((String)email))).collect(Collectors.joining());
        if (StringUtils.isNotBlank((String)emailsNotAdded)) {
            log.debug("Could not add the following email addresses in the CC field as request participants: {}", (Object)emailsNotAdded);
        }
    }

    private Option<List<CheckedUser>> inviteNewUsersAndAddAsParticipants(List<String> allEmails, Option<CheckedUser> reporter, List<CheckedUser> existingParticipants, CheckedUser user, ServiceDesk serviceDesk, Project project, Issue issue) {
        RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result filterPhase1 = this.requestParticipantsInvitationService.filterParticipantEmailsPhase1(new HashSet<String>(allEmails), reporter, new HashSet<CheckedUser>(existingParticipants));
        if (!filterPhase1.isValid()) {
            log.debug("There are no possible participants left to add from email");
            return Option.none();
        }
        RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result filterPhase2 = this.requestParticipantsInvitationService.filterParticipantEmailsPhase2(user, serviceDesk, project, filterPhase1);
        if (!filterPhase2.isValid()) {
            log.debug("There are no possible participants left that could be invited from email");
            return Option.none();
        }
        io.atlassian.fugue.Either participantsOnIssue = Steps.begin(this.requestParticipantsInvitationService.rateLimitParticipantsInviteCheck(filterPhase2)).then(() -> this.requestParticipantsInvitationService.inviteNewParticipants(user, issue, filterPhase2)).then((success, inviteResult) -> this.checkParticipantInvitationResultValid((RequestParticipantsInvitationService.ParticipantsInviteInvitationResult)inviteResult)).then((jsdSuccess, inviteResult, jsdSuccess2) -> this.requestParticipantsInvitationService.addInvitedParticipantsToIssue(user, (RequestParticipantsInvitationService.ParticipantsInviteInvitationResult)inviteResult, false)).yield((jsdSuccess, inviteResult, jsdSuccess2, checkedUsers) -> checkedUsers);
        if (participantsOnIssue.isLeft()) {
            log.debug(((AnError)participantsOnIssue.left().get()).getMessage().getMessage());
        }
        return participantsOnIssue.toOption();
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> checkParticipantInvitationResultValid(RequestParticipantsInvitationService.ParticipantsInviteInvitationResult inviteResult) {
        if (inviteResult.isValid()) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().addError("There were no invitations attempted").buildSingleError());
    }

    private Pair<List<CheckedUser>, List<CheckedUser>> addParticipantsWithExistingAccounts(CheckedUser user, List<String> allEmails, Issue issue) {
        io.atlassian.fugue.Either<AnError, List<CheckedUser>> validResult;
        Collection<CheckedUser> validParticipants = this.requestParticipantValidator.getParticipantsByEmails(allEmails, issue);
        if (!validParticipants.isEmpty()) {
            log.debug("Found the following valid participants in email issue {} : {}. Adding them now", (Object)issue.getKey(), (Object)validParticipants.stream().map(CheckedUser::getEmailAddress).collect(Collectors.joining()));
            validResult = this.requestParticipantsInternalService.addParticipants(user, issue, new ArrayList<CheckedUser>(validParticipants));
        } else {
            validResult = this.requestParticipantsInternalService.getValidParticipants(user, issue);
        }
        validResult.left().forEach(this::logInSiteLocale);
        io.atlassian.fugue.Either<AnError, List<CheckedUser>> allResult = this.requestParticipantsInternalService.getAllExistingParticipants(user, issue);
        allResult.left().forEach(this::logInSiteLocale);
        return Pair.pair((Object)allResult.getOr(Collections::emptyList), (Object)validResult.getOr(Collections::emptyList));
    }

    private Unit trackCommentViaEmailSuccess(Issue issue) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new ServiceDeskEmailRequestCommentedEvent(issue.getProjectId()));
        return Unit.Unit();
    }

    private Unit trackOutsiderCommentViaEmailSuccess(Issue issue) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new OutsiderCommentedEvent(issue.getProjectId()));
        return Unit.Unit();
    }

    private Unit trackNonServiceDeskCommentViaEmailSuccess(Issue issue) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new NonServiceDeskEmailRequestCommentedEvent(issue.getProjectId()));
        return Unit.Unit();
    }

    private Unit logInSiteLocale(AnError error) {
        log.warn(this.errorTranslationHelper.translateAnError(error, this.i18nHelper));
        return Unit.Unit();
    }

    private Unit logInSiteLocale(ValidationErrors errors) {
        errors.getErrorMessages().stream().map(this::toTranslatedMessage).forEach(arg_0 -> ((Logger)log).warn(arg_0));
        errors.getFieldErrors().entrySet().stream().map(this::toPair).map(fieldAndMessage -> Pair.pair((Object)fieldAndMessage.left(), (Object)this.toTranslatedMessage((ErrorMessage)fieldAndMessage.right()))).map(this::toFormattedFieldError).forEach(arg_0 -> ((Logger)log).warn(arg_0));
        return Unit.Unit();
    }

    private String toTranslatedMessage(ErrorMessage errorMessage) {
        return this.errorTranslationHelper.translateErrorMessage(errorMessage, this.i18nHelper);
    }

    private <K, V> Pair<K, V> toPair(Map.Entry<K, V> entry) {
        return Pair.pair(entry.getKey(), entry.getValue());
    }

    private String toFormattedFieldError(Pair<String, String> fieldAndMessage) {
        return String.format("%s [%s]", fieldAndMessage.right(), fieldAndMessage.left());
    }

    private Map<String, JSONObject> createEmailCommentProperty(Message message) {
        List<String> emailList = this.getAllEmailAddressesFromMessage(message, Collections.emptyList());
        return this.internalCommentNotificationsUtils.createEmailPropertyMap(emailList);
    }

    private List<String> getAllEmailAddressesFromMessage(Message message, Collection<String> filterOutEmailAddresses) {
        ArrayList<String> emails = new ArrayList<String>();
        emails.addAll(ServiceDeskMailUtils.getRecipientAddresses((Message)message, (Message.RecipientType)Message.RecipientType.TO));
        emails.addAll(ServiceDeskMailUtils.getRecipientAddresses((Message)message, (Message.RecipientType)Message.RecipientType.CC));
        if (filterOutEmailAddresses.isEmpty()) {
            return emails;
        }
        List allEmailChannelAddressesLower = filterOutEmailAddresses.stream().map(StringUtils::lowerCase).collect(Collectors.toList());
        return emails.stream().filter(email -> {
            String lowerEmail = StringUtils.lowerCase((String)email);
            return !Iterables.any((Iterable)allEmailChannelAddressesLower, sdEmail -> Objects.equals(lowerEmail, sdEmail));
        }).collect(Collectors.toList());
    }

    private io.atlassian.fugue.Either<AnError, Issue> createIssueInJiraContext(CheckedUser reporter, Project project, ServiceDesk serviceDesk, RequestType requestType, Message message, String emailAddress) {
        return Steps.begin(this.buildProjectParameters(reporter, project, requestType, serviceDesk)).then(() -> this.incomingEmailParser.parse(message, false)).then((createRequestProjectParameters, parsedEmail) -> this.buildRequestFieldsParameters(reporter, project, requestType, (IncomingEmailParser.ParsedEmail)parsedEmail)).then((createRequestProjectParameters, parsedEmail, createRequestFieldParameters) -> this.customerRequestService.createRequest(reporter, (InternalCustomerRequestServiceScala.CreateRequestProjectParameters)createRequestProjectParameters, (InternalCustomerRequestServiceScala.CreateRequestFieldParameters)createRequestFieldParameters)).then((createRequestProjectParameters, parsedEmail, createRequestFieldParameters, createIssueResponse) -> this.postProcessIssueCreation(reporter, createIssueResponse.getIssue(), emailAddress, parsedEmail.getAttachments(), this.isSharedRequest((InternalCustomerRequestServiceScala.CreateRequestFieldParameters)createRequestFieldParameters))).yield((createRequestProjectParameters, parsedEmail, createRequestFieldParameters, createIssueResponse, issue) -> issue);
    }

    private io.atlassian.fugue.Either<AnError, InternalCustomerRequestServiceScala.CreateRequestProjectParameters> buildProjectParameters(CheckedUser reporter, Project project, RequestType requestType, ServiceDesk serviceDesk) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.portalService.getPortalForProject(reporter.forJIRA(), project))).then(portal -> this.requestTypeFieldInternalService.getRequestTypeFieldsWithoutDynamics(reporter, project, requestType)).then((portal, requestTypeFields) -> RequestTypeWithFields.build(requestType, requestTypeFields).toRight(() -> ((CommonErrors)this.commonErrors).REQUEST_TYPE_INTEGRITY_ERROR())).then((portal, requestTypeFields, requestTypeWithFields) -> this.serviceDeskIssueTypeManager.getIssueTypeForProject(requestType.getIssueTypeId(), project)).yield((portal, requestTypeFieldInternals, requestTypeWithFields, issueType) -> new InternalCustomerRequestServiceScala.CreateRequestProjectParameters(project, (IssueType)issueType, serviceDesk, (Portal)portal, (RequestTypeWithFields)requestTypeWithFields));
    }

    private io.atlassian.fugue.Either<AnError, InternalCustomerRequestServiceScala.CreateRequestFieldParameters> buildRequestFieldsParameters(CheckedUser user, Project project, RequestType requestType, IncomingEmailParser.ParsedEmail parsedEmail) {
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            Option<CustomerOrganization> defaultOrganisation = this.organisationMemberManager.getUserDefaultOrganizationInProject(user, project);
            Option<CustomField> organisationsCF = this.organisationsCFManager.getOrCreateOrganizationsCF();
            if (defaultOrganisation.isDefined() && organisationsCF.isDefined()) {
                return this.buildSharedRequestFieldsParameters(user, project, requestType, parsedEmail, (CustomField)organisationsCF.get(), (CustomerOrganization)defaultOrganisation.get());
            }
        }
        return this.buildPrivateRequestFieldsParameters(user, project, requestType, parsedEmail);
    }

    private io.atlassian.fugue.Either<AnError, InternalCustomerRequestServiceScala.CreateRequestFieldParameters> buildPrivateRequestFieldsParameters(CheckedUser user, Project project, RequestType requestType, IncomingEmailParser.ParsedEmail parsedEmail) {
        return Steps.begin(this.requestTypeFieldInternalService.getVisibleRequestTypeFields(user, project, requestType)).then(requestTypeFields -> this.validateMessageForCreation(requestType, (List<RequestTypeFieldInternal>)requestTypeFields, parsedEmail.getSubject(), parsedEmail.getBody())).yield((requestTypeFields, jsdSuccess) -> new InternalCustomerRequestServiceScala.CreateRequestFieldParameters(CustomerRequestChannelSource.EMAIL, this.buildFormValuesMap((List<RequestTypeFieldInternal>)requestTypeFields, parsedEmail.getSubject(), parsedEmail.getBody()), (Option<CustomerRequestCreateParameters>)Option.none()));
    }

    private io.atlassian.fugue.Either<AnError, InternalCustomerRequestServiceScala.CreateRequestFieldParameters> buildSharedRequestFieldsParameters(CheckedUser user, Project project, RequestType requestType, IncomingEmailParser.ParsedEmail parsedEmail, CustomField organisationsCF, CustomerOrganization organisation) {
        io.atlassian.fugue.Either<AnError, InternalCustomerRequestServiceScala.CreateRequestFieldParameters> requestParamsEither = this.buildPrivateRequestFieldsParameters(user, project, requestType, parsedEmail);
        if (requestParamsEither.isRight()) {
            Map<String, String[]> formValues = ((InternalCustomerRequestServiceScala.CreateRequestFieldParameters)requestParamsEither.right().get()).formValues();
            formValues.put(organisationsCF.getId(), new String[]{String.valueOf(organisation.getId())});
        }
        return requestParamsEither;
    }

    private Map<String, String[]> buildFormValuesMap(List<RequestTypeFieldInternal> requestTypeFields, String subject, String body) {
        HashMap<String, String[]> formValues = new HashMap<String, String[]>();
        requestTypeFields.stream().filter(r -> "summary".equals(r.getFieldId())).findAny().ifPresent(r -> formValues.put(r.getFieldId(), new String[]{subject}));
        requestTypeFields.stream().filter(r -> "description".equals(r.getFieldId())).findAny().ifPresent(r -> formValues.put(r.getFieldId(), new String[]{body}));
        return formValues;
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> validateMessageForCreation(RequestType requestType, List<RequestTypeFieldInternal> requestTypeFields, String subject, String body) {
        io.atlassian.fugue.Either<AnError, RequestType> requestTypeValid = this.requestTypeFieldValidator.isRequestTypeValidForEmailChannel(requestType, requestTypeFields);
        if (requestTypeValid.isLeft()) {
            return requestTypeValid.map(x -> JSDSuccess.success());
        }
        if (StringUtils.isBlank((String)subject)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.EMAIL_CHANNEL_MESSAGE_SUBJECT_IS_EMPTY());
        }
        boolean isDescriptionRequired = requestTypeFields.stream().anyMatch(f -> "description".equals(f.getFieldId()) && f.isRequired());
        if (isDescriptionRequired && StringUtils.isBlank((String)body)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.EMAIL_CHANNEL_MESSAGE_BODY_IS_EMPTY());
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }

    private io.atlassian.fugue.Either<AnError, Issue> postProcessIssueCreation(CheckedUser reporter, Issue issue, String emailAddress, List<MailUtils.Attachment> attachments, boolean sharedRequest) {
        this.issueChannelService.setEmailChannelAddress((SDUser)reporter, issue.getId(), emailAddress);
        if (!attachments.isEmpty()) {
            io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, SDCommentAndAttachments>> addAttachmentResult = this.internalServiceDeskCommentService.addAttachmentsFromEmailToCreatedIssue(attachments, issue, reporter);
            addAttachmentResult.left().forEach(this::logInSiteLocale);
            addAttachmentResult.right().forEach(validationErrorsOrCommentCreationResult -> validationErrorsOrCommentCreationResult.left().forEach(this::logInSiteLocale));
        }
        if (sharedRequest) {
            this.trackRequestCreatedSharedWithOrganization(issue);
        }
        return io.atlassian.fugue.Either.right((Object)issue);
    }

    private void trackRequestCreatedSharedWithOrganization(Issue issue) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new RequestCreatedSharedWithOrganizationViaEmailAnalyticsEvent(issue.getProjectId()));
    }

    private boolean isSharedRequest(InternalCustomerRequestServiceScala.CreateRequestFieldParameters requestFieldParameters) {
        Option<CustomField> organizationsCF = this.organisationsCFManager.getOrCreateOrganizationsCF();
        if (organizationsCF.isDefined()) {
            String[] sharedOrgs = requestFieldParameters.formValues().get(((CustomField)organizationsCF.get()).getId());
            return sharedOrgs != null && sharedOrgs.length > 0;
        }
        return false;
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> validateMessageForCommenting(IncomingEmailParser.ParsedEmail parsedEmail) {
        if (StringUtils.isBlank((String)parsedEmail.getBody()) && parsedEmail.getAttachments().isEmpty()) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.EMAIL_CHANNEL_MESSAGE_BODY_IS_EMPTY());
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }
}

