/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.emailchannel;

import com.atlassian.servicedesk.internal.rest.requests.IncomingEmailSaveRequest;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;

public class EmailConfiguration {
    private final String email;
    private final String username;
    private final String password;
    private final String protocol;
    private final String host;
    private final String port;
    private final Boolean tls;
    private final Integer requestTypeId;
    private final Option<IncomingEmailSaveRequest> emailSettingRequest;

    public EmailConfiguration(String email, String username, String password, String protocol, String host, String port, Boolean tls, Integer requestTypeId, Option<IncomingEmailSaveRequest> emailSettingRequest) {
        this.email = email;
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.tls = tls;
        this.requestTypeId = requestTypeId;
        this.emailSettingRequest = emailSettingRequest;
    }

    public static EmailConfiguration from(IncomingEmailSaveRequest incomingEmailSaveRequest) {
        return new EmailConfiguration((String)incomingEmailSaveRequest.getEmailAddress().getOrElse((Object)""), (String)incomingEmailSaveRequest.getUsername().getOrElse((Object)""), (String)incomingEmailSaveRequest.getPassword().getOrElse((Object)""), (String)incomingEmailSaveRequest.getProtocol().getOrElse((Object)""), (String)incomingEmailSaveRequest.getHost().getOrElse((Object)""), (String)incomingEmailSaveRequest.getPort().getOrElse((Object)""), (Boolean)incomingEmailSaveRequest.getTls().getOrElse((Object)false), (Integer)incomingEmailSaveRequest.getRequestTypeId().getOrElse((Object)0), (Option<IncomingEmailSaveRequest>)Option.some((Object)incomingEmailSaveRequest));
    }

    public String getNEPassword(String defaultPassword) {
        if (StringUtils.isEmpty((String)this.password)) {
            return defaultPassword;
        }
        return this.password;
    }

    public IncomingEmailSaveRequest request() {
        return (IncomingEmailSaveRequest)this.emailSettingRequest.getOrElse((Object)this.fromConfiguration());
    }

    public String getEmail() {
        return this.email;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Boolean getTls() {
        return this.tls;
    }

    public Integer getRequestTypeId() {
        return this.requestTypeId;
    }

    public Option<IncomingEmailSaveRequest> getEmailSettingRequest() {
        return this.emailSettingRequest;
    }

    private IncomingEmailSaveRequest fromConfiguration() {
        IncomingEmailSaveRequest req = new IncomingEmailSaveRequest();
        req.setEmailAddress(this.email);
        req.setUsername(this.username);
        req.setPassword(this.password);
        req.setProtocol(this.protocol);
        req.setHost(this.host);
        req.setPort(this.port);
        req.setRequestTypeId(this.requestTypeId);
        return req;
    }
}

