/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customfields.template.fields;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.servicedesk.internal.feature.customfields.template.fields.SourceCustomFieldManager;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SourceCustomFieldManagerImpl
implements SourceCustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(SourceCustomFieldManagerImpl.class);
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.project.template.itil.v2.custom.field.source.name").fieldDescription("sd.project.template.itil.v2.custom.field.source.desc").fieldType("com.atlassian.jira.plugin.system.customfieldtypes:select").fieldKey("source-field").fieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher").optionNames(new String[]{"sd.project.template.itil.v2.custom.field.source.value.email", "sd.project.template.itil.v2.custom.field.source.value.phone", "sd.project.template.itil.v2.custom.field.source.value.monitoring", "sd.project.template.itil.v2.custom.field.source.value.vendor", "sd.project.template.itil.v2.custom.field.source.value.customer", "sd.project.template.itil.v2.custom.field.source.value.other"}).build();
    private final GlobalCustomFieldService globalCustomFieldService;

    @Autowired
    public SourceCustomFieldManagerImpl(GlobalCustomFieldService globalCustomFieldService) {
        this.globalCustomFieldService = globalCustomFieldService;
    }

    @Override
    public Option<CustomField> getOrCreateSourceCustomField() {
        try {
            CustomField cf = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            return Option.option((Object)cf);
        }
        catch (CustomFieldException e) {
            log.error(e.getMessage());
            return Option.none();
        }
    }
}

