/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customfields.template.fields;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.servicedesk.internal.feature.customfields.template.fields.ProductCategorizationCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.CascadingCustomFieldUtil;
import com.atlassian.servicedesk.internal.feature.customfields.template.util.CustomFieldOption;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductCategorizationCustomFieldManagerImpl
implements ProductCategorizationCustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(ProductCategorizationCustomFieldManagerImpl.class);
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.project.template.itil.v2.custom.field.product.categorization.name").fieldType("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect").fieldKey("product-categorization-field").fieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher").build();
    private final List<CustomFieldOption> customFieldOptions = Lists.newArrayList((Object[])new CustomFieldOption[]{new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware", Lists.newArrayList((Object[])new CustomFieldOption[]{new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.cpd", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.peripheral", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.power", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.component", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.process", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.virtual", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.disc", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.hardware.tape", Collections.emptyList())})), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.software", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.communication", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.service", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.people", Collections.emptyList()), new CustomFieldOption("sd.project.template.itil.v2.custom.field.product.categorization.value.document", Collections.emptyList())});
    private final GlobalCustomFieldService globalCustomFieldService;
    private final I18nHelper i18nHelper;

    @Autowired
    public ProductCategorizationCustomFieldManagerImpl(GlobalCustomFieldService globalCustomFieldService, I18nHelper i18nHelper) {
        this.globalCustomFieldService = globalCustomFieldService;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public Option<CustomField> getOrCreateProductCategorizationCustomField() {
        try {
            CustomField cf = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            CascadingCustomFieldUtil.addCascadingOptions(cf, this.customFieldOptions, this.i18nHelper);
            return Option.option((Object)cf);
        }
        catch (CustomFieldException e) {
            log.error(e.getMessage());
            return Option.none();
        }
    }
}

