/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.search;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherActiveState;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherUsernames;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.jira.crowd.ServiceDeskCrowdUserQueryDslDao;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class UserSearchManagerHelperImpl
implements UserSearchManagerHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserSearchManagerHelperImpl.class);
    private static final UserSearchParams ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL = UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).canMatchEmail(true).includeInactive(false).build();
    @VisibleForTesting
    static final UserSearchParams NO_RESULTS_PARAMS = UserSearchParams.builder().allowEmptyQuery(false).includeActive(false).canMatchEmail(false).includeInactive(false).filter(Predicates.alwaysFalse()).build();
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final InternalServiceDeskAccessService internalServiceDeskAccessService;
    private final FieldConfigManager fieldConfigManager;
    private final UserFilterManager userFilterManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final ServiceDeskCrowdUserQueryDslDao serviceDeskCrowdUserQueryDslDao;
    private final CustomerContextService customerContextService;

    @Autowired
    public UserSearchManagerHelperImpl(UserFactory userFactory, ServiceDeskPermissions serviceDeskPermissions, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, InternalServiceDeskAccessService internalServiceDeskAccessService, FieldConfigManager fieldConfigManager, UserFilterManager userFilterManager, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager, FieldManager fieldManager, ServiceDeskCrowdUserQueryDslDao serviceDeskCrowdUserQueryDslDao, CustomerContextService customerContextService) {
        this.userFactory = userFactory;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.internalServiceDeskAccessService = internalServiceDeskAccessService;
        this.fieldConfigManager = fieldConfigManager;
        this.userFilterManager = userFilterManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.serviceDeskCrowdUserQueryDslDao = serviceDeskCrowdUserQueryDslDao;
        this.customerContextService = customerContextService;
    }

    @Deprecated
    public UserSearchParams buildCustomerUserSearchParamsWithoutOrganizations(Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit) {
        return this.doBuildCustomerUserSearchParams(project, serviceDesk, queryLimit, Collections.emptySet()).getUserSearchParams();
    }

    public UserSearchManagerHelper.CustomerUserSearchData buildCustomerUserSearchParams(Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit, Set<String> excludedUserKeys) {
        return this.doBuildCustomerUserSearchParams(project, serviceDesk, queryLimit, excludedUserKeys);
    }

    private UserSearchManagerHelper.CustomerUserSearchData doBuildCustomerUserSearchParams(Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit, Set<String> excludedUserKeys) {
        UserSearchParams.Builder builder = UserSearchParams.builder((UserSearchParams)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL).maxResults((Integer)queryLimit.getOrNull());
        boolean openAccess2 = this.internalServiceDeskAccessService.isOpenAccess(serviceDesk);
        if (openAccess2) {
            if (excludedUserKeys.isEmpty()) {
                builder.filter(user -> Option.option((Object)ApplicationUsers.from((User)user)).exists(ApplicationUser::isActive));
            } else {
                builder.filter(user -> this.userFactory.wrap(ApplicationUsers.from((User)user)).exists(checkedUser -> checkedUser.forJIRA().isActive() && this.isNotExcluded(excludedUserKeys, checkedUser.getKey())));
            }
        } else {
            CustomerServiceValidator customerServiceValidator = ServiceDeskComponentAccessor.getCustomerServiceValidator();
            builder.filter(user -> this.userFactory.wrap(ApplicationUsers.from((User)user)).exists(checkedUser -> this.isNotExcluded(excludedUserKeys, checkedUser.getKey()) && customerServiceValidator.isCustomerForProject((CheckedUser)checkedUser, project)));
        }
        builder.filterByProjectIds((Collection)ImmutableSet.of((Object)project.getId()));
        return new UserSearchManagerHelper.CustomerUserSearchData(openAccess2, builder.build());
    }

    public UserSearchParams buildActiveOnlyUserSearchParams(Option<Integer> queryLimit) {
        return this.buildNotExcludedActiveOnlyUserSearchParams(queryLimit, Collections.emptySet());
    }

    public UserSearchParams buildNotExcludedActiveOnlyUserSearchParams(Option<Integer> queryLimit, Set<String> excludedUserKeys) {
        UserSearchParams.Builder builder = UserSearchParams.builder((UserSearchParams)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL).maxResults((Integer)queryLimit.getOrNull());
        if (!excludedUserKeys.isEmpty()) {
            builder.filter(user -> Option.option((Object)ApplicationUsers.from((User)user)).exists(appUser -> this.isNotExcluded(excludedUserKeys, appUser.getKey())));
        }
        return builder.build();
    }

    public UserSearchParams buildInternalOnlyUserSearchParams(Project project, Option<Integer> queryLimit) {
        UserSearchParams.Builder builder = UserSearchParams.builder((UserSearchParams)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL).maxResults((Integer)queryLimit.getOrNull());
        builder.filter(user -> this.userFactory.wrap(ApplicationUsers.from((User)user)).exists(checkedUser -> (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.serviceDeskPermissions.hasInternalCustomerAccess((SDUser)checkedUser, project)) != false && this.serviceDeskLicenseAndPermissionService.canAccessJIRA((SDUser)checkedUser)));
        builder.filterByProjectIds((Collection)ImmutableList.of((Object)project.getId()));
        return builder.build();
    }

    public UserSearchParams buildEmailMatcherUserSearchParams(@Nullable String emailAddress, UserEmailMatcherActiveState activeUserState, UserEmailMatcherUsernames matchUsernames) {
        if (StringUtils.isBlank((String)emailAddress)) {
            return NO_RESULTS_PARAMS;
        }
        return UserSearchParams.builder((UserSearchParams)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL).includeInactive(true).maxResults(null).filter(user -> user != null && this.matchUserActiveState((User)user, activeUserState, false) && (this.matchUserEmail((User)user, emailAddress) || (Boolean)this.optionalMatchUserUsername((User)user, emailAddress, matchUsernames).getOr(Suppliers.alwaysFalse()) != false)).build();
    }

    public UserSearchParams buildEmailValidatorUserSearchParams(@Nullable String emailAddress, UserEmailMatcherActiveState activeUserState, UserEmailMatcherUsernames matchUsernames) {
        if (StringUtils.isBlank((String)emailAddress)) {
            return NO_RESULTS_PARAMS;
        }
        return UserSearchParams.builder((UserSearchParams)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL).includeInactive(true).maxResults(null).filter(user -> user != null && (this.matchUserActiveState((User)user, activeUserState, true) && this.matchUserEmail((User)user, emailAddress) || (Boolean)this.optionalMatchUserUsername((User)user, emailAddress, matchUsernames).getOr(Suppliers.alwaysFalse()) != false)).build();
    }

    public Option<UserSearchManagerHelper.CustomerUserSearchData> buildPortalCustomerUserSearchParams(String fieldId, Option<String> fieldConfigId, Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit) {
        return this.getFieldConfigOption(fieldId, fieldConfigId).flatMap(fieldConfig -> this.createPortalCustomerUserSearchParams((Option<FieldConfig>)fieldConfig, project, serviceDesk, queryLimit));
    }

    @Deprecated
    public Option<UserSearchParams> buildPortalCustomerUserSearchParamsWithoutOrganizations(String fieldId, Option<String> fieldConfigId, Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit) {
        return this.getFieldConfigOption(fieldId, fieldConfigId).flatMap(fieldConfig -> {
            UserSearchParams params = this.buildCustomerUserSearchParamsWithoutOrganizations(project, serviceDesk, queryLimit);
            return (Option)fieldConfig.fold(Suppliers.ofInstance((Object)Option.some((Object)params)), config -> this.getParamsFromFieldConfigAndProject((FieldConfig)config, project, params));
        });
    }

    public Option<UserSearchParams> buildUserFilteringOnlyUserSearchParams(Option<FieldConfig> fieldConfig, Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit) {
        return (Option)fieldConfig.fold(Suppliers.ofInstance((Object)Option.some((Object)ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL)), config -> this.getParamsFromFieldConfigAndProject((FieldConfig)config, project, ACTIVE_USERS_ALLOW_EMPTY_QUERY_AND_EMAIL));
    }

    public boolean isNotExcluded(Collection<String> excludedUserKeys, String userKey) {
        return excludedUserKeys.isEmpty() || !excludedUserKeys.contains(userKey);
    }

    private Option<Option<FieldConfig>> getFieldConfigOption(String fieldId, Option<String> fieldConfigId) {
        Option fieldConfig;
        Field field = this.fieldManager.getField(fieldId);
        if (field == null) {
            return Option.none();
        }
        if (fieldConfigId.isDefined() && this.fieldManager.isCustomField(field)) {
            io.atlassian.fugue.Either<Unit, Option<FieldConfig>> foundConfig = this.findFieldConfig(fieldConfigId);
            if (foundConfig.isLeft()) {
                return Option.none();
            }
            fieldConfig = (Option)foundConfig.right().get();
        } else {
            fieldConfig = Option.none();
        }
        return Option.some((Object)fieldConfig);
    }

    @VisibleForTesting
    Option<UserSearchManagerHelper.CustomerUserSearchData> createPortalCustomerUserSearchParams(Option<FieldConfig> fieldConfig, Project project, ServiceDesk serviceDesk, Option<Integer> queryLimit) {
        UserSearchManagerHelper.CustomerUserSearchData customerUserSearchData = this.buildCustomerUserSearchParams(project, serviceDesk, queryLimit);
        return (Option)fieldConfig.fold(Suppliers.ofInstance((Object)Option.some((Object)customerUserSearchData)), config -> this.getParamsFromFieldConfigAndProject((FieldConfig)config, project, customerUserSearchData.getUserSearchParams()).map(params -> new UserSearchManagerHelper.CustomerUserSearchData(customerUserSearchData.isOpenAccess(), params)));
    }

    private boolean matchUserActiveState(User user, UserEmailMatcherActiveState activeUserState, boolean inValidatorContext) {
        if (!activeUserState.isIncludeInactive()) {
            return user.isActive();
        }
        if (!inValidatorContext || user.isActive()) {
            return true;
        }
        boolean deleted = (Boolean)StepsConverters.newerEither((Either)this.userFactory.wrap(ApplicationUsers.from((User)user))).map(this.serviceDeskCrowdUserQueryDslDao::isUserDeletedExternally).getOr(Suppliers.alwaysFalse());
        return !deleted;
    }

    private boolean matchUserEmail(User user, String emailAddress) {
        return StringUtils.equalsIgnoreCase((String)user.getEmailAddress(), (String)emailAddress);
    }

    private Option<Boolean> optionalMatchUserUsername(User user, String emailAddress, UserEmailMatcherUsernames matchUsernames) {
        if (matchUsernames.isCanMatchUsername()) {
            return Option.some((Object)StringUtils.equalsIgnoreCase((String)user.getName(), (String)emailAddress));
        }
        return Option.none();
    }

    private io.atlassian.fugue.Either<Unit, Option<FieldConfig>> findFieldConfig(Option<String> fieldConfigIdOption) {
        String fieldConfigId = (String)fieldConfigIdOption.getOrNull();
        if (StringUtils.isBlank((String)fieldConfigId)) {
            return io.atlassian.fugue.Either.right((Object)Option.none());
        }
        if (!NumberUtils.isDigits((String)fieldConfigId)) {
            logger.info("The provided fieldConfigId is invalid, as it is not a number : {}", (Object)fieldConfigId);
            return io.atlassian.fugue.Either.left((Object)Unit.Unit());
        }
        long fieldConfigIdValue = Long.parseLong(fieldConfigId);
        FieldConfig config = this.fieldConfigManager.getFieldConfig(Long.valueOf(fieldConfigIdValue));
        if (config == null) {
            logger.info("Did not find an expected field config for field involved in user picker search : requested id was {}", (Object)fieldConfigId);
            return io.atlassian.fugue.Either.left((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.right((Object)Option.some((Object)config));
    }

    private Option<UserSearchParams> getParamsFromFieldConfigAndProject(FieldConfig fieldConfig, Project project, UserSearchParams baseParams) {
        UserFilter userFilter = this.userFilterManager.getFilter(fieldConfig);
        if (userFilter == null) {
            logger.info("Did not find an expected user filter for field involved in user picker search");
            return Option.none();
        }
        if (userFilter.isEnabled()) {
            Collection projectIds = CustomFieldUtils.getProjectIdsFromProjectOrFieldConfig((Long)project.getId(), (FieldConfig)fieldConfig, (FieldConfigSchemeManager)this.fieldConfigSchemeManager, (ProjectManager)this.projectManager);
            return Option.some((Object)UserSearchParams.builder((UserSearchParams)baseParams).filter(userFilter).filterByProjectIds(projectIds).build());
        }
        return Option.some((Object)baseParams);
    }
}

