/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidation;
import io.atlassian.fugue.Option;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;

public enum CustomerInviteValidationStatus {
    INVALID_USER_EXTERNALLY_DELETED(false),
    INVALID_USER_INACTIVE(false),
    INVALID_USER_ALREADY_CUSTOMER(false),
    INVALID_NEW_EMAIL_ADDRESS(false),
    INVALID_NEW_USERNAME(false),
    INVALID_FAILED_NEW_USER_CHECKS(false),
    PASSED(true),
    PASSED_CAN_SIGNUP_WITH_EMAIL_BUT_INACTIVE(true);

    private final boolean valid;

    private CustomerInviteValidationStatus(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static String getOldErrorHtml(CheckedUser loggedInUser, CustomerInviteValidation customerInviteValidationResult) {
        switch (customerInviteValidationResult.getCustomerInviteValidationStatus()) {
            case INVALID_USER_INACTIVE: {
                return loggedInUser.i18NHelper().getText("sd.agent.people.customers.invite.error.user.inactive");
            }
            case INVALID_USER_ALREADY_CUSTOMER: {
                return loggedInUser.i18NHelper().getText("sd.agent.people.customers.invite.error.user.already");
            }
            case INVALID_USER_EXTERNALLY_DELETED: {
                return loggedInUser.i18NHelper().getText("sd.agent.people.customers.invite.error.user.deleted");
            }
            case INVALID_NEW_EMAIL_ADDRESS: 
            case INVALID_NEW_USERNAME: {
                return loggedInUser.i18NHelper().getText("sd.component.emailpicker.email.error.invalid.email.single", customerInviteValidationResult.getCustomerInviteUser().getEmailAddress());
            }
            case INVALID_FAILED_NEW_USER_CHECKS: {
                return (String)customerInviteValidationResult.getNewUserErrorMessage().getOrElse((Object)loggedInUser.i18NHelper().getText("sd.user.error.unknown.user.signup.validate"));
            }
        }
        throw new IllegalArgumentException("Unknown customer invite validation status `" + (Object)((Object)customerInviteValidationResult.getCustomerInviteValidationStatus()) + "` provided while getting short error html. Get a developer to fix their mistake");
    }

    public static String getErrorHtml(I18nHelper i18nHelper, boolean isJiraAdmin, boolean isInCustomerPortalContext, String jiraBaseUrl, CustomerInviteValidation customerInviteValidationResult) {
        String username = (String)Option.option((Object)customerInviteValidationResult.getCustomerInviteUser().getApplicationUser()).map(ApplicationUser::getName).getOrNull();
        switch (customerInviteValidationResult.getCustomerInviteValidationStatus()) {
            case INVALID_USER_INACTIVE: {
                if (isJiraAdmin) {
                    if (isInCustomerPortalContext) {
                        return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.inactive.admin.portal");
                    }
                    UriBuilder profileUrlBuilder = UriBuilder.fromPath((String)StringUtils.stripEnd((String)jiraBaseUrl, (String)"/")).path("/secure/admin/user/ViewUser.jspa").queryParam("name", new Object[]{username});
                    return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.inactive", CustomerInviteValidationStatus.createLinkStartTag(profileUrlBuilder.build(new Object[0]).toString()), "</a>");
                }
                return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.inactive.agent");
            }
            case INVALID_USER_ALREADY_CUSTOMER: {
                return i18nHelper.getText("sd.agent.people.customers.invite.error.user.already");
            }
            case INVALID_USER_EXTERNALLY_DELETED: {
                if (isJiraAdmin) {
                    if (isInCustomerPortalContext) {
                        return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.deleted.admin.portal");
                    }
                    String umUrl = CustomerInviteValidationStatus.getUserManagementHomeUrl(jiraBaseUrl);
                    return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.deleted", CustomerInviteValidationStatus.createLinkStartTag(umUrl), "</a>");
                }
                return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.user.deleted.agent");
            }
            case INVALID_NEW_EMAIL_ADDRESS: {
                return i18nHelper.getText("sd.component.emailpicker.email.error.invalid.email.single", customerInviteValidationResult.getCustomerInviteUser().getEmailAddress());
            }
            case INVALID_NEW_USERNAME: {
                if (isJiraAdmin) {
                    String umUrl = CustomerInviteValidationStatus.getUserManagementHomeUrl(jiraBaseUrl);
                    return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.invalid.username", CustomerInviteValidationStatus.createLinkStartTag(umUrl), "</a>");
                }
                return i18nHelper.getText("sd.agent.people.customers.invite.validation.fail.invalid.username.agent");
            }
            case INVALID_FAILED_NEW_USER_CHECKS: {
                return (String)customerInviteValidationResult.getNewUserErrorMessage().getOrElse((Object)i18nHelper.getText("sd.user.error.unknown.user.signup.validate"));
            }
        }
        throw new IllegalArgumentException("Unknown customer invite validation status `" + (Object)((Object)customerInviteValidationResult.getCustomerInviteValidationStatus()) + "` provided while getting long error html. Get a developer to fix their mistake");
    }

    private static String createLinkStartTag(String url) {
        return "<a href=\"" + url + "\">";
    }

    private static String getUserManagementHomeUrl(String jiraBaseUrl) {
        return StringUtils.stripEnd((String)jiraBaseUrl, (String)"/") + "/secure/admin/user/UserBrowser.jspa";
    }
}

