/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite.result;

import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.FailedInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InviteCustomerResult {
    private final CheckedUser user;
    private final List<FailedInviteResult> failedInvites;
    private final List<SuccessInviteResult> successInvites;

    private InviteCustomerResult(CheckedUser user, List<FailedInviteResult> failedInvites, List<SuccessInviteResult> successInvites) {
        this.user = user;
        this.failedInvites = ImmutableList.copyOf(failedInvites);
        this.successInvites = ImmutableList.copyOf(successInvites);
    }

    public List<FailedInviteResult> getFailedInvites() {
        return this.failedInvites;
    }

    public List<SuccessInviteResult> getSuccessInvites() {
        return this.successInvites;
    }

    public CheckedUser getUser() {
        return this.user;
    }

    public boolean hasFailedInvite() {
        return !this.failedInvites.isEmpty();
    }

    public boolean hasSuccessInvite() {
        return !this.successInvites.isEmpty();
    }

    public static Builder builder(CheckedUser user) {
        return new Builder(user);
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private final ImmutableList.Builder<FailedInviteResult> failureList;
        private final ImmutableList.Builder<SuccessInviteResult> successList;
        private final CheckedUser user;

        private Builder(CheckedUser user) {
            this.user = user;
            this.failureList = ImmutableList.builder();
            this.successList = ImmutableList.builder();
        }

        public Builder add(String key, String emailAddress, String displayName, Option<String> errorMessage) {
            errorMessage.fold(() -> this.successList.add((Object)new SuccessInviteResult(key, emailAddress, displayName)), error -> this.failureList.add((Object)new FailedInviteResult(key, emailAddress, displayName, (String)error)));
            return this;
        }

        public InviteCustomerResult build() {
            return new InviteCustomerResult(this.user, (List)this.failureList.build(), (List)this.successList.build());
        }
    }
}

