/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.user.invite;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherActiveState;
import com.atlassian.servicedesk.internal.api.search.user.UserEmailMatcherUsernames;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.CustomerManager;
import com.atlassian.servicedesk.internal.feature.customer.user.ServiceDeskUserManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.CustomerInviteManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.InviteService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteUser;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidation;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidationStatus;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.SignupManager;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailUtil;
import com.atlassian.servicedesk.internal.feature.jira.crowd.ServiceDeskCrowdUserQueryDslDao;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Eithers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component
public class CustomerInviteManagerImpl
implements CustomerInviteManager {
    private final ServiceDeskUserManager serviceDeskUserManager;
    private final SignupManager signUpManager;
    private final InviteService inviteService;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final UserFactory userFactory;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskCrowdUserQueryDslDao serviceDeskCrowdUserQueryDslDao;
    private final CustomerUrlUtil customerUrlUtil;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final CustomerOrganizationMemberService organizationMemberService;
    private final CustomerContextService customerContextService;
    private final CustomerManager customerManager;
    private final ErrorTranslationHelper errorTranslationHelper;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender;

    @Autowired
    public CustomerInviteManagerImpl(InviteService inviteService, ServiceDeskUserManager serviceDeskUserManager, SignupManager signUpManager, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, UserFactory userFactory, ErrorResultHelper errorResultHelper, ServiceDeskCrowdUserQueryDslDao serviceDeskCrowdUserQueryDslDao, CustomerUrlUtil customerUrlUtil, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, CustomerOrganizationMemberService organizationMemberService, CustomerContextService customerContextService, CustomerManager customerManager, ErrorTranslationHelper errorTranslationHelper, ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender) {
        this.inviteService = inviteService;
        this.serviceDeskUserManager = serviceDeskUserManager;
        this.signUpManager = signUpManager;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.userFactory = userFactory;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskCrowdUserQueryDslDao = serviceDeskCrowdUserQueryDslDao;
        this.customerUrlUtil = customerUrlUtil;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.organizationMemberService = organizationMemberService;
        this.customerContextService = customerContextService;
        this.customerManager = customerManager;
        this.errorTranslationHelper = errorTranslationHelper;
        this.serviceDeskNotificationInternalSender = serviceDeskNotificationInternalSender;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerInviteManager.CustomerInviteValidationResult> validateInviteCustomersByEmailOrUsername(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, Set<String> emailOrUsernames) {
        List eithers = emailOrUsernames.stream().map(emailOrUsername -> this.validateNewCustomerForProject(checkedUser, project, (String)emailOrUsername)).collect(Collectors.toList());
        return Eithers.sequenceRight(eithers).map(this::handleDuplicateResults).map(list -> new CustomerInviteManager.CustomerInviteValidationResult(checkedUser, serviceDesk, project, (Collection<CustomerInviteValidation>)list));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerInviteManager.CustomerInviteValidationResult> validateInviteCustomersByEmail(CheckedUser checkedUser, ServiceDesk serviceDesk, Project project, Set<String> emails) {
        List invalidEmails = emails.stream().filter(email -> !EmailUtil.isEmailAddressValid(email)).collect(Collectors.toList());
        if (!invalidEmails.isEmpty()) {
            if (invalidEmails.size() == 1) {
                return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.component.emailpicker.email.error.invalid.email.single", new Object[]{Iterables.getOnlyElement(invalidEmails)}).build());
            }
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.component.emailpicker.email.error.invalid.email.plural", new Object[]{StringUtils.join(invalidEmails, (String)", ")}).build());
        }
        return this.validateInviteCustomersByEmailOrUsername(checkedUser, serviceDesk, project, emails);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomers(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        return this.doInviteCustomers(customerInviteValidationResult, false);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomersToOrganisationByName(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult, String organisationName) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        Objects.requireNonNull(organisationName, "organisationName");
        return Steps.begin(this.doInviteCustomers(customerInviteValidationResult, true)).then(this::getCheckedUsers).then((inviteCustomerResult, checkedUsers) -> this.inviteCustomerToNewOrExistingOrganisation(inviteCustomerResult.getUser(), (Collection<CheckedUser>)checkedUsers, customerInviteValidationResult.getProject(), organisationName)).yield((inviteCustomerResult, checkedUsers, associatedUsers) -> inviteCustomerResult);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, InviteCustomerResult> inviteCustomersToOrganisation(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult, CustomerOrganization customerOrganisation) {
        Objects.requireNonNull(customerInviteValidationResult, "customerInviteValidationResult");
        Objects.requireNonNull(customerOrganisation, "customerOrganisation");
        return Steps.begin(this.doInviteCustomers(customerInviteValidationResult, true)).then(this::getCheckedUsers).then((inviteCustomerResult, checkedUsers) -> this.inviteCustomerToExistingOrganisation(inviteCustomerResult.getUser(), (Collection<CheckedUser>)checkedUsers, customerInviteValidationResult.getProject(), customerOrganisation)).yield((inviteCustomerResult, checkedUsers, associatedUsers) -> inviteCustomerResult);
    }

    private io.atlassian.fugue.Either<AnError, InviteCustomerResult> doInviteCustomers(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult, boolean invitingToOrganisation) {
        CheckedUser loggedInUser = customerInviteValidationResult.getCheckedUser();
        Project project = customerInviteValidationResult.getProject();
        InviteCustomerResult.Builder builder = InviteCustomerResult.builder(customerInviteValidationResult.getCheckedUser());
        customerInviteValidationResult.getCustomerInviteValidations().forEach(customerInviteValidation -> {
            io.atlassian.fugue.Either<String, CheckedUser> errorUserEither = this.inviteCustomerAndReturnOptionalErrorEither(loggedInUser, project, (CustomerInviteValidation)customerInviteValidation, invitingToOrganisation);
            builder.add((String)errorUserEither.map(CheckedUser::getKey).getOrElse((Object)CustomerInviteValidation.extractKey(customerInviteValidation)), (String)errorUserEither.map(CheckedUser::getEmailAddress).getOrElse((Object)CustomerInviteValidation.extractUsernameOrEmailAddress(customerInviteValidation)), (String)errorUserEither.map(CheckedUser::getDisplayName).getOrElse((Object)CustomerInviteValidation.extractDisplayValue(customerInviteValidation)), (io.atlassian.fugue.Option<String>)errorUserEither.left().toOption());
        });
        return io.atlassian.fugue.Either.right((Object)builder.build());
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> getCheckedUsers(InviteCustomerResult inviteCustomerResult) {
        Set collect = inviteCustomerResult.getSuccessInvites().stream().map(SuccessInviteResult::getKey).map(arg_0 -> ((UserFactory)this.userFactory).wrapUserKey(arg_0)).map(StepsConverters::newerEither).collect(Collectors.toSet());
        return Eithers.sequenceRight(collect).map(Sets::newHashSet);
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> inviteCustomerToNewOrExistingOrganisation(CheckedUser loggedInUser, Collection<CheckedUser> inviteUsers, Project project, String orgName) {
        if (inviteUsers.isEmpty()) {
            return io.atlassian.fugue.Either.right(inviteUsers);
        }
        io.atlassian.fugue.Either invitedUsersEither = this.organizationMemberService.addUsersToNewOrExistingOrganization(loggedInUser, inviteUsers, project, orgName);
        invitedUsersEither.forEach(invitedUsers -> invitedUsers.forEach(invitedUser -> this.handleSendInvitation(loggedInUser, (CheckedUser)invitedUser, project)));
        return invitedUsersEither;
    }

    private io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> inviteCustomerToExistingOrganisation(CheckedUser loggedInUser, Collection<CheckedUser> inviteUsers, Project project, CustomerOrganization customerOrganisation) {
        if (inviteUsers.isEmpty()) {
            return io.atlassian.fugue.Either.right(inviteUsers);
        }
        io.atlassian.fugue.Either invitedUsersEither = this.organizationMemberService.addUsersToExistingOrganization(loggedInUser, inviteUsers, project, customerOrganisation);
        invitedUsersEither.forEach(invitedUsers -> invitedUsers.forEach(invitedUser -> this.handleSendInvitation(loggedInUser, (CheckedUser)invitedUser, project)));
        return invitedUsersEither;
    }

    private List<CustomerInviteValidation> handleDuplicateResults(Iterable<CustomerInviteValidation> customerInviteValidations) {
        HashSet applicationUsersSet = new HashSet();
        HashSet emailAddressSet = new HashSet();
        ArrayList noDuplicatesList = new ArrayList();
        customerInviteValidations.forEach(validation -> {
            ApplicationUser applicationUser = validation.getCustomerInviteUser().getApplicationUser();
            String emailAddress = validation.getCustomerInviteUser().getEmailAddress();
            boolean notADuplicate = (Boolean)io.atlassian.fugue.Option.option((Object)applicationUser).fold(() -> emailAddressSet.add(emailAddress), applicationUsersSet::add);
            if (notADuplicate) {
                noDuplicatesList.add(validation);
                emailAddressSet.add(emailAddress);
            }
        });
        return ImmutableList.copyOf(noDuplicatesList);
    }

    private io.atlassian.fugue.Either<String, CheckedUser> inviteCustomerAndReturnOptionalErrorEither(CheckedUser loggedInUser, Project project, CustomerInviteValidation customerInviteValidation, boolean invitingToOrganisation) {
        if (customerInviteValidation.getCustomerInviteValidationStatus().isValid()) {
            return this.associateCustomerToProjectByEmail(loggedInUser, project, customerInviteValidation.getCustomerInviteUser(), invitingToOrganisation);
        }
        String errorHtml = CustomerInviteValidationStatus.getErrorHtml(loggedInUser.i18NHelper(), this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)loggedInUser), this.customerContextService.isInCustomerContext(), this.customerUrlUtil.getJIRABaseUrl(false), customerInviteValidation);
        return io.atlassian.fugue.Either.left((Object)errorHtml);
    }

    private io.atlassian.fugue.Either<AnError, CustomerInviteValidation> validateNewCustomerForProject(CheckedUser user, Project project, String emailOrUsername) {
        UserSearchParams params = this.userSearchManagerHelper.buildEmailMatcherUserSearchParams(emailOrUsername, UserEmailMatcherActiveState.INCLUDE_INACTIVE_USERS, UserEmailMatcherUsernames.MATCH_USERNAMES);
        return StepsConverters.newerEither((Either)this.userFactory.wrap((Collection)this.userSearchManager.searchUnlimited(emailOrUsername, params).collect(Collectors.toList()))).map(existingUsers -> {
            if (existingUsers.isEmpty()) {
                return this.handleNoExistingUsersValidation(user, project, emailOrUsername);
            }
            return existingUsers.stream().map(potential -> this.findCustomerInviteStatus((CheckedUser)potential, emailOrUsername)).sorted(Comparator.comparing(CustomerInviteValidation::getCustomerInviteValidationStatus)).findFirst().get();
        });
    }

    private CustomerInviteValidation handleNoExistingUsersValidation(CheckedUser user, Project project, String emailAddress) {
        if (!EmailUtil.isEmailAddressValidForNewSignup(emailAddress)) {
            CustomerInviteValidationStatus emailAddressFailure = CustomerInviteValidationStatus.INVALID_NEW_EMAIL_ADDRESS;
            if (EmailUtil.isEmailAddressValid(emailAddress)) {
                emailAddressFailure = CustomerInviteValidationStatus.INVALID_NEW_USERNAME;
            }
            return new CustomerInviteValidation(new CustomerInviteUser(emailAddress), emailAddressFailure, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.none());
        }
        return (CustomerInviteValidation)this.extractOptionalStringErrorFromEither(user, this.signUpManager.validateSignUpCustomerThroughInvite(project, emailAddress, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.none())).swap().toOption().fold(() -> new CustomerInviteValidation(new CustomerInviteUser(emailAddress), CustomerInviteValidationStatus.PASSED, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.none()), error -> new CustomerInviteValidation(new CustomerInviteUser(emailAddress), CustomerInviteValidationStatus.INVALID_FAILED_NEW_USER_CHECKS, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.some((Object)error)));
    }

    private CustomerInviteValidation findCustomerInviteStatus(CheckedUser customer, String emailOrUsername) {
        String username = customer.getName();
        boolean usernameMatch = Objects.equals(emailOrUsername, username);
        CustomerInviteValidationStatus customerInviteValidationStatus = customer.forJIRA().isActive() ? CustomerInviteValidationStatus.PASSED : (this.serviceDeskCrowdUserQueryDslDao.isUserDeletedExternally(customer) ? (usernameMatch || !EmailUtil.isEmailAddressValidForNewSignup(emailOrUsername) ? CustomerInviteValidationStatus.INVALID_USER_EXTERNALLY_DELETED : CustomerInviteValidationStatus.PASSED_CAN_SIGNUP_WITH_EMAIL_BUT_INACTIVE) : CustomerInviteValidationStatus.INVALID_USER_INACTIVE);
        CustomerInviteUser customerInviteUser = customerInviteValidationStatus == CustomerInviteValidationStatus.PASSED_CAN_SIGNUP_WITH_EMAIL_BUT_INACTIVE ? new CustomerInviteUser(emailOrUsername) : new CustomerInviteUser(customer);
        return new CustomerInviteValidation(customerInviteUser, customerInviteValidationStatus, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.none());
    }

    private io.atlassian.fugue.Either<String, CheckedUser> associateCustomerToProjectByEmail(CheckedUser user, Project project, CustomerInviteUser customerInviteUser, boolean invitingToOrganisation) {
        String email;
        Object customerResult = customerInviteUser.getApplicationUser() != null ? this.associateCurrentCustomerAndSendInvite(user, project, customerInviteUser.getApplicationUser(), invitingToOrganisation).leftMap(error -> error.getMessage().getMessage()) : (this.serviceDeskUserManager.isEmailValidForNewCustomer(email = customerInviteUser.getEmailAddress()) ? this.extractOptionalStringErrorFromEither(user, this.associateNewCustomerAndSendInvite(user, project, email, invitingToOrganisation)) : this.associateCurrentCustomerByEmailAndSendInvite(user, project, email, invitingToOrganisation).leftMap(error -> error.getMessage().getMessage()));
        return customerResult;
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> associateNewCustomerAndSendInvite(CheckedUser user, Project project, String email, boolean invitingToOrganisation) {
        io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, CheckedUser>> newCustomerResult = this.signUpManager.signUpCustomerThroughInvite(project, email, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.none(), invitingToOrganisation);
        if (!invitingToOrganisation) {
            newCustomerResult.forEach(customerEither -> customerEither.forEach(customer -> this.handleSendInvitation(user, (CheckedUser)customer, project)));
        }
        return newCustomerResult;
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> associateCurrentCustomerByEmailAndSendInvite(CheckedUser user, Project project, String email, boolean invitingToOrganisation) {
        UserSearchParams emailParams = this.userSearchManagerHelper.buildEmailMatcherUserSearchParams(email, UserEmailMatcherActiveState.ACTIVE_USERS_ONLY, UserEmailMatcherUsernames.MATCH_USERNAMES);
        return Steps.begin((io.atlassian.fugue.Either)this.userSearchManager.searchFirstUser(email, emailParams).toRight(this::USER_NOT_FOUND_ERROR)).then(customer -> StepsConverters.newerEither((Either)this.userFactory.wrap(customer).leftMap(ignoredError -> this.USER_NOT_FOUND_ERROR()))).then((customer, checkedCustomer) -> this.optionallyInviteUser(user, (CheckedUser)checkedCustomer, project, invitingToOrganisation)).yield((customer, checkedCustomer, updatedCustomer) -> updatedCustomer);
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> associateCurrentCustomerAndSendInvite(CheckedUser user, Project project, ApplicationUser applicationUser, boolean invitingToOrganisation) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser))).then(customer -> this.optionallyInviteUser(user, (CheckedUser)customer, project, invitingToOrganisation)).yield((customer, updatedCustomer) -> updatedCustomer);
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, CheckedUser> optionallyInviteUser(CheckedUser user, CheckedUser customer, Project project, boolean addingToOrganisation) {
        if (addingToOrganisation) {
            return io.atlassian.fugue.Either.right((Object)customer);
        }
        io.atlassian.fugue.Either<AnError, Boolean> addedToProjectResult = this.customerManager.addCustomerToProject(user.forJIRA(), project, customer);
        if (addedToProjectResult.isRight()) {
            this.handleSendInvitation(user, customer, project);
        }
        return addedToProjectResult.map(addedToProject -> customer);
    }

    private void handleSendInvitation(CheckedUser user, CheckedUser customer, Project project) {
        if (this.serviceDeskNotificationInternalSender.isOutgoingMailConfigured()) {
            this.inviteService.sendCustomerInviteIfUserNeverLoggedIn(user, customer, project);
        }
    }

    private String convertAnErrorToStringError(CheckedUser user, AnError anError) {
        return (String)StepsConverters.newerOption((Option)anError.getMessage().getI18n()).map(i18n -> user.i18NHelper().getText(i18n.getI18nKey(), (Object)i18n.getParams())).orElse(() -> io.atlassian.fugue.Option.option((Object)anError.getMessage().getMessage())).getOrElse((Object)user.i18NHelper().getText("sd.user.error.unknown.user.signup.validate"));
    }

    private <T> io.atlassian.fugue.Either<String, T> convertValidationErrorsEither(CheckedUser user, io.atlassian.fugue.Either<ValidationErrors, T> either) {
        if (either.isRight()) {
            return io.atlassian.fugue.Either.right((Object)either.right().get());
        }
        ValidationErrors errors = (ValidationErrors)either.left().get();
        I18nHelper i18nHelper = user.i18NHelper();
        return io.atlassian.fugue.Either.left((Object)io.atlassian.fugue.Iterables.first((Iterable)errors.getErrorMessages().stream().map(message -> this.errorTranslationHelper.translateErrorMessage(message, i18nHelper)).collect(Collectors.toList())).orElse(() -> io.atlassian.fugue.Iterables.first(errors.getFieldErrors().entrySet()).map(entry -> (String)entry.getKey() + " : " + this.errorTranslationHelper.translateErrorMessage((ErrorMessage)entry.getValue(), i18nHelper))).getOrElse((Object)i18nHelper.getText("sd.user.error.unknown.user.signup.validate")));
    }

    private <T> io.atlassian.fugue.Either<String, T> extractOptionalStringErrorFromEither(CheckedUser user, io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, T>> either) {
        return either.leftMap(anError -> this.convertAnErrorToStringError(user, (AnError)anError)).flatMap(right -> this.convertValidationErrorsEither(user, (io.atlassian.fugue.Either)right));
    }

    private AnError USER_NOT_FOUND_ERROR() {
        return this.errorResultHelper.badRequest400("sd.agent.people.customers.invite.error.user.not.found", new Object[0]).build();
    }
}

